/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters.groovy;

import groovy.lang.Closure;
import groovy.util.slurpersupport.GPathResult;
import java.util.regex.Pattern;
import org.fao.geonet.api.records.formatters.groovy.Handler;
import org.fao.geonet.api.records.formatters.groovy.TransformationContext;

public class HandlerNameSelect
extends Handler {
    private final Pattern namePattern;

    public HandlerNameSelect(Pattern namePattern, int priority, Closure handler) {
        super(priority, handler);
        this.namePattern = namePattern;
        this.setName(namePattern.toString());
    }

    @Override
    public boolean select(TransformationContext rootPath, GPathResult element) {
        String qualifiedName = element.name();
        return this.namePattern.matcher(qualifiedName).matches();
    }

    @Override
    protected String handlerExtraToString() {
        return ", namePattern ~= /" + this.namePattern + "/";
    }
}

