/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.attachments;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.records.attachments.Sort;
import org.fao.geonet.api.records.attachments.SortConverter;
import org.fao.geonet.api.records.attachments.Store;
import org.fao.geonet.domain.MetadataResource;
import org.fao.geonet.domain.MetadataResourceVisibility;
import org.fao.geonet.domain.MetadataResourceVisibilityConverter;
import org.fao.geonet.events.history.AttachmentAddedEvent;
import org.fao.geonet.events.history.AttachmentDeletedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import springfox.documentation.annotations.ApiIgnore;

@EnableWebMvc
@Service
@RequestMapping(value={"/{portal}/api/records/{metadataUuid}/attachments", "/{portal}/api/0.1/records/{metadataUuid}/attachments"})
@Api(value="records", tags={"records"}, description="Metadata record operations")
public class AttachmentsApi {
    private final ApplicationContext appContext = ApplicationContextHolder.get();
    private Store store;

    public AttachmentsApi() {
    }

    public AttachmentsApi(Store store) {
        this.store = store;
    }

    public static String getFileContentType(Path file) throws IOException {
        String contentType = Files.probeContentType(file);
        if (contentType == null) {
            String ext;
            switch (ext = FilenameUtils.getExtension((String)file.getFileName().toString()).toLowerCase()) {
                case "png": 
                case "gif": 
                case "bmp": 
                case "tif": 
                case "tiff": 
                case "jpg": 
                case "jpeg": {
                    contentType = "image/" + ext;
                    break;
                }
                case "txt": 
                case "html": {
                    contentType = "text/" + ext;
                    break;
                }
                default: {
                    contentType = "application/" + ext;
                }
            }
        }
        return contentType;
    }

    public Store getStore() {
        return this.store;
    }

    public void setStore(Store store) {
        this.store = store;
    }

    @PostConstruct
    public void init() {
        if (this.appContext != null) {
            this.store = (Store)this.appContext.getBean("resourceStore", Store.class);
        }
    }

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(MetadataResourceVisibility.class, (PropertyEditor)new MetadataResourceVisibilityConverter());
        binder.registerCustomEditor(Sort.class, (PropertyEditor)new SortConverter());
    }

    public List<MetadataResource> getResources() {
        return null;
    }

    @ApiOperation(value="List all metadata attachments", notes="<a href='http://geonetwork-opensource.org/manuals/trunk/eng/users/user-guide/associating-resources/using-filestore.html'>More info</a>", nickname="getAllMetadataResources")
    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="Return the record attachments."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to view the resource.")})
    @ResponseBody
    public List<MetadataResource> getAllResources(@ApiParam(value="The metadata UUID", required=true, example="43d7c186-2187-4bcd-8843-41e575a5ef56") @PathVariable String metadataUuid, @ApiParam(value="Sort by", example="type") @RequestParam(required=false, defaultValue="name") Sort sort, @ApiParam(value="Use approved version or not", example="true") @RequestParam(required=false, defaultValue="true") Boolean approved, @RequestParam(required=false, defaultValue="*.*") String filter, @ApiIgnore HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        List list = this.store.getResources(context, metadataUuid, sort, filter, approved);
        return list;
    }

    @ApiOperation(value="Delete all uploaded metadata resources", nickname="deleteAllMetadataResources")
    @RequestMapping(method={RequestMethod.DELETE}, produces={"application/json"})
    @PreAuthorize(value="hasRole('Editor')")
    @ApiResponses(value={@ApiResponse(code=204, message="Attachment added."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void delResources(@ApiParam(value="The metadata UUID", required=true, example="43d7c186-2187-4bcd-8843-41e575a5ef56") @PathVariable String metadataUuid, @ApiParam(value="Use approved version or not", example="true") @RequestParam(required=false, defaultValue="false") Boolean approved, @ApiIgnore HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        this.store.delResources(context, metadataUuid, approved);
        String metadataIdString = ApiUtils.getInternalId(metadataUuid, approved);
        if (metadataIdString != null) {
            long metadataId = Long.parseLong(metadataIdString);
            UserSession userSession = ApiUtils.getUserSession(request.getSession());
            new AttachmentDeletedEvent(Long.valueOf(metadataId), Integer.valueOf(userSession.getUserIdAsInt()), "All attachments").publish((ApplicationContext)ApplicationContextHolder.get());
        }
    }

    @ApiOperation(value="Create a new resource for a given metadata", nickname="putResourceFromFile")
    @PreAuthorize(value="hasRole('Editor')")
    @RequestMapping(method={RequestMethod.POST}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiResponses(value={@ApiResponse(code=201, message="Attachment uploaded."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseBody
    public MetadataResource putResource(@ApiParam(value="The metadata UUID", required=true, example="43d7c186-2187-4bcd-8843-41e575a5ef56") @PathVariable String metadataUuid, @ApiParam(value="The sharing policy", example="public") @RequestParam(required=false, defaultValue="public") MetadataResourceVisibility visibility, @ApiParam(value="The file to upload") @RequestParam(value="file") MultipartFile file, @ApiParam(value="Use approved version or not", example="true") @RequestParam(required=false, defaultValue="false") Boolean approved, @ApiIgnore HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        MetadataResource resource = this.store.putResource(context, metadataUuid, file, visibility, approved);
        String metadataIdString = ApiUtils.getInternalId(metadataUuid, approved);
        if (metadataIdString != null && file != null && !file.isEmpty()) {
            long metadataId = Long.parseLong(metadataIdString);
            UserSession userSession = ApiUtils.getUserSession(request.getSession());
            new AttachmentAddedEvent(Long.valueOf(metadataId), Integer.valueOf(userSession.getUserIdAsInt()), file.getOriginalFilename()).publish((ApplicationContext)ApplicationContextHolder.get());
        }
        return resource;
    }

    @ApiOperation(value="Create a new resource from a URL for a given metadata", nickname="putResourcesFromURL", produces="application/json")
    @PreAuthorize(value="hasRole('Editor')")
    @RequestMapping(method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiResponses(value={@ApiResponse(code=201, message="Attachment added."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseBody
    public MetadataResource putResourceFromURL(@ApiParam(value="The metadata UUID", required=true, example="43d7c186-2187-4bcd-8843-41e575a5ef56") @PathVariable String metadataUuid, @ApiParam(value="The sharing policy", example="public") @RequestParam(required=false, defaultValue="public") MetadataResourceVisibility visibility, @ApiParam(value="The URL to load in the store") @RequestParam(value="url") URL url, @ApiParam(value="Use approved version or not", example="true") @RequestParam(required=false, defaultValue="false") Boolean approved, @ApiIgnore HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        MetadataResource resource = this.store.putResource(context, metadataUuid, url, visibility, approved);
        String metadataIdString = ApiUtils.getInternalId(metadataUuid, approved);
        if (metadataIdString != null && url != null) {
            long metadataId = Long.parseLong(metadataIdString);
            UserSession userSession = ApiUtils.getUserSession(request.getSession());
            new AttachmentAddedEvent(Long.valueOf(metadataId), Integer.valueOf(userSession.getUserIdAsInt()), url.toString()).publish((ApplicationContext)ApplicationContextHolder.get());
        }
        return resource;
    }

    @ApiOperation(value="Get a metadata resource", nickname="getResource")
    @RequestMapping(value={"/{resourceId:.+}"}, method={RequestMethod.GET})
    @ApiResponses(value={@ApiResponse(code=201, message="Record attachment."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to download the resource.")})
    public void getResource(@ApiParam(value="The metadata UUID", required=true, example="43d7c186-2187-4bcd-8843-41e575a5ef56") @PathVariable String metadataUuid, @ApiParam(value="The resource identifier (ie. filename)", required=true) @PathVariable String resourceId, @ApiParam(value="Use approved version or not", example="true") @RequestParam(required=false, defaultValue="true") Boolean approved, @ApiIgnore HttpServletRequest request, @ApiIgnore HttpServletResponse response) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        try (Store.ResourceHolder file = this.store.getResource(context, metadataUuid, resourceId, approved);){
            ApiUtils.canViewRecord(metadataUuid, request);
            response.addHeader("Content-Disposition", "inline; filename=\"" + file.getMetadata().getFilename() + "\"");
            response.addHeader("Cache-Control", "no-cache");
            response.setContentType(AttachmentsApi.getFileContentType(file.getPath()));
            response.setContentLengthLong(Files.size(file.getPath()));
            response.setStatus(HttpStatus.OK.value());
            ServletOutputStream outputStream = response.getOutputStream();
            FileUtils.copyFile((File)file.getPath().toFile(), (OutputStream)outputStream);
        }
    }

    @ApiOperation(value="Update the metadata resource visibility", nickname="patchMetadataResourceVisibility")
    @PreAuthorize(value="hasRole('Editor')")
    @ApiResponses(value={@ApiResponse(code=201, message="Attachment visibility updated."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @RequestMapping(value={"/{resourceId:.+}"}, method={RequestMethod.PATCH}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public MetadataResource patchResource(@ApiParam(value="The metadata UUID", required=true, example="43d7c186-2187-4bcd-8843-41e575a5ef56") @PathVariable String metadataUuid, @ApiParam(value="The resource identifier (ie. filename)", required=true) @PathVariable String resourceId, @ApiParam(value="The visibility", required=true, example="public") @RequestParam(required=true) MetadataResourceVisibility visibility, @ApiParam(value="Use approved version or not", example="true") @RequestParam(required=false, defaultValue="false") Boolean approved, @ApiIgnore HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        return this.store.patchResourceStatus(context, metadataUuid, resourceId, visibility, approved);
    }

    @ApiOperation(value="Delete a metadata resource", nickname="deleteMetadataResource")
    @PreAuthorize(value="hasRole('Editor')")
    @RequestMapping(value={"/{resourceId:.+}"}, method={RequestMethod.DELETE})
    @ApiResponses(value={@ApiResponse(code=204, message="Attachment visibility removed."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void delResource(@ApiParam(value="The metadata UUID", required=true, example="43d7c186-2187-4bcd-8843-41e575a5ef56") @PathVariable String metadataUuid, @ApiParam(value="The resource identifier (ie. filename)", required=true) @PathVariable String resourceId, @ApiParam(value="Use approved version or not", example="true") @RequestParam(required=false, defaultValue="false") Boolean approved, @ApiIgnore HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        this.store.delResource(context, metadataUuid, resourceId, approved);
        String metadataIdString = ApiUtils.getInternalId(metadataUuid, approved);
        if (metadataIdString != null) {
            long metadataId = Long.parseLong(metadataIdString);
            UserSession userSession = ApiUtils.getUserSession(request.getSession());
            new AttachmentDeletedEvent(Long.valueOf(metadataId), Integer.valueOf(userSession.getUserIdAsInt()), resourceId).publish((ApplicationContext)ApplicationContextHolder.get());
        }
    }
}

