/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jeeves.server.context.ServiceContext;
import jeeves.services.ReadWriteController;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.NotAllowedException;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.records.MetadataUtils;
import org.fao.geonet.api.records.model.related.FCRelatedMetadataItem;
import org.fao.geonet.api.records.model.related.FeatureResponse;
import org.fao.geonet.api.records.model.related.RelatedItemType;
import org.fao.geonet.api.records.model.related.RelatedResponse;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.mef.MEFLib;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/records", "/{portal}/api/0.1/records"})
@Api(value="records", tags={"records"}, description="Metadata record operations")
@Controller(value="records")
@ReadWriteController
public class MetadataApi {
    @Autowired
    SchemaManager _schemaManager;
    @Autowired
    LanguageUtils languageUtils;
    @Autowired
    DataManager dataManager;
    @Autowired
    MetadataRepository metadataRepository;
    @Autowired
    IMetadataUtils metadataUtils;
    @Autowired
    GeonetworkDataDirectory dataDirectory;
    private ApplicationContext context;

    public synchronized void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }

    @ApiOperation(value="Get a metadata record", notes="Depending on the accept header the appropriate formatter is used. When requesting a ZIP, a MEF version 2 file is returned. When requesting HTML, the default formatter is used.", nickname="getRecord")
    @RequestMapping(value={"/{metadataUuid:.+}"}, method={RequestMethod.GET}, consumes={"*/*"}, produces={"text/html", "application/xml", "application/xhtml+xml", "application/json", "application/pdf", "application/zip", "application/x-gn-mef-1-zip", "application/x-gn-mef-2-zip", "*/*"})
    @ApiResponses(value={@ApiResponse(code=200, message="Return the record."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to view the resource."), @ApiResponse(code=404, message="Resource not found.")})
    public String getRecord(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @ApiParam(value="Accept header should indicate which is the appropriate format to return. It could be text/html, application/xml, application/zip, ...If no appropriate Accept header found, the XML format is returned.", required=true) @RequestHeader(value="Accept", defaultValue="application/xml", required=false) String acceptHeader, HttpServletResponse response, HttpServletRequest request) throws Exception {
        try {
            ApiUtils.canViewRecord(metadataUuid, request);
        }
        catch (SecurityException e) {
            Log.debug((String)"geonetwork.api", (Object)e.getMessage(), (Exception)e);
            throw new NotAllowedException("Operation not allowed. User needs to be able to view the resource.");
        }
        List<String> accept = Arrays.asList(acceptHeader.split(","));
        String defaultFormatter = "xsl-view";
        if (accept.contains("text/html") || accept.contains("application/xhtml+xml") || accept.contains("application/pdf")) {
            return "forward:" + metadataUuid + "/formatters/" + defaultFormatter;
        }
        if (accept.contains("application/xml") || accept.contains("application/json")) {
            return "forward:" + metadataUuid + "/formatters/xml";
        }
        if (accept.contains("application/zip") || accept.contains("application/x-gn-mef-1-zip") || accept.contains("application/x-gn-mef-2-zip")) {
            return "forward:" + metadataUuid + "/formatters/zip";
        }
        response.setHeader("Accept", "application/xhtml+xml");
        return "forward:" + metadataUuid + "/formatters/" + defaultFormatter;
    }

    @ApiOperation(value="Get a metadata record as XML or JSON", notes="", nickname="getRecordAsXmlOrJSON")
    @RequestMapping(value={"/{metadataUuid}/formatters/xml", "/{metadataUuid}/formatters/json"}, method={RequestMethod.GET}, produces={"application/xml", "application/json; charset=utf-8"})
    @ApiResponses(value={@ApiResponse(code=200, message="Return the record."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to view the resource.")})
    @ResponseBody
    public Object getRecordAsXML(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @ApiParam(value="Add XSD schema location based on standard configuration (see schema-ident.xml).", required=false) @RequestParam(required=false, defaultValue="true") boolean addSchemaLocation, @ApiParam(value="Increase record popularity", required=false) @RequestParam(required=false, defaultValue="true") boolean increasePopularity, @ApiParam(value="Add geonet:info details", required=false) @RequestParam(required=false, defaultValue="false") boolean withInfo, @ApiParam(value="Download as a file", required=false) @RequestParam(required=false, defaultValue="false") boolean attachment, @ApiParam(value="Download the approved version", required=false, defaultValue="true") @RequestParam(required=false, defaultValue="true") boolean approved, @RequestHeader(value="Accept", defaultValue="application/xml") String acceptHeader, HttpServletResponse response, HttpServletRequest request) throws Exception {
        Attribute schemaLocAtt;
        Element xml;
        AbstractMetadata metadata;
        try {
            metadata = ApiUtils.canViewRecord(metadataUuid, request);
        }
        catch (ResourceNotFoundException e) {
            Log.debug((String)"geonetwork.api", (Object)e.getMessage(), (Exception)((Object)e));
            throw e;
        }
        catch (Exception e) {
            Log.debug((String)"geonetwork.api", (Object)e.getMessage(), (Exception)e);
            throw new NotAllowedException("Operation not allowed. User needs to be able to view the resource.");
        }
        ServiceContext context = ApiUtils.createServiceContext(request);
        try {
            Lib.resource.checkPrivilege(context, String.valueOf(metadata.getId()), ReservedOperation.view);
        }
        catch (Exception e) {
            Log.debug((String)"geonetwork.api", (Object)e.getMessage(), (Exception)e);
            throw new NotAllowedException("Operation not allowed. User needs to be able to view the resource.");
        }
        if (increasePopularity) {
            this.dataManager.increasePopularity(context, metadata.getId() + "");
        }
        boolean withValidationErrors = false;
        boolean keepXlinkAttributes = false;
        boolean forEditing = false;
        String mdId = String.valueOf(metadata.getId());
        if (approved) {
            mdId = String.valueOf(this.metadataRepository.findOneByUuid(metadata.getUuid()).getId());
        }
        Element element = xml = withInfo ? this.dataManager.getMetadata(context, mdId, forEditing, withValidationErrors, keepXlinkAttributes) : this.dataManager.getMetadataNoInfo(context, mdId + "");
        if (addSchemaLocation && (schemaLocAtt = this._schemaManager.getSchemaLocation(metadata.getDataInfo().getSchemaId(), context)) != null && xml.getAttribute(schemaLocAtt.getName(), schemaLocAtt.getNamespace()) == null) {
            xml.setAttribute(schemaLocAtt);
            xml.removeNamespaceDeclaration(schemaLocAtt.getNamespace());
            xml.addNamespaceDeclaration(schemaLocAtt.getNamespace());
        }
        boolean isJson = acceptHeader.contains("application/json");
        String mode = attachment ? "attachment" : "inline";
        response.setHeader("Content-Disposition", String.format(mode + "; filename=\"%s.%s\"", metadata.getUuid(), isJson ? "json" : "xml"));
        return isJson ? Xml.getJSON((Element)xml) : xml;
    }

    @ApiOperation(value="Get a metadata record as ZIP", notes="Metadata Exchange Format (MEF) is returned. MEF is a ZIP file containing the metadata as XML and some others files depending on the version requested. See http://geonetwork-opensource.org/manuals/trunk/eng/users/annexes/mef-format.html.", nickname="getRecordAsZip")
    @RequestMapping(value={"/{metadataUuid}/formatters/zip"}, method={RequestMethod.GET}, consumes={"*/*"}, produces={"application/zip", "application/x-gn-mef-1-zip", "application/x-gn-mef-2-zip"})
    @ApiResponses(value={@ApiResponse(code=200, message="Return the record."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to view the resource.")})
    @ResponseBody
    public void getRecordAsZip(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @ApiParam(value="MEF file format.", required=false) @RequestParam(required=false, defaultValue="FULL") MEFLib.Format format, @ApiParam(value="With related records (parent and service).", required=false) @RequestParam(required=false, defaultValue="true") boolean withRelated, @ApiParam(value="Resolve XLinks in the records.", required=false) @RequestParam(required=false, defaultValue="true") boolean withXLinksResolved, @ApiParam(value="Preserve XLink URLs in the records.", required=false) @RequestParam(required=false, defaultValue="false") boolean withXLinkAttribute, @RequestParam(required=false, defaultValue="true") boolean addSchemaLocation, @ApiParam(value="Download the approved version", required=false) @RequestParam(required=false, defaultValue="true") boolean approved, @RequestHeader(value="Accept", defaultValue="application/x-gn-mef-2-zip") String acceptHeader, HttpServletResponse response, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata;
        try {
            metadata = ApiUtils.canViewRecord(metadataUuid, request);
        }
        catch (SecurityException e) {
            Log.debug((String)"geonetwork.api", (Object)e.getMessage(), (Exception)e);
            throw new NotAllowedException("Operation not allowed. User needs to be able to view the resource.");
        }
        Path stylePath = this.dataDirectory.getWebappDir().resolve("xml/schemas/");
        Path file = null;
        ServiceContext context = ApiUtils.createServiceContext(request);
        MEFLib.Version version = MEFLib.Version.find((String)acceptHeader);
        if (version == MEFLib.Version.V1) {
            boolean skipUUID = false;
            Integer id = -1;
            id = approved ? Integer.valueOf(this.metadataRepository.findOneByUuid(metadataUuid).getId()) : Integer.valueOf(this.metadataUtils.findOneByUuid(metadataUuid).getId());
            file = MEFLib.doExport((ServiceContext)context, (Integer)id, (String)format.toString(), (boolean)skipUUID, (boolean)withXLinksResolved, (boolean)withXLinkAttribute, (boolean)addSchemaLocation);
            response.setContentType("application/x-gn-mef-1-zip");
        } else {
            HashSet<String> tmpUuid = new HashSet<String>();
            tmpUuid.add(metadataUuid);
            if (withRelated) {
                Element childRequest = new Element("request");
                childRequest.addContent((Content)new Element("parentUuid").setText(metadataUuid));
                childRequest.addContent((Content)new Element("to").setText("1000"));
                Set<String> childs = MetadataUtils.getUuidsToExport(metadataUuid, request, childRequest);
                if (childs.size() != 0) {
                    tmpUuid.addAll(childs);
                }
                Element servicesRequest = new Element("request");
                servicesRequest.addContent((Content)new Element("operatesOn").setText(metadataUuid));
                servicesRequest.addContent((Content)new Element("type").setText("service"));
                Set<String> services = MetadataUtils.getUuidsToExport(metadataUuid, request, servicesRequest);
                if (services.size() != 0) {
                    tmpUuid.addAll(services);
                }
            }
            Log.info((String)"geonetwork.mef", (Object)("Building MEF2 file with " + tmpUuid.size() + " records."));
            file = MEFLib.doMEF2Export((ServiceContext)context, tmpUuid, (String)format.toString(), (boolean)false, (Path)stylePath, (boolean)withXLinksResolved, (boolean)withXLinkAttribute, (boolean)false, (boolean)addSchemaLocation, (boolean)approved);
            response.setContentType("application/x-gn-mef-2-zip");
        }
        response.setHeader("Content-Disposition", String.format("inline; filename=\"%s.zip\"", metadata.getUuid()));
        response.setHeader("Content-Length", String.valueOf(Files.size(file)));
        FileUtils.copyFile((File)file.toFile(), (OutputStream)response.getOutputStream());
    }

    @ApiOperation(value="Increase record popularity", notes="Used when a view is based on the search results content and does not really access the record. Record is then added to the indexing queue and popularity will be updated soon.", nickname="increaseRecordPopularity")
    @RequestMapping(value={"/{metadataUuid:.+}/popularity"}, method={RequestMethod.POST}, consumes={"*/*"})
    @ApiResponses(value={@ApiResponse(code=201, message="Popularity updated."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to view the resource."), @ApiResponse(code=404, message="Resource not found.")})
    @ResponseStatus(value=HttpStatus.CREATED)
    public void getRecord(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata;
        try {
            metadata = ApiUtils.canViewRecord(metadataUuid, request);
        }
        catch (ResourceNotFoundException e) {
            Log.debug((String)"geonetwork.api", (Object)e.getMessage(), (Exception)((Object)e));
            throw e;
        }
        catch (Exception e) {
            Log.debug((String)"geonetwork.api", (Object)e.getMessage(), (Exception)e);
            throw new NotAllowedException("Operation not allowed. User needs to be able to view the resource.");
        }
        ServiceContext context = ApiUtils.createServiceContext(request);
        this.dataManager.increasePopularity(context, metadata.getId() + "");
    }

    @ApiOperation(value="Get record related resources", nickname="getAssociated", notes="Retrieve related services, datasets, onlines, thumbnails, sources, ... to this records.<br/><a href='http://geonetwork-opensource.org/manuals/trunk/eng/users/user-guide/associating-resources/index.html'>More info</a>")
    @RequestMapping(value={"/{metadataUuid:.+}/related"}, method={RequestMethod.GET}, produces={"application/xml", "application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="Return the associated resources."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to view the resource.")})
    @ResponseBody
    public RelatedResponse getRelated(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @ApiParam(value="Type of related resource. If none, all resources are returned.", required=false) @RequestParam(defaultValue="") RelatedItemType[] type, @ApiParam(value="Start offset for paging. Default 1. Only applies to related metadata records (ie. not for thumbnails).", required=false) @RequestParam(defaultValue="1") int start, @ApiParam(value="Number of rows returned. Default 100.") @RequestParam(defaultValue="100") int rows, HttpServletRequest request) throws Exception {
        AbstractMetadata md;
        try {
            md = ApiUtils.canViewRecord(metadataUuid, request);
        }
        catch (SecurityException e) {
            Log.debug((String)"geonetwork.api", (Object)e.getMessage(), (Exception)e);
            throw new NotAllowedException("Operation not allowed. User needs to be able to view the resource.");
        }
        String language = this.languageUtils.getIso3langCode(request.getLocales());
        ServiceContext context = ApiUtils.createServiceContext(request);
        Element raw = new Element("root").addContent(Arrays.asList(new Element("gui").addContent(Arrays.asList(new Element("language").setText(language), new Element("url").setText(context.getBaseUrl()))), MetadataUtils.getRelated(context, md.getId(), md.getUuid(), type, start, start + rows, true)));
        Path relatedXsl = this.dataDirectory.getWebappDir().resolve("xslt/services/metadata/relation.xsl");
        Element transform = Xml.transform((Element)raw, (Path)relatedXsl);
        RelatedResponse response = (RelatedResponse)Xml.unmarshall((Element)transform, RelatedResponse.class);
        return response;
    }

    @ApiOperation(value="Returns a map to decode attributes in a dataset (from the associated feature catalog)", nickname="getFeatureCatalog", notes="Retrieve related services, datasets, onlines, thumbnails, sources, ... to this records.<br/><a href='http://geonetwork-opensource.org/manuals/trunk/eng/users/user-guide/associating-resources/index.html'>More info</a>")
    @RequestMapping(value={"/{metadataUuid}/featureCatalog"}, method={RequestMethod.GET}, produces={"application/xml", "application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="Return the associated resources."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to view the resource.")})
    @ResponseBody
    public FeatureResponse getFeatureCatalog(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, HttpServletRequest request) throws ResourceNotFoundException {
        RelatedItemType[] type = new RelatedItemType[]{RelatedItemType.fcats};
        FeatureResponse response = new FeatureResponse();
        HashMap<String, String[]> decodeMap = new HashMap<String, String[]>();
        try {
            RelatedResponse related = this.getRelated(metadataUuid, type, 0, 100, request);
            if (this.isIncludedAttributeTable(related.getFcats())) {
                for (FCRelatedMetadataItem.FeatureType.AttributeTable.Element element : related.getFcats().getItem().get(0).getFeatureType().getAttributeTable().getElement()) {
                    String[] decodedValues;
                    if (StringUtils.isNotBlank((String)element.getCode())) {
                        if (decodeMap.containsKey(element.getCode())) continue;
                        decodedValues = new String[]{element.getName(), element.getDefinition()};
                        decodeMap.put(element.getCode(), decodedValues);
                        continue;
                    }
                    if (decodeMap.containsKey(element.getName())) continue;
                    decodedValues = new String[]{element.getName(), element.getDefinition()};
                    decodeMap.put(element.getName(), decodedValues);
                }
            }
            response.setDecodeMap(decodeMap);
            return response;
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.api", (Object)e.getMessage(), (Throwable)e);
            throw new ResourceNotFoundException();
        }
    }

    private boolean isIncludedAttributeTable(RelatedResponse.Fcat fcat) {
        return fcat != null && fcat.getItem() != null && fcat.getItem().size() > 0 && fcat.getItem().get(0).getFeatureType() != null && fcat.getItem().get(0).getFeatureType().getAttributeTable() != null && fcat.getItem().get(0).getFeatureType().getAttributeTable().getElement() != null;
    }
}

