/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.csw;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.io.Serializable;
import java.util.List;
import jeeves.server.JeevesEngine;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.domain.Service;
import org.fao.geonet.repository.ServiceRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/csw/virtuals", "/{portal}/api/0.1/csw/virtuals"})
@Api(value="csw", tags={"csw"}, description="Virtual CSW operations")
@Controller(value="cswVirtual")
public class VirtualCswApi {
    public static final String API_PARAM_CSW_SERVICE_IDENTIFIER = "Service identifier";
    public static final String API_PARAM_CSW_SERVICE_DETAILS = "Service details";
    @Autowired
    private ServiceRepository serviceRepository;

    @ApiOperation(value="Get virtual CSW services", notes="Virtual CSWs are created to easily setup services providing access to records without the need to define filters. For example, in Europe, local, regional and national organizations define entry point for records in the scope of the INSPIRE directive. Those services can then be easily harvested to exchange information. Virtual CSWs do not support transaction. For this use the main catalog CSW service.", nickname="getAllVirtualCsw")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public List<Service> getAllVirtualCsw() throws Exception {
        return this.serviceRepository.findAll();
    }

    @ApiOperation(value="Get a virtual CSW", notes="", nickname="getVirtualCsw")
    @RequestMapping(path={"/{identifier}"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=404, message="Resource not found.")})
    @ResponseBody
    public Service getVirtualCsw(@ApiParam(value="Service identifier", required=true) @PathVariable int identifier) throws Exception {
        Service service = (Service)this.serviceRepository.findOne((Serializable)Integer.valueOf(identifier));
        if (service == null) {
            throw new ResourceNotFoundException(String.format("Virtual CSW with id '%d' does not exist.", identifier));
        }
        return service;
    }

    @ApiOperation(value="Add a virtual CSW", notes="The service name MUST be unique. An exception is returned if not the case.", authorizations={@Authorization(value="basicAuth")}, nickname="addVirtualCsw")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.CREATED)
    @PreAuthorize(value="hasRole('Administrator')")
    @ApiResponses(value={@ApiResponse(code=201, message="Return the identifier of the newly created service"), @ApiResponse(code=404, message="A service already exist with this name"), @ApiResponse(code=403, message="Operation not allowed. Only Administrator can access it.")})
    @ResponseBody
    public ResponseEntity<Integer> addVirtualCsw(@ApiParam(value="Service details", required=true) @RequestBody Service service) throws Exception {
        Service existing = this.serviceRepository.findOneByName(service.getName());
        if (existing != null) {
            throw new IllegalArgumentException(String.format("A service already exist with this name '%s'. Choose another name.", service.getName()));
        }
        service.getParameters().forEach(p -> p.setService(service));
        this.serviceRepository.save((Object)service);
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        ((JeevesEngine)applicationContext.getBean(JeevesEngine.class)).loadConfigDB((ApplicationContext)applicationContext, service.getId());
        return new ResponseEntity((Object)service.getId(), HttpStatus.CREATED);
    }

    @ApiOperation(value="Update a virtual CSW", notes="", authorizations={@Authorization(value="basicAuth")}, nickname="updateVirtualCsw")
    @RequestMapping(path={"/{identifier}"}, produces={"application/json"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @PreAuthorize(value="hasRole('Administrator')")
    @ApiResponses(value={@ApiResponse(code=204, message="Service updated."), @ApiResponse(code=404, message="Resource not found."), @ApiResponse(code=403, message="Operation not allowed. Only Administrator can access it.")})
    public void updateVirtualCsw(@ApiParam(value="Service identifier", required=true) @PathVariable int identifier, @ApiParam(value="Service details", required=true) @RequestBody Service service) throws Exception {
        Service existing = (Service)this.serviceRepository.findOne((Serializable)Integer.valueOf(identifier));
        if (existing == null) {
            throw new ResourceNotFoundException(String.format("Virtual CSW with id '%d' does not exist.", identifier));
        }
        service.getParameters().forEach(p -> p.setService(service));
        this.serviceRepository.save((Object)service);
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        ((JeevesEngine)applicationContext.getBean(JeevesEngine.class)).loadConfigDB((ApplicationContext)applicationContext, identifier);
    }

    @ApiOperation(value="Remove a virtual CSW", notes="After removal, all virtual CSW configuration is reloaded.", authorizations={@Authorization(value="basicAuth")}, nickname="deleteVirtualCsw")
    @RequestMapping(path={"/{identifier}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @PreAuthorize(value="hasRole('Administrator')")
    @ApiResponses(value={@ApiResponse(code=204, message="Service removed."), @ApiResponse(code=404, message="Resource not found."), @ApiResponse(code=403, message="Operation not allowed. Only Administrator can access it.")})
    public void deleteVirtualCsw(@ApiParam(value="Service identifier", required=true) @PathVariable int identifier) throws Exception {
        Service existing = (Service)this.serviceRepository.findOne((Serializable)Integer.valueOf(identifier));
        if (existing == null) {
            throw new ResourceNotFoundException(String.format("Virtual CSW with id '%d' does not exist.", identifier));
        }
        this.serviceRepository.delete((Serializable)Integer.valueOf(identifier));
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        ((JeevesEngine)applicationContext.getBean(JeevesEngine.class)).loadConfigDB((ApplicationContext)applicationContext, Integer.valueOf(identifier).intValue());
    }
}

