/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class AllRequestsInterceptor
extends HandlerInterceptorAdapter {
    private final String BOT_REGEXP_FILTER_DEFAULT = ".*(bot|crawler|baiduspider|80legs|ia_archiver|voyager|yahoo! slurp|mediapartners-google|Linguee Bot|SemrushBot).*";
    @Value(value="${bot.regexpFilter}")
    public String botRegexpFilter = null;
    private Pattern regex = null;

    @PostConstruct
    private void initBotRegexpFilter() {
        if (this.botRegexpFilter == null || "".equals(this.botRegexpFilter) || "@bot.regexpFilter@".equals(this.botRegexpFilter)) {
            this.botRegexpFilter = ".*(bot|crawler|baiduspider|80legs|ia_archiver|voyager|yahoo! slurp|mediapartners-google|Linguee Bot|SemrushBot).*";
        }
        this.regex = Pattern.compile(this.botRegexpFilter, 2);
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        this.createSessionForAllButNotCrawlers(request);
        return super.preHandle(request, response, handler);
    }

    private void createSessionForAllButNotCrawlers(HttpServletRequest request) {
        String userAgent = request.getHeader("user-agent");
        if (!this.isCrawler(userAgent)) {
            HttpSession httpSession = request.getSession(true);
            UserSession session = (UserSession)httpSession.getAttribute("session");
            if (session == null) {
                session = new UserSession();
                httpSession.setAttribute("session", (Object)session);
                session.setsHttpSession(httpSession);
                if (Log.isDebugEnabled((String)"jeeves.request")) {
                    Log.debug((String)"jeeves.request", (Object)("Session created for client : " + request.getRemoteAddr()));
                }
            }
        } else {
            HttpSession httpSession = request.getSession(false);
            if (Log.isDebugEnabled((String)"jeeves.request")) {
                Log.debug((String)"jeeves.request", (Object)String.format("Crawler '%s' detected. Session MUST be null: %s", userAgent, request.getSession(false) == null));
            }
            if (httpSession != null) {
                httpSession.invalidate();
            }
        }
    }

    public boolean isCrawler(String userAgent) {
        if (StringUtils.isNotBlank((String)userAgent)) {
            Matcher m = this.regex.matcher(userAgent);
            return m.find();
        }
        return false;
    }

    public String getBotRegexpFilter() {
        return this.botRegexpFilter;
    }

    public void setBotRegexpFilter(String botRegexpFilter) {
        this.botRegexpFilter = botRegexpFilter;
        this.initBotRegexpFilter();
    }
}

