/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.geotools.factory.Factory;
import org.geotools.factory.FactoryCreator;
import org.geotools.factory.FactoryRegistry;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultCompoundCRS;
import org.geotools.referencing.cs.AbstractCS;
import org.geotools.referencing.factory.ReferencingFactory;
import org.geotools.referencing.factory.ReferencingObjectFactory;
import org.geotools.referencing.operation.DefaultMathTransformFactory;
import org.geotools.referencing.operation.DefiningConversion;
import org.geotools.resources.XArray;
import org.geotools.resources.i18n.Errors;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchIdentifierException;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.Operation;
import org.opengis.referencing.operation.OperationMethod;

public class ReferencingFactoryContainer
extends ReferencingFactory {
    private static FactoryRegistry cache;
    private DatumFactory datumFactory;
    private CSFactory csFactory;
    private CRSFactory crsFactory;
    private MathTransformFactory mtFactory;

    public ReferencingFactoryContainer(Hints userHints) {
        Hints reduced = new Hints(userHints);
        this.datumFactory = (DatumFactory)ReferencingFactoryContainer.extract(reduced, Hints.DATUM_FACTORY);
        this.csFactory = (CSFactory)ReferencingFactoryContainer.extract(reduced, Hints.CS_FACTORY);
        this.crsFactory = (CRSFactory)ReferencingFactoryContainer.extract(reduced, Hints.CRS_FACTORY);
        this.mtFactory = (MathTransformFactory)ReferencingFactoryContainer.extract(reduced, Hints.MATH_TRANSFORM_FACTORY);
        if (!reduced.isEmpty()) {
            this.setHintsInto(reduced);
            this.addImplementationHints(reduced);
            this.initialize();
            this.hints.clear();
        }
    }

    private static Factory extract(Map<?, ?> reduced, Hints.Key key) {
        Object candidate;
        if (reduced != null && (candidate = reduced.get(key)) instanceof Factory) {
            reduced.remove(key);
            return (Factory)candidate;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReferencingFactoryContainer instance(Hints hints) {
        Hints completed = GeoTools.getDefaultHints();
        if (hints != null) {
            completed.add(hints);
        }
        Class<ReferencingFactoryFinder> clazz = ReferencingFactoryFinder.class;
        synchronized (ReferencingFactoryFinder.class) {
            if (cache == null) {
                cache = new FactoryCreator(Arrays.asList(ReferencingFactoryContainer.class));
                cache.registerServiceProvider(new ReferencingFactoryContainer(null), ReferencingFactoryContainer.class);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return cache.getServiceProvider(ReferencingFactoryContainer.class, null, completed, null);
        }
    }

    private void initialize() {
        this.mtFactory = this.getMathTransformFactory();
        this.datumFactory = this.getDatumFactory();
        this.csFactory = this.getCSFactory();
        this.crsFactory = this.getCRSFactory();
    }

    private void setHintsInto(Map<? super RenderingHints.Key, Object> hints) {
        if (this.crsFactory != null) {
            hints.put(Hints.CRS_FACTORY, this.crsFactory);
        }
        if (this.csFactory != null) {
            hints.put(Hints.CS_FACTORY, this.csFactory);
        }
        if (this.datumFactory != null) {
            hints.put(Hints.DATUM_FACTORY, this.datumFactory);
        }
        if (this.mtFactory != null) {
            hints.put(Hints.MATH_TRANSFORM_FACTORY, this.mtFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<RenderingHints.Key, ?> getImplementationHints() {
        Map map = this.hints;
        synchronized (map) {
            if (this.hints.isEmpty()) {
                this.initialize();
                this.setHintsInto(this.hints);
            }
        }
        return super.getImplementationHints();
    }

    private Hints hints() {
        Hints completed = new Hints(this.hints);
        this.setHintsInto(completed);
        return completed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatumFactory getDatumFactory() {
        if (this.datumFactory == null) {
            Map map = this.hints;
            synchronized (map) {
                this.datumFactory = ReferencingFactoryFinder.getDatumFactory(this.hints());
            }
        }
        return this.datumFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSFactory getCSFactory() {
        if (this.csFactory == null) {
            Map map = this.hints;
            synchronized (map) {
                this.csFactory = ReferencingFactoryFinder.getCSFactory(this.hints());
            }
        }
        return this.csFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CRSFactory getCRSFactory() {
        if (this.crsFactory == null) {
            Map map = this.hints;
            synchronized (map) {
                this.crsFactory = ReferencingFactoryFinder.getCRSFactory(this.hints());
            }
        }
        return this.crsFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MathTransformFactory getMathTransformFactory() {
        if (this.mtFactory == null) {
            Map map = this.hints;
            synchronized (map) {
                this.mtFactory = ReferencingFactoryFinder.getMathTransformFactory(this.hints());
            }
        }
        return this.mtFactory;
    }

    @Deprecated
    public OperationMethod getOperationMethod(String name) throws NoSuchIdentifierException {
        MathTransformFactory mtFactory = this.getMathTransformFactory();
        if (mtFactory instanceof DefaultMathTransformFactory) {
            return ((DefaultMathTransformFactory)mtFactory).getOperationMethod(name);
        }
        for (OperationMethod method : mtFactory.getAvailableMethods(Operation.class)) {
            if (!AbstractIdentifiedObject.nameMatches((IdentifiedObject)method, name)) continue;
            return method;
        }
        throw new NoSuchIdentifierException(Errors.format(141, name), name);
    }

    @Deprecated
    public OperationMethod getLastUsedMethod() {
        return this.getMathTransformFactory().getLastMethodUsed();
    }

    @Deprecated
    public MathTransform createParameterizedTransform(ParameterValueGroup parameters) throws NoSuchIdentifierException, FactoryException {
        return this.getMathTransformFactory().createParameterizedTransform(parameters);
    }

    @Deprecated
    public MathTransform createBaseToDerived(CoordinateReferenceSystem baseCRS, ParameterValueGroup parameters, CoordinateSystem derivedCS) throws NoSuchIdentifierException, FactoryException {
        return this.getMathTransformFactory().createBaseToDerived(baseCRS, parameters, derivedCS);
    }

    @Deprecated
    public ProjectedCRS createProjectedCRS(Map<String, ?> properties, GeographicCRS baseCRS, Conversion conversionFromBase, CartesianCS derivedCS) throws FactoryException {
        return this.getCRSFactory().createProjectedCRS(properties, baseCRS, conversionFromBase, derivedCS);
    }

    @Deprecated
    public ProjectedCRS createProjectedCRS(Map<String, ?> properties, GeographicCRS baseCRS, OperationMethod method, ParameterValueGroup parameters, CartesianCS derivedCS) throws FactoryException {
        MathTransform mt = this.createBaseToDerived((CoordinateReferenceSystem)baseCRS, parameters, (CoordinateSystem)derivedCS);
        if (method == null) {
            method = this.getLastUsedMethod();
        }
        return ((ReferencingObjectFactory)this.getCRSFactory()).createProjectedCRS(properties, method, baseCRS, mt, derivedCS);
    }

    public CoordinateReferenceSystem toGeodetic3D(CompoundCRS crs) throws FactoryException {
        List<SingleCRS> components = DefaultCompoundCRS.getSingleCRS((CoordinateReferenceSystem)crs);
        int count = components.size();
        SingleCRS horizontal = null;
        VerticalCRS vertical = null;
        int hi = 0;
        int vi = 0;
        for (int i = 0; i < count; ++i) {
            SingleCRS candidate = components.get(i);
            if (candidate instanceof VerticalCRS) {
                if (vertical == null && VerticalDatumType.ELLIPSOIDAL.equals((Object)(vertical = (VerticalCRS)candidate).getDatum().getVerticalDatumType())) {
                    vi = i;
                    continue;
                }
                return crs;
            }
            if (!(candidate instanceof GeographicCRS) && !(candidate instanceof ProjectedCRS)) continue;
            if (horizontal == null && (horizontal = candidate).getCoordinateSystem().getDimension() == 2) {
                hi = i;
                continue;
            }
            return crs;
        }
        if (horizontal != null && vertical != null && Math.abs(vi - hi) == 1) {
            boolean xyFirst = hi < vi;
            SingleCRS single = this.toGeodetic3D((CompoundCRS)(count == 2 ? crs : null), horizontal, vertical, xyFirst);
            if (count == 2) {
                return single;
            }
            int i = xyFirst ? hi : vi;
            components = new ArrayList<SingleCRS>(components);
            components.remove(i);
            components.set(i, single);
            SingleCRS[] c = components.toArray(new SingleCRS[components.size()]);
            return this.crsFactory.createCompoundCRS(AbstractIdentifiedObject.getProperties((IdentifiedObject)crs), (CoordinateReferenceSystem[])c);
        }
        return crs;
    }

    private SingleCRS toGeodetic3D(CompoundCRS crs, SingleCRS horizontal, VerticalCRS vertical, boolean xyFirst) throws FactoryException {
        Map<String, ?> crsName;
        Map<String, ?> csName;
        CoordinateSystemAxis[] axis = new CoordinateSystemAxis[3];
        CoordinateSystem cs = horizontal.getCoordinateSystem();
        axis[xyFirst ? 0 : 1] = cs.getAxis(0);
        axis[xyFirst ? 1 : 2] = cs.getAxis(1);
        axis[xyFirst ? 2 : 0] = vertical.getCoordinateSystem().getAxis(0);
        if (crs != null) {
            csName = AbstractIdentifiedObject.getProperties((IdentifiedObject)crs.getCoordinateSystem());
            crsName = AbstractIdentifiedObject.getProperties((IdentifiedObject)crs);
        } else {
            csName = ReferencingFactoryContainer.getTemporaryName((IdentifiedObject)cs);
            crsName = ReferencingFactoryContainer.getTemporaryName((IdentifiedObject)horizontal);
        }
        CSFactory csFactory = this.getCSFactory();
        CRSFactory crsFactory = this.getCRSFactory();
        if (horizontal instanceof GeographicCRS) {
            GeographicCRS sourceCRS = (GeographicCRS)horizontal;
            EllipsoidalCS targetCS = csFactory.createEllipsoidalCS(csName, axis[0], axis[1], axis[2]);
            return crsFactory.createGeographicCRS(crsName, sourceCRS.getDatum(), targetCS);
        }
        if (horizontal instanceof ProjectedCRS) {
            ProjectedCRS sourceCRS = (ProjectedCRS)horizontal;
            CartesianCS targetCS = csFactory.createCartesianCS(csName, axis[0], axis[1], axis[2]);
            GeographicCRS base2D = sourceCRS.getBaseCRS();
            GeographicCRS base3D = (GeographicCRS)this.toGeodetic3D(null, (SingleCRS)base2D, vertical, xyFirst);
            Matrix prepend = ReferencingFactoryContainer.toStandard((CoordinateReferenceSystem)base2D, false);
            Matrix append = ReferencingFactoryContainer.toStandard((CoordinateReferenceSystem)sourceCRS, true);
            Object projection = sourceCRS.getConversionFromBase();
            if (!prepend.isIdentity() || !append.isIdentity()) {
                MathTransformFactory mtFactory = this.getMathTransformFactory();
                MathTransform mt = projection.getMathTransform();
                mt = mtFactory.createConcatenatedTransform(mtFactory.createConcatenatedTransform(mtFactory.createAffineTransform(prepend), mt), mtFactory.createAffineTransform(append));
                projection = new DefiningConversion(AbstractCS.getProperties((IdentifiedObject)projection), projection.getMethod(), mt);
            }
            return crsFactory.createProjectedCRS(crsName, base3D, (Conversion)projection, targetCS);
        }
        throw new AssertionError(horizontal);
    }

    private static Matrix toStandard(CoordinateReferenceSystem crs, boolean inverse) {
        CoordinateSystem sourceCS = crs.getCoordinateSystem();
        CoordinateSystem targetCS = AbstractCS.standard(sourceCS);
        if (inverse) {
            return AbstractCS.swapAndScaleAxis(targetCS, sourceCS);
        }
        return AbstractCS.swapAndScaleAxis(sourceCS, targetCS);
    }

    public CoordinateReferenceSystem separate(CoordinateReferenceSystem crs, int[] dimensions) throws FactoryException {
        int length = dimensions.length;
        int crsDimension = crs.getCoordinateSystem().getDimension();
        if (length == 0 || dimensions[0] < 0 || dimensions[length - 1] >= crsDimension || !XArray.isStrictlySorted(dimensions)) {
            throw new IllegalArgumentException(Errors.format(57, "dimension"));
        }
        if (length == crsDimension) {
            return crs;
        }
        if (crs instanceof CompoundCRS) {
            int count = 0;
            int lowerDimension = 0;
            int lowerIndex = 0;
            List sources = ((CompoundCRS)crs).getCoordinateReferenceSystems();
            CoordinateReferenceSystem[] targets = new CoordinateReferenceSystem[sources.size()];
            block0: for (CoordinateReferenceSystem source : sources) {
                int upperDimension = lowerDimension + source.getCoordinateSystem().getDimension();
                if (lowerIndex == dimensions.length) break;
                while (dimensions[lowerIndex] < lowerDimension) {
                    if (++lowerIndex != dimensions.length) continue;
                    break block0;
                }
                int upperIndex = lowerIndex;
                while (dimensions[upperIndex] < upperDimension && ++upperIndex != dimensions.length) {
                }
                if (lowerIndex != upperIndex) {
                    int[] sub = new int[upperIndex - lowerIndex];
                    for (int j = 0; j < sub.length; ++j) {
                        sub[j] = dimensions[j + lowerIndex] - lowerDimension;
                    }
                    targets[count++] = this.separate(source, sub);
                }
                lowerDimension = upperDimension;
                lowerIndex = upperIndex;
            }
            if (count == 1) {
                return targets[0];
            }
            return this.getCRSFactory().createCompoundCRS(ReferencingFactoryContainer.getTemporaryName((IdentifiedObject)crs), XArray.resize(targets, count));
        }
        throw new FactoryException(Errors.format(31, crs.getName().getCode()));
    }

    private static Map<String, ?> getTemporaryName(IdentifiedObject source) {
        return Collections.singletonMap("name", source.getName().getCode() + " (3D)");
    }
}

