/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.repository.specification;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.fao.geonet.domain.Group_;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.ReservedGroup;
import org.fao.geonet.domain.UserGroup;
import org.fao.geonet.domain.UserGroupId_;
import org.fao.geonet.domain.UserGroup_;
import org.springframework.data.jpa.domain.Specification;

public final class UserGroupSpecs {
    private UserGroupSpecs() {
    }

    public static Specification<UserGroup> hasGroupId(final Integer groupId) {
        return new Specification<UserGroup>(){

            public Predicate toPredicate(Root<UserGroup> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Path grpIdAttributePath = root.get(UserGroup_.id).get(UserGroupId_.groupId);
                Predicate grpIdEqualPredicate = groupId == null ? cb.isNull((Expression)grpIdAttributePath) : cb.equal((Expression)grpIdAttributePath, cb.literal((Object)groupId));
                return grpIdEqualPredicate;
            }
        };
    }

    public static Specification<UserGroup> hasGroupIds(final List<Integer> groupId) {
        return new Specification<UserGroup>(){

            public Predicate toPredicate(Root<UserGroup> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Path grpIdAttributePath = root.get(UserGroup_.id).get(UserGroupId_.groupId);
                Predicate grpIdInPredicate = grpIdAttributePath.in((Collection)groupId);
                return grpIdInPredicate;
            }
        };
    }

    public static Specification<UserGroup> hasUserId(final int userId) {
        return new Specification<UserGroup>(){

            public Predicate toPredicate(Root<UserGroup> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Path userIdAttributePath = root.get(UserGroup_.id).get(UserGroupId_.userId);
                Predicate userIdEqualPredicate = cb.equal((Expression)userIdAttributePath, cb.literal((Object)userId));
                return userIdEqualPredicate;
            }
        };
    }

    public static Specification<UserGroup> hasProfile(final Profile profile) {
        return new Specification<UserGroup>(){

            public Predicate toPredicate(Root<UserGroup> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Path profileIdAttributePath = root.get(UserGroup_.id).get(UserGroupId_.profile);
                Predicate profileIdEqualPredicate = cb.equal((Expression)profileIdAttributePath, cb.literal((Object)profile));
                return profileIdEqualPredicate;
            }
        };
    }

    public static Specification<UserGroup> hasUserIdAndProfile(int userId, Profile profile) {
        return (root, query, cb) -> {
            Path profileIdAttributePath = root.get(UserGroup_.id).get(UserGroupId_.profile);
            Path userIdAttributePath = root.get(UserGroup_.id).get(UserGroupId_.userId);
            Predicate profileIdEqualPredicate = cb.equal((Expression)profileIdAttributePath, cb.literal((Object)profile));
            Predicate userIdEqualsPredicate = cb.equal((Expression)userIdAttributePath, cb.literal((Object)userId));
            return cb.and((Expression)profileIdEqualPredicate, (Expression)userIdEqualsPredicate);
        };
    }

    public static Specification<UserGroup> isReservedGroup(final boolean isReservedGroup) {
        return new Specification<UserGroup>(){

            public Predicate toPredicate(Root<UserGroup> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                HashSet<Integer> ids = new HashSet<Integer>();
                for (ReservedGroup reservedGroup : ReservedGroup.values()) {
                    ids.add(reservedGroup.getId());
                }
                Predicate inIdsPredicate = root.get(UserGroup_.group).get(Group_.id).in(ids);
                if (isReservedGroup) {
                    return inIdsPredicate;
                }
                return inIdsPredicate.not();
            }
        };
    }
}

