/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.listener.history;

import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.MetadataStatus;
import org.fao.geonet.domain.MetadataStatusId;
import org.fao.geonet.domain.StatusValue;
import org.fao.geonet.events.history.AbstractHistoryEvent;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.MetadataStatusRepository;
import org.fao.geonet.repository.StatusValueRepository;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class GenericMetadataEventListener {
    @Autowired
    private SettingManager settingManager;
    @Autowired
    private MetadataStatusRepository statusRepository;
    @Autowired
    private StatusValueRepository statusValueRepository;

    public abstract String getChangeMessage();

    public abstract String getEventType();

    public final void handleEvent(AbstractHistoryEvent event) {
        this.storeContentHistoryEvent(event);
    }

    public final void storeContentHistoryEvent(AbstractHistoryEvent event) {
        if (this.settingManager.getValueAsBool("system/metadata/history/enabled")) {
            Integer metadataUuid = Math.toIntExact(event.getMdId());
            MetadataStatusId metadataStatusId = new MetadataStatusId().setMetadataId(metadataUuid.intValue()).setStatusId(Integer.parseInt(this.getEventType())).setUserId(event.getUserId().intValue()).setChangeDate(new ISODate(System.currentTimeMillis()));
            StatusValue status = this.statusValueRepository.findOneById(Integer.parseInt(this.getEventType()));
            if (status != null) {
                MetadataStatus metadataStatus = new MetadataStatus();
                metadataStatus.setId(metadataStatusId);
                metadataStatus.setStatusValue(status);
                metadataStatus.setOwner(event.getUserId());
                metadataStatus.setChangeMessage(this.getChangeMessage());
                metadataStatus.setCurrentState(event.getCurrentState());
                metadataStatus.setPreviousState(event.getPreviousState());
                this.statusRepository.save((Object)metadataStatus);
            } else {
                Log.warning((String)"geonetwork.datamanager", (Object)String.format("Status with id '%s' not found in database. Check database migration SQL file to add default status if you want to log record history.", this.getEventType()));
            }
        }
    }
}

