/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.readers.google;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.Transformer;
import org.mapfish.print.map.ParallelMapTileLoader;
import org.mapfish.print.map.readers.HTTPMapReader;
import org.mapfish.print.map.readers.MapReader;
import org.mapfish.print.map.readers.MapReaderFactory;
import org.mapfish.print.map.readers.TileCacheLayerInfo;
import org.mapfish.print.map.readers.google.GoogleConfig;
import org.mapfish.print.map.readers.google.GoogleLayerInfo;
import org.mapfish.print.map.renderers.TileRenderer;
import org.mapfish.print.utils.PJsonArray;
import org.mapfish.print.utils.PJsonObject;
import org.pvalsecc.misc.URIUtils;

public class GoogleMapReader
extends HTTPMapReader {
    private final String layer;
    private final GoogleConfig config;
    private final GoogleLayerInfo layerInfo;

    private GoogleMapReader(String layer, RenderingContext context, PJsonObject params) {
        super(context, params);
        this.layer = layer;
        this.config = new GoogleConfig(context, params, LOGGER, this.baseUrl, true);
        PJsonArray maxExtent = params.getJSONArray("maxExtent");
        this.layerInfo = new GoogleLayerInfo(params.getJSONArray("resolutions"), 640, 640, maxExtent.getFloat(0), maxExtent.getFloat(1), maxExtent.getFloat(2), maxExtent.getFloat(3), params.getString("extension"));
    }

    @Override
    protected void renderTiles(TileRenderer formatter, Transformer transformer, URI commonUri, ParallelMapTileLoader parallelMapTileLoader) throws IOException, URISyntaxException {
        double maxGeoX = transformer.getRotatedMaxGeoX();
        double minGeoX = transformer.getRotatedMinGeoX();
        double maxGeoY = transformer.getRotatedMaxGeoY();
        double minGeoY = transformer.getRotatedMinGeoY();
        long width = transformer.getRotatedBitmapW();
        long height = transformer.getRotatedBitmapH();
        double targetResolution = transformer.getGeoW() / (double)width;
        TileCacheLayerInfo.ResolutionInfo resolution = this.layerInfo.getNearestResolution(targetResolution);
        HashMap<String, List<String>> tileParams = new HashMap<String, List<String>>();
        double originShift = 2.0037508342789244E7;
        double longitude = (maxGeoX + minGeoX) / 2.0 / originShift * 180.0;
        double latitude = (maxGeoY + minGeoY) / 2.0 / originShift * 180.0;
        latitude = 57.29577951308232 * (2.0 * Math.atan(Math.exp(latitude * Math.PI / 180.0)) - 1.5707963267948966);
        DecimalFormat df = new DecimalFormat("#.#######################");
        String center = df.format(latitude) + "," + df.format(longitude);
        String size = Long.toString(width) + "x" + Long.toString(height);
        URIUtils.addParamOverride(tileParams, "center", center);
        URIUtils.addParamOverride(tileParams, "size", size);
        URIUtils.addParamOverride(tileParams, "zoom", Integer.toString(resolution.index));
        URI uri = URIUtils.addParams(commonUri, tileParams, OVERRIDE_ALL);
        ArrayList<URI> uris = new ArrayList<URI>(1);
        uris.add(this.config.signURI(uri));
        formatter.render(transformer, uris, parallelMapTileLoader, this.context, this.opacity, 1, 0.0, 0.0, transformer.getRotatedBitmapW(), transformer.getRotatedBitmapH());
    }

    @Override
    protected TileRenderer.Format getFormat() {
        return TileRenderer.Format.BITMAP;
    }

    @Override
    protected void addCommonQueryParams(Map<String, List<String>> result, Transformer transformer, String srs, boolean first) {
        URIUtils.addParamOverride(result, "client", this.config.signer.clientId());
        URIUtils.addParamOverride(result, "sensor", this.config.sensor);
        URIUtils.addParamOverride(result, "format", this.config.format);
        URIUtils.addParamOverride(result, "maptype", this.config.maptype);
        if (this.config.language != null) {
            URIUtils.addParamOverride(result, "language", this.config.language);
        }
        if (this.config.markers.size() > 0) {
            result.put("markers", this.config.markers);
        }
        if (this.config.path != null) {
            URIUtils.addParamOverride(result, "path", this.config.path);
        }
    }

    @Override
    public boolean testMerge(MapReader other) {
        return false;
    }

    @Override
    public boolean canMerge(MapReader other) {
        return false;
    }

    @Override
    public String toString() {
        return this.layer;
    }

    public static class Factory
    implements MapReaderFactory {
        @Override
        public List<? extends MapReader> create(String type, RenderingContext context, PJsonObject params) {
            return Collections.singletonList(new GoogleMapReader("t", context, params));
        }
    }
}

