/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.util.z3950;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.fao.geonet.services.util.z3950.SRUParamTestDBO;

public class SRUParamTester {
    private Set<String> explainArgs;
    private Set<String> explainMandatoryArgs = new HashSet<String>();
    private Set<String> searchRetrieveArgs;
    private Set<String> searchRetrieveMandatoryArgs;
    private Hashtable<String, String> paramTypes;

    public SRUParamTester() {
        this.explainMandatoryArgs.add("version");
        this.explainMandatoryArgs.add("operation");
        this.explainArgs = new HashSet<String>();
        this.explainArgs.add("recordpacking");
        this.explainArgs.add("stylesheet");
        this.explainArgs.add("extrarequestdata");
        this.searchRetrieveMandatoryArgs = new HashSet<String>();
        this.searchRetrieveMandatoryArgs.add("operation");
        this.searchRetrieveMandatoryArgs.add("version");
        this.searchRetrieveMandatoryArgs.add("query");
        this.searchRetrieveArgs = new HashSet<String>();
        this.searchRetrieveArgs.add("startrecord");
        this.searchRetrieveArgs.add("maximumrecords");
        this.searchRetrieveArgs.add("recordpacking");
        this.searchRetrieveArgs.add("recordschema");
        this.searchRetrieveArgs.add("recordxpath ");
        this.searchRetrieveArgs.add("resultsetttl");
        this.searchRetrieveArgs.add("sortkeys");
        this.searchRetrieveArgs.add("stylesheet");
        this.searchRetrieveArgs.add("extrarequestdata");
        this.paramTypes = new Hashtable();
        this.paramTypes.put("query", "string");
        this.paramTypes.put("version", "string");
        this.paramTypes.put("stylesheet", "string");
        this.paramTypes.put("startrecord", "int");
        this.paramTypes.put("maximumrecords", "int");
        this.paramTypes.put("recordpacking", "string");
        this.paramTypes.put("recordschema", "string");
        this.paramTypes.put("recordxpath", "string");
        this.paramTypes.put("sortkeys", "string");
        this.paramTypes.put("extrarequestdata", "string");
    }

    public SRUParamTestDBO testParams(String op, Hashtable<String, String> params) {
        Set<String> notSupported = this.testNotSupported(op, params);
        Set<String> missingArgs = this.testMissingArgs(op, params);
        Set<String> cannotParse = this.testCannotParse(op, params);
        SRUParamTestDBO ret = new SRUParamTestDBO(op, notSupported, missingArgs, cannotParse);
        return ret;
    }

    private Set<String> testNotSupported(String op, Hashtable<String, String> params) {
        HashSet<String> temp = new HashSet<String>();
        HashSet<String> ret = new HashSet<String>();
        if (op.equals("explain")) {
            temp.addAll(this.explainArgs);
            temp.addAll(this.explainMandatoryArgs);
        } else if (op.equals("searchretrieve")) {
            temp.addAll(this.searchRetrieveArgs);
            temp.addAll(this.searchRetrieveMandatoryArgs);
        } else {
            return ret;
        }
        for (String param : params.keySet()) {
            if (temp.contains(param)) continue;
            ret.add(param);
        }
        return ret;
    }

    private Set<String> testMissingArgs(String op, Hashtable<String, String> params) {
        HashSet<String> temp = new HashSet<String>();
        HashSet<String> ret = new HashSet<String>();
        if (op.equals("explain")) {
            temp.addAll(this.explainMandatoryArgs);
        }
        if (op.equals("searchretrieve")) {
            temp.addAll(this.searchRetrieveMandatoryArgs);
        }
        for (String param : temp) {
            if (params.containsKey(param)) continue;
            ret.add(param);
        }
        return ret;
    }

    private Set<String> testCannotParse(String op, Hashtable<String, String> params) {
        HashSet<String> ret = new HashSet<String>();
        if (op.equals("searchretrieve")) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                String key = entry.getKey();
                String val = entry.getValue();
                if (!this.paramTypes.containsKey(key) || !this.paramTypes.get(key).equals("int")) continue;
                try {
                    Integer.parseInt(val);
                }
                catch (NumberFormatException e) {
                    ret.add(key);
                }
            }
        }
        return ret;
    }
}

