/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.ldap;

import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.events.group.GroupCreated;
import org.springframework.context.ApplicationListener;
import org.springframework.ldap.NameNotFoundException;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.security.ldap.LdapUtils;
import org.springframework.util.StringUtils;

public class AutoCreateGroups
implements ApplicationListener<GroupCreated> {
    private static Integer lastGidNumber = null;
    private final Log logger = LogFactory.getLog(AutoCreateGroups.class);
    private ContextSource contextSource;
    private LdapTemplate template;
    private String baseDn = "ou=groups";
    private String groupAttribute = "cn";
    private Boolean withProfiles = true;
    private String profilePattern = "{0}_{1}";
    private Map<String, String> profileMapping;

    public void onApplicationEvent(GroupCreated event) {
        Group group = event.getGroup();
        String identifier = group.getName();
        if (!this.withProfiles.booleanValue()) {
            this.saveGroup(group, identifier);
        } else {
            for (Profile p : Profile.values()) {
                String profile = this.profileMapping.containsKey(p.name()) ? this.profileMapping.get(p.name()) : p.name();
                String id = this.profilePattern;
                id = id.replace("{0}", profile);
                id = id.replace("{1}", identifier);
                this.saveGroup(group, id);
            }
        }
    }

    private void saveGroup(Group group, String identifier) {
        if (!this.groupExists(identifier)) {
            DirContextAdapter ctx = new DirContextAdapter();
            this.copyToContext(identifier, group, ctx);
            DistinguishedName dn = this.buildDn(identifier);
            this.logger.trace((Object)("Creating group on LDAP  '" + identifier + "' with DN '" + dn + "'"));
            this.template.bind((Name)dn, (Object)ctx, null);
        }
    }

    protected void copyToContext(String identifier, Group group, DirContextAdapter ctx) {
        ctx.setAttributeValues("objectclass", (Object[])new String[]{"top", "posixGroup"});
        ctx.setAttributeValue("cn", (Object)identifier);
        if (!StringUtils.isEmpty((Object)group.getDescription())) {
            ctx.setAttributeValue("description", (Object)group.getDescription());
        }
        ctx.setAttributeValue("gidNumber", (Object)this.getGidNumber().toString());
    }

    private synchronized Integer getGidNumber() {
        if (lastGidNumber == null) {
            GidAttributesMapper mapper = new GidAttributesMapper();
            List existingGroups = this.template.search(this.baseDn, "(&(objectClass=posixGroup))", (AttributesMapper)mapper);
            for (Integer g : existingGroups) {
                if (lastGidNumber != null && lastGidNumber >= g) continue;
                lastGidNumber = g;
            }
            if (lastGidNumber == null) {
                lastGidNumber = 0;
            }
        }
        lastGidNumber = lastGidNumber + 1;
        return lastGidNumber;
    }

    public DistinguishedName buildDn(String username) {
        DistinguishedName dn = new DistinguishedName(this.baseDn);
        dn.add(this.groupAttribute, username);
        return dn;
    }

    public boolean groupExists(String group) {
        DistinguishedName dn = this.buildDn(group);
        try {
            Object obj = this.template.lookup((Name)dn);
            if (obj instanceof Context) {
                LdapUtils.closeContext((Context)((Context)obj));
            }
            return true;
        }
        catch (NameNotFoundException e) {
            return false;
        }
    }

    public void setTemplate(LdapTemplate template) {
        this.template = template;
    }

    public void setBaseDn(String baseDn) {
        this.baseDn = baseDn;
    }

    public void setGroupAttribute(String groupAttribute) {
        this.groupAttribute = groupAttribute;
    }

    public void setWithProfiles(Boolean withProfiles) {
        this.withProfiles = withProfiles;
    }

    public void setProfilePattern(String profilePattern) {
        this.profilePattern = profilePattern;
    }

    public void setContextSource(ContextSource contextSource) {
        this.contextSource = contextSource;
        this.template = new LdapTemplate(contextSource);
    }

    public void setProfileMapping(Map<String, String> profileMapping) {
        this.profileMapping = profileMapping;
    }

    private static class GidAttributesMapper
    implements AttributesMapper {
        private GidAttributesMapper() {
        }

        public Integer mapFromAttributes(Attributes attributes) throws NamingException {
            return Integer.valueOf(attributes.get("gidNumber").get().toString());
        }
    }
}

