/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import org.fao.geonet.kernel.search.LuceneOptimizerJob;
import org.fao.geonet.kernel.search.SearchManager;
import org.fao.geonet.kernel.setting.SettingInfo;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.QuartzSchedulerUtils;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.quartz.Matcher;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;

public class LuceneOptimizerManager {
    private static final String SCHEDULER_ID = "luceneOptimize";
    private final String instanceID = "luceneOptimize-" + UUID.randomUUID().toString();
    private final SimpleDateFormat _dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    private final Scheduler scheduler = QuartzSchedulerUtils.getScheduler((String)"luceneOptimize", (boolean)true);
    private Calendar _beginAt;
    private int _intervalInMinutes;
    private TriggerKey triggerKey;
    private JobDetail jobDetail;

    public LuceneOptimizerManager(SearchManager manager, SettingInfo settingsInfo) throws SchedulerException {
        this.scheduler.getListenerManager().addJobListener((JobListener)new Listener(manager), (Matcher)GroupMatcher.jobGroupEquals((String)this.instanceID));
        this.jobDetail = JobBuilder.newJob(LuceneOptimizerJob.class).withIdentity(this.instanceID, this.instanceID).storeDurably().build();
        this._beginAt = settingsInfo.getLuceneIndexOptimizerSchedulerAt();
        this._intervalInMinutes = settingsInfo.getLuceneIndexOptimizerSchedulerInterval();
        if (settingsInfo.getLuceneIndexOptimizerSchedulerEnabled()) {
            this.scheduleJob();
        } else {
            Log.info((String)"geonetwork.index", (Object)"Scheduling thread that optimizes lucene index is disabled");
        }
    }

    private void scheduleJob() throws SchedulerException {
        this.scheduler.unscheduleJob(this.triggerKey);
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(this.instanceID, this.instanceID).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMinutes(this._intervalInMinutes).repeatForever().withMisfireHandlingInstructionFireNow()).startAt(this.getBeginAt()).build();
        this.triggerKey = trigger.getKey();
        this.scheduler.scheduleJob(this.jobDetail, trigger);
    }

    public void cancel() {
    }

    public void shutdown() {
        try {
            this.scheduler.shutdown(true);
        }
        catch (SchedulerException e) {
            Log.warning((String)"geonetwork.index", (Object)"Error stopping the scheduler", (Throwable)e);
        }
    }

    public void reschedule(Calendar beginAt, int interval) throws SchedulerException {
        if (this._dateFormat.format(beginAt.getTime()).equals(this._dateFormat.format(this._beginAt.getTime())) && interval == this._intervalInMinutes) {
            return;
        }
        this._intervalInMinutes = interval;
        this._beginAt = beginAt;
        this.scheduleJob();
    }

    private Date getBeginAt() {
        Calendar now = Calendar.getInstance();
        Calendar ts = Calendar.getInstance();
        ts.set(5, now.get(5));
        ts.set(2, now.get(2));
        ts.set(1, now.get(1));
        ts.set(10, this._beginAt.get(10));
        ts.set(12, this._beginAt.get(12));
        ts.set(13, this._beginAt.get(13));
        if (now.after(ts)) {
            ts.add(5, 1);
        }
        return ts.getTime();
    }

    private class Listener
    implements JobListener {
        private SearchManager manager;

        public Listener(SearchManager manager) {
            this.manager = manager;
        }

        public String getName() {
            return LuceneOptimizerManager.this.instanceID + "JobListener";
        }

        public void jobToBeExecuted(JobExecutionContext context) {
            if (context.getJobInstance() instanceof LuceneOptimizerJob) {
                LuceneOptimizerJob job = (LuceneOptimizerJob)context.getJobInstance();
                job.setIndexTracker(this.manager.getIndexTracker());
            }
        }

        public void jobExecutionVetoed(JobExecutionContext context) {
        }

        public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        }
    }
}

