/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.mef;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;
import jeeves.server.context.ServiceContext;
import org.apache.commons.io.IOUtils;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.ZipUtil;
import org.fao.geonet.constants.Edit;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.MetadataCategory;
import org.fao.geonet.domain.MetadataResource;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.domain.Operation;
import org.fao.geonet.domain.OperationAllowed;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.exceptions.BadInputEx;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.exceptions.MetadataNotFoundEx;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.mef.IMEFVisitor;
import org.fao.geonet.kernel.mef.IVisitor;
import org.fao.geonet.kernel.mef.Importer;
import org.fao.geonet.kernel.mef.MEF2Exporter;
import org.fao.geonet.kernel.mef.MEFExporter;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.OperationAllowedRepository;
import org.fao.geonet.repository.OperationRepository;
import org.fao.geonet.utils.BinaryFile;
import org.fao.geonet.utils.Xml;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class MEFLib {
    private static FileFilter filter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return !pathname.getName().equals(".svn");
        }
    };

    public static List<String> doImport(String fileType, UuidAction uuidAction, String style, String source, MetadataType isTemplate, String[] category, String groupId, boolean validate, boolean assign, ServiceContext context, Path mefFile) throws Exception {
        return Importer.doImport(fileType, uuidAction, style, source, isTemplate, category, groupId, validate, assign, context, mefFile);
    }

    public static List<String> doImport(Element params, ServiceContext context, Path mefFile, Path stylePath) throws Exception {
        return Importer.doImport(params, context, mefFile, stylePath);
    }

    public static Path doExport(ServiceContext context, String uuid, String format, boolean skipUUID, boolean resolveXlink, boolean removeXlinkAttribute, boolean addSchemaLocation, boolean approved) throws Exception {
        return MEFExporter.doExport(context, uuid, Format.parse(format), skipUUID, resolveXlink, removeXlinkAttribute, addSchemaLocation, approved);
    }

    public static Path doExport(ServiceContext context, Integer id, String format, boolean skipUUID, boolean resolveXlink, boolean removeXlinkAttribute, boolean addSchemaLocation) throws Exception {
        return MEFExporter.doExport(context, id, Format.parse(format), skipUUID, resolveXlink, removeXlinkAttribute, addSchemaLocation);
    }

    public static Path doMEF2Export(ServiceContext context, Set<String> uuids, String format, boolean skipUUID, Path stylePath, boolean resolveXlink, boolean removeXlinkAttribute, boolean skipError, boolean addSchemaLocation, boolean approved) throws Exception {
        return MEF2Exporter.doExport(context, uuids, Format.parse(format), skipUUID, stylePath, resolveXlink, removeXlinkAttribute, skipError, addSchemaLocation, approved);
    }

    public static void visit(Path mefFile, IVisitor visitor, IMEFVisitor v) throws Exception {
        visitor.visit(mefFile, v);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Version getMEFVersion(Path mefFile) {
        try (FileSystem fileSystem = ZipUtil.openZipFs((Path)mefFile);){
            Path metadataXmlFile = fileSystem.getPath("metadata.xml", new String[0]);
            Path infoXmlFile = fileSystem.getPath("info.xml", new String[0]);
            if (Files.exists(metadataXmlFile, new LinkOption[0]) || Files.exists(infoXmlFile, new LinkOption[0])) {
                Version version = Version.V1;
                return version;
            }
            Version version = Version.V2;
            return version;
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    static Pair<AbstractMetadata, String> retrieveMetadata(ServiceContext context, AbstractMetadata metadata, boolean resolveXlink, boolean removeXlinkAttribute, boolean addSchemaLocation) throws Exception {
        if (metadata == null) {
            throw new MetadataNotFoundEx("");
        }
        return MEFLib.retrieveMetadata(context, removeXlinkAttribute, addSchemaLocation, metadata);
    }

    static Pair<AbstractMetadata, String> retrieveMetadata(ServiceContext context, Integer id, boolean resolveXlink, boolean removeXlinkAttribute, boolean addSchemaLocation) throws Exception {
        AbstractMetadata metadata = context.getBean(IMetadataUtils.class).findOne(id);
        if (metadata == null) {
            throw new MetadataNotFoundEx("id=" + id);
        }
        return MEFLib.retrieveMetadata(context, removeXlinkAttribute, addSchemaLocation, metadata);
    }

    private static Pair<AbstractMetadata, String> retrieveMetadata(ServiceContext context, boolean removeXlinkAttribute, boolean addSchemaLocation, AbstractMetadata metadata) throws Exception {
        String metadataForExportAsString;
        SchemaManager schemaManager;
        Attribute schemaLocAtt;
        DataManager dm = context.getBean(DataManager.class);
        String id = "" + metadata.getId();
        boolean forEditing = false;
        boolean withEditorValidationErrors = false;
        Element metadataForExportXml = dm.getMetadata(context, id, forEditing, withEditorValidationErrors, !removeXlinkAttribute);
        metadataForExportXml.removeChild("info", Edit.NAMESPACE);
        if (addSchemaLocation && (schemaLocAtt = (schemaManager = context.getBean(SchemaManager.class)).getSchemaLocation(metadata.getDataInfo().getSchemaId(), context)) != null && metadataForExportXml.getAttribute(schemaLocAtt.getName(), schemaLocAtt.getNamespace()) == null) {
            metadataForExportXml.setAttribute(schemaLocAtt);
            metadataForExportXml.removeNamespaceDeclaration(schemaLocAtt.getNamespace());
            metadataForExportXml.addNamespaceDeclaration(schemaLocAtt.getNamespace());
        }
        if (!(metadataForExportAsString = Xml.getString((Element)metadataForExportXml)).startsWith("<?xml")) {
            metadataForExportAsString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + metadataForExportAsString;
        }
        return Pair.read((Object)metadata, (Object)metadataForExportAsString);
    }

    static void addFile(ZipOutputStream zos, String name, @Nonnull String string) throws IOException {
        MEFLib.addFile(zos, name, new ByteArrayInputStream(string.getBytes("UTF-8")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addFile(ZipOutputStream zos, String name, @Nonnull InputStream in) throws IOException {
        ZipEntry entry = null;
        try {
            entry = new ZipEntry(name);
            zos.putNextEntry(entry);
            BinaryFile.copy((InputStream)in, (OutputStream)zos);
        }
        finally {
            try {
                if (zos != null) {
                    zos.closeEntry();
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
    }

    static void savePublic(ZipOutputStream zos, String dir, String uuid) throws IOException {
        File[] files = new File(dir).listFiles(filter);
        if (files != null) {
            for (File file : files) {
                MEFLib.addFile(zos, (uuid != null ? uuid : "") + "/" + "public/" + file.getName(), new FileInputStream(file));
            }
        }
    }

    static void savePrivate(ZipOutputStream zos, String dir, String uuid) throws IOException {
        File[] files = new File(dir).listFiles(filter);
        if (files != null) {
            for (File file : files) {
                MEFLib.addFile(zos, (uuid != null ? uuid : "") + "/" + "private/" + file.getName(), new FileInputStream(file));
            }
        }
    }

    static String buildInfoFile(ServiceContext context, AbstractMetadata md, Format format, List<MetadataResource> pubResources, List<MetadataResource> priResources, boolean skipUUID) throws Exception {
        Element info = new Element("info");
        info.setAttribute("version", "1.1");
        info.addContent((Content)MEFLib.buildInfoGeneral(md, format, skipUUID, context));
        info.addContent((Content)MEFLib.buildInfoCategories(md));
        info.addContent((Content)MEFLib.buildInfoPrivileges(context, md));
        info.addContent((Content)MEFLib.buildInfoFiles("public", pubResources));
        if (priResources != null) {
            info.addContent((Content)MEFLib.buildInfoFiles("private", priResources));
        } else {
            info.addContent((Content)new Element("private"));
        }
        return Xml.getString((Document)new Document(info));
    }

    static Element buildInfoGeneral(AbstractMetadata md, Format format, boolean skipUUID, ServiceContext context) {
        String id = String.valueOf(md.getId());
        String uuid = md.getUuid();
        String schema = md.getDataInfo().getSchemaId();
        String isTemplate = md.getDataInfo().getType().codeString;
        String createDate = md.getDataInfo().getCreateDate().getDateAndTime();
        String changeDate = md.getDataInfo().getChangeDate().getDateAndTime();
        String siteId = md.getSourceInfo().getSourceId();
        String rating = "" + md.getDataInfo().getRating();
        String popularity = "" + md.getDataInfo().getPopularity();
        Element general = new Element("general").addContent((Content)new Element("createDate").setText(createDate)).addContent((Content)new Element("changeDate").setText(changeDate)).addContent((Content)new Element("schema").setText(schema)).addContent((Content)new Element("isTemplate").setText(isTemplate)).addContent((Content)new Element("localId").setText(id)).addContent((Content)new Element("format").setText(format.toString())).addContent((Content)new Element("rating").setText(rating)).addContent((Content)new Element("popularity").setText(popularity));
        if (!skipUUID) {
            GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
            general.addContent((Content)new Element("uuid").setText(uuid));
            general.addContent((Content)new Element("siteId").setText(siteId));
            general.addContent((Content)new Element("siteName").setText(gc.getBean(SettingManager.class).getSiteName()));
        }
        return general;
    }

    static Element buildInfoCategories(AbstractMetadata md) throws SQLException {
        Element categ = new Element("categories");
        for (MetadataCategory category : md.getCategories()) {
            String name = category.getName();
            Element cat = new Element("category");
            cat.setAttribute("name", name);
            categ.addContent((Content)cat);
        }
        return categ;
    }

    static Element buildInfoPrivileges(ServiceContext context, AbstractMetadata md) throws Exception {
        int iId = md.getId();
        OperationAllowedRepository allowedRepository = context.getBean(OperationAllowedRepository.class);
        GroupRepository groupRepository = context.getBean(GroupRepository.class);
        OperationRepository operationRepository = context.getBean(OperationRepository.class);
        allowedRepository.findAllById_MetadataId(iId);
        Integer grpOwnerId = md.getSourceInfo().getGroupOwner();
        String grpOwnerName = "";
        HashMap<String, ArrayList<String>> hmPriv = new HashMap<String, ArrayList<String>>();
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        AccessManager am = gc.getBean(AccessManager.class);
        Set<Integer> userGroups = am.getUserGroups(context.getUserSession(), context.getIpAddress(), false);
        OperationAllowedRepository operationAllowedRepository = context.getBean(OperationAllowedRepository.class);
        List opsAllowed = operationAllowedRepository.findAllById_MetadataId(iId);
        for (OperationAllowed operationAllowed : opsAllowed) {
            ArrayList<String> al;
            int grpId = operationAllowed.getId().getGroupId();
            Group group = (Group)groupRepository.findOne((Serializable)Integer.valueOf(grpId));
            String grpName = group.getName();
            if (!userGroups.contains(grpId)) continue;
            Operation operation = (Operation)operationRepository.findOne((Serializable)Integer.valueOf(operationAllowed.getId().getOperationId()));
            String operName = operation.getName();
            if (grpOwnerId != null && grpOwnerId == grpId) {
                grpOwnerName = grpName;
            }
            if ((al = (ArrayList<String>)hmPriv.get(grpName)) == null) {
                al = new ArrayList<String>();
                hmPriv.put(grpName, al);
            }
            al.add(operName);
        }
        Element privil = new Element("privileges");
        for (Map.Entry entry : hmPriv.entrySet()) {
            String grpName = (String)entry.getKey();
            Element group = new Element("group");
            group.setAttribute("name", grpName);
            if (grpName.equals(grpOwnerName)) {
                group.setAttribute("groupOwner", Boolean.TRUE.toString());
            }
            privil.addContent((Content)group);
            for (String operName : (ArrayList)entry.getValue()) {
                Element oper = new Element("operation");
                oper.setAttribute("name", operName);
                group.addContent((Content)oper);
            }
        }
        return privil;
    }

    static Element buildInfoFiles(String name, List<MetadataResource> resources) {
        Element root = new Element(name);
        if (resources != null) {
            for (MetadataResource resource : resources) {
                String date = new ISODate(resource.getLastModification().getTime(), false).toString();
                Element el = new Element("file");
                el.setAttribute("name", resource.getFilename());
                el.setAttribute("changeDate", date);
                root.addContent((Content)el);
            }
        }
        return root;
    }

    static String getChangeDate(List<Element> files, String fileName) throws Exception {
        Iterator<Element> iterator = files.iterator();
        while (iterator.hasNext()) {
            Element f;
            Element file = f = iterator.next();
            String name = file.getAttributeValue("name");
            String date = file.getAttributeValue("changeDate");
            if (!name.equals(fileName)) continue;
            return date;
        }
        throw new Exception("File not found in info.xml : " + fileName);
    }

    public static boolean isValidArchiveExtensionForMEF(String filename) {
        String lowercasedFileName = filename.toLowerCase();
        return lowercasedFileName.endsWith(".zip") || lowercasedFileName.endsWith(".mef");
    }

    public static boolean isValidExtensionForMEF(String filename) {
        String lowercasedFileName = filename.toLowerCase();
        return lowercasedFileName.endsWith(".xml") || MEFLib.isValidArchiveExtensionForMEF(lowercasedFileName);
    }

    public static class MefOrXmlFileFilter
    implements DirectoryStream.Filter<Path> {
        @Override
        public boolean accept(Path file) throws IOException {
            String name = file.getFileName().toString();
            return name.toLowerCase().endsWith(".xml") || name.toLowerCase().endsWith(".mef") || name.toLowerCase().endsWith(".zip");
        }
    }

    public static enum Version {
        V1("application/x-gn-mef-1-zip"),
        V2("application/x-gn-mef-2-zip");

        String acceptType;

        private Version(String acceptType) {
            this.acceptType = acceptType;
        }

        public static Version find(String acceptType) {
            for (Version v : Version.values()) {
                if (!v.acceptType.equalsIgnoreCase(acceptType)) continue;
                return v;
            }
            return V2;
        }

        public String toString() {
            return this.acceptType;
        }

        public static class Constants {
            public static final String MEF_V1_ACCEPT_TYPE = "application/x-gn-mef-1-zip";
            public static final String MEF_V2_ACCEPT_TYPE = "application/x-gn-mef-2-zip";
        }
    }

    public static enum Format {
        SIMPLE,
        PARTIAL,
        FULL;


        public static Format parse(String format) throws BadInputEx {
            if (format == null) {
                return FULL;
            }
            if (format.equalsIgnoreCase("simple")) {
                return SIMPLE;
            }
            if (format.equalsIgnoreCase("partial")) {
                return PARTIAL;
            }
            if (format.equalsIgnoreCase("full")) {
                return FULL;
            }
            throw new BadParameterEx("format", (Object)format);
        }

        public String toString() {
            return super.toString().toLowerCase();
        }
    }

    public static enum UuidAction {
        GENERATEUUID("generateUUID"),
        NOTHING("nothing"),
        OVERWRITE("overwrite");

        String name;

        private UuidAction(String name) {
            this.name = name;
        }

        public static UuidAction parse(String value) {
            for (UuidAction v : UuidAction.values()) {
                if (!v.name.equalsIgnoreCase(value)) continue;
                return v;
            }
            return NOTHING;
        }
    }
}

