/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.datamanager.draft;

import java.util.Vector;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.MetadataDraft;
import org.fao.geonet.kernel.datamanager.IMetadataIndexer;
import org.fao.geonet.kernel.datamanager.base.BaseMetadataIndexer;
import org.fao.geonet.kernel.search.SearchManager;
import org.fao.geonet.repository.MetadataDraftRepository;
import org.fao.geonet.utils.Log;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;

public class DraftMetadataIndexer
extends BaseMetadataIndexer
implements IMetadataIndexer {
    @Autowired
    private MetadataDraftRepository metadataDraftRepository;

    @Override
    public void init(ServiceContext context, Boolean force) throws Exception {
        super.init(context, force);
        this.metadataDraftRepository = context.getBean(MetadataDraftRepository.class);
    }

    @Override
    protected void addExtraFields(AbstractMetadata fullMd, Vector<Element> moreFields) {
        super.addExtraFields(fullMd, moreFields);
        if (fullMd instanceof MetadataDraft) {
            Log.trace((String)"geonetwork.datamanager", (Object)("We are indexing a draft with uuid " + fullMd.getUuid()));
            moreFields.addElement(SearchManager.makeField("_draft", "y", true, true));
        } else if (this.metadataDraftRepository.findOneByUuid(fullMd.getUuid()) != null) {
            Log.trace((String)"geonetwork.datamanager", (Object)("We are indexing a record with a draft associated with uuid " + fullMd.getUuid()));
            moreFields.addElement(SearchManager.makeField("_draft", "e", true, true));
        } else {
            Log.trace((String)"geonetwork.datamanager", (Object)("We are indexing a record with no draft associated with uuid " + fullMd.getUuid()));
            moreFields.addElement(SearchManager.makeField("_draft", "n", true, true));
        }
    }
}

