/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.attachments;

import com.google.common.net.UrlEscapers;
import java.util.Date;
import org.fao.geonet.domain.MetadataResource;
import org.fao.geonet.domain.MetadataResourceVisibility;

public class FilesystemStoreResource
implements MetadataResource {
    private final String url;
    private final MetadataResourceVisibility metadataResourceVisibility;
    private final long size;
    private final Date lastModification;
    private final int metadataId;
    private final String metadataUuid;
    private final String filename;
    private final boolean approved;

    public FilesystemStoreResource(String metadataUuid, int metadataId, String filename, String baseUrl, MetadataResourceVisibility metadataResourceVisibility, long size, Date lastModification, boolean approved) {
        this.metadataUuid = metadataUuid;
        this.metadataId = metadataId;
        this.approved = approved;
        this.filename = filename;
        this.url = baseUrl + this.getId();
        this.metadataResourceVisibility = metadataResourceVisibility;
        this.size = size;
        this.lastModification = lastModification;
    }

    public String getId() {
        return UrlEscapers.urlFragmentEscaper().escape(this.metadataUuid) + "/attachments/" + UrlEscapers.urlFragmentEscaper().escape(this.filename);
    }

    public String getUrl() {
        return this.url;
    }

    public MetadataResourceVisibility getVisibility() {
        return this.metadataResourceVisibility;
    }

    public long getSize() {
        return this.size;
    }

    public Date getLastModification() {
        return this.lastModification;
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean isApproved() {
        return this.approved;
    }

    public int getMetadataId() {
        return this.metadataId;
    }

    public String getMetadataUuid() {
        return this.metadataUuid;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("\n");
        sb.append("Metadata: ").append(this.metadataUuid).append("\n");
        sb.append("Filename: ").append(this.filename).append("\n");
        sb.append("URL: ").append(this.url).append("\n");
        sb.append("Type: ").append(this.metadataResourceVisibility).append("\n");
        sb.append("Size: ").append(this.size).append("\n");
        sb.append("Last modification: ").append(this.lastModification).append("\n");
        sb.append("Approved: ").append(this.approved).append("\n");
        return sb.toString();
    }
}

