/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.support;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.model.resource.support.AbstractConfigurableStrategySupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConfigurableMultipleStrategy<S, P>
extends AbstractConfigurableStrategySupport<S, P> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractConfigurableMultipleStrategy.class);
    private static final String TOKEN_DELIMITER = ",";

    public static String createItemsAsString(String ... items) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < items.length; ++i) {
            sb.append(items[i]);
            if (i >= items.length - 1) continue;
            sb.append(TOKEN_DELIMITER);
        }
        return sb.toString();
    }

    public final List<S> getConfiguredStrategies() {
        ArrayList strategies = new ArrayList();
        List<String> aliasList = this.getAliasList(this.getConfiguredValue());
        for (String alias : aliasList) {
            Object strategy = this.getStrategyForAlias(alias);
            if (strategy == null) {
                throw new WroRuntimeException("Invalid strategy alias provided: <" + alias + ">. Available aliases are: " + this.getAvailableAliases());
            }
            strategies.add(strategy);
        }
        LOG.debug("using strategies: {}", strategies);
        return strategies;
    }

    private List<String> getAliasList(String aliasCsv) {
        LOG.debug("configured aliases: {}", (Object)aliasCsv);
        ArrayList<String> list = new ArrayList<String>();
        if (!StringUtils.isEmpty((CharSequence)aliasCsv)) {
            String[] tokens;
            for (String token : tokens = aliasCsv.split(TOKEN_DELIMITER)) {
                list.add(token.trim());
            }
        }
        return list;
    }
}

