/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.map;

import bak.pcj.ByteCollection;
import bak.pcj.hash.DefaultByteHashFunction;
import bak.pcj.hash.DefaultIntHashFunction;
import bak.pcj.map.IntKeyByteMap;
import bak.pcj.map.IntKeyByteMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.IntSet;
import bak.pcj.util.Exceptions;

public abstract class AbstractIntKeyByteMap
implements IntKeyByteMap {
    protected AbstractIntKeyByteMap() {
    }

    public void clear() {
        IntKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public byte remove(int key) {
        IntKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            byte value = i.getValue();
            i.remove();
            return value;
        }
        return MapDefaults.defaultByte();
    }

    public void putAll(IntKeyByteMap map) {
        IntKeyByteMapIterator i = map.entries();
        while (i.hasNext()) {
            i.next();
            this.put(i.getKey(), i.getValue());
        }
    }

    public boolean containsKey(int key) {
        IntKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return true;
        }
        return false;
    }

    public byte get(int key) {
        IntKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return i.getValue();
        }
        return MapDefaults.defaultByte();
    }

    public boolean containsValue(byte value) {
        IntKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getValue() != value) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IntKeyByteMap)) {
            return false;
        }
        IntKeyByteMap map = (IntKeyByteMap)obj;
        if (this.size() != map.size()) {
            return false;
        }
        IntKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            int k = i.getKey();
            if (map.containsKey(k) && map.lget() == i.getValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        IntKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            h += DefaultIntHashFunction.INSTANCE.hash(i.getKey()) ^ DefaultByteHashFunction.INSTANCE.hash(i.getValue());
        }
        return h;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        int size = 0;
        IntKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    public byte tget(int key) {
        byte value = this.get(key);
        if (value == MapDefaults.defaultByte() && !this.containsKey(key)) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        IntKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            i.next();
            s.append(String.valueOf(i.getKey()));
            s.append("->");
            s.append(String.valueOf(i.getValue()));
        }
        s.append(']');
        return s.toString();
    }

    public void trimToSize() {
    }

    public abstract ByteCollection values();

    public abstract byte put(int var1, byte var2);

    public abstract byte lget();

    public abstract IntSet keySet();

    public abstract IntKeyByteMapIterator entries();
}

