/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.map;

import bak.pcj.FloatCollection;
import bak.pcj.hash.DefaultDoubleHashFunction;
import bak.pcj.hash.DefaultFloatHashFunction;
import bak.pcj.map.DoubleKeyFloatMap;
import bak.pcj.map.DoubleKeyFloatMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.DoubleSet;
import bak.pcj.util.Exceptions;

public abstract class AbstractDoubleKeyFloatMap
implements DoubleKeyFloatMap {
    protected AbstractDoubleKeyFloatMap() {
    }

    public void clear() {
        DoubleKeyFloatMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public float remove(double key) {
        DoubleKeyFloatMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            float value = i.getValue();
            i.remove();
            return value;
        }
        return MapDefaults.defaultFloat();
    }

    public void putAll(DoubleKeyFloatMap map) {
        DoubleKeyFloatMapIterator i = map.entries();
        while (i.hasNext()) {
            i.next();
            this.put(i.getKey(), i.getValue());
        }
    }

    public boolean containsKey(double key) {
        DoubleKeyFloatMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return true;
        }
        return false;
    }

    public float get(double key) {
        DoubleKeyFloatMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return i.getValue();
        }
        return MapDefaults.defaultFloat();
    }

    public boolean containsValue(float value) {
        DoubleKeyFloatMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getValue() != value) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DoubleKeyFloatMap)) {
            return false;
        }
        DoubleKeyFloatMap map = (DoubleKeyFloatMap)obj;
        if (this.size() != map.size()) {
            return false;
        }
        DoubleKeyFloatMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            double k = i.getKey();
            if (map.containsKey(k) && map.lget() == i.getValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        DoubleKeyFloatMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            h += DefaultDoubleHashFunction.INSTANCE.hash(i.getKey()) ^ DefaultFloatHashFunction.INSTANCE.hash(i.getValue());
        }
        return h;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        int size = 0;
        DoubleKeyFloatMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    public float tget(double key) {
        float value = this.get(key);
        if (value == MapDefaults.defaultFloat() && !this.containsKey(key)) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        DoubleKeyFloatMapIterator i = this.entries();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            i.next();
            s.append(String.valueOf(i.getKey()));
            s.append("->");
            s.append(String.valueOf(i.getValue()));
        }
        s.append(']');
        return s.toString();
    }

    public void trimToSize() {
    }

    public abstract FloatCollection values();

    public abstract float put(double var1, float var3);

    public abstract float lget();

    public abstract DoubleSet keySet();

    public abstract DoubleKeyFloatMapIterator entries();
}

