/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.builder;

import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import org.geotools.Builder;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.builder.AbstractStyleBuilder;
import org.geotools.styling.builder.ChannelSelectionBuilder;
import org.geotools.styling.builder.ColorMapBuilder;
import org.geotools.styling.builder.ContrastEnhancementBuilder;
import org.geotools.styling.builder.DescriptionBuilder;
import org.geotools.styling.builder.LineSymbolizerBuilder;
import org.geotools.styling.builder.PolygonSymbolizerBuilder;
import org.geotools.styling.builder.ShadedReliefBuilder;
import org.geotools.styling.builder.StyleBuilder;
import org.geotools.styling.builder.SymbolizerBuilder;
import org.opengis.filter.expression.Expression;
import org.opengis.style.ChannelSelection;
import org.opengis.style.ColorMap;
import org.opengis.style.ContrastEnhancement;
import org.opengis.style.Description;
import org.opengis.style.OverlapBehavior;
import org.opengis.style.PolygonSymbolizer;
import org.opengis.style.ShadedRelief;
import org.opengis.style.Symbolizer;

public class RasterSymbolizerBuilder
extends SymbolizerBuilder<RasterSymbolizer> {
    private String name;
    private Expression geometry;
    private DescriptionBuilder description = new DescriptionBuilder().unset();
    private Unit<?> uom;
    private Expression opacity;
    private ChannelSelectionBuilder channelSelection = new ChannelSelectionBuilder(this).unset();
    private ColorMapBuilder colorMap = new ColorMapBuilder(this).unset();
    private OverlapBehavior overlapsBehaviour;
    private ContrastEnhancementBuilder contrast = new ContrastEnhancementBuilder(this).unset();
    private ShadedReliefBuilder shadedRelief = new ShadedReliefBuilder(this).unset();
    private Builder<? extends Symbolizer> outline;

    public RasterSymbolizerBuilder() {
        this((AbstractStyleBuilder<?>)null);
    }

    public RasterSymbolizerBuilder(AbstractStyleBuilder<?> parent) {
        super(parent);
        this.reset();
    }

    public RasterSymbolizerBuilder name(String name) {
        this.name = name;
        this.unset = false;
        return this;
    }

    public DescriptionBuilder description() {
        this.unset = false;
        return this.description;
    }

    public RasterSymbolizerBuilder geometry(Expression geometry) {
        this.geometry = geometry;
        this.unset = false;
        return this;
    }

    public RasterSymbolizerBuilder geometry(String cqlExpression) {
        return this.geometry(this.cqlExpression(cqlExpression));
    }

    public RasterSymbolizerBuilder opacity(Expression opacity) {
        this.opacity = opacity;
        this.unset = false;
        return this;
    }

    public RasterSymbolizerBuilder opacity(double opacity) {
        return this.opacity(this.literal(opacity));
    }

    public RasterSymbolizerBuilder opacity(String cqlExpression) {
        return this.opacity(this.cqlExpression(cqlExpression));
    }

    public RasterSymbolizerBuilder uom(Unit<Length> uom) {
        this.unset = false;
        this.uom = uom;
        return this;
    }

    public ChannelSelectionBuilder channelSelection() {
        this.unset = false;
        return this.channelSelection;
    }

    public ColorMapBuilder colorMap() {
        this.unset = false;
        return this.colorMap;
    }

    public ContrastEnhancementBuilder contrastEnhancement() {
        this.unset = false;
        return this.contrast;
    }

    public ShadedReliefBuilder shadedRelief() {
        this.unset = false;
        return this.shadedRelief;
    }

    public RasterSymbolizerBuilder overlapBehavior(OverlapBehavior behavior) {
        this.unset = false;
        this.overlapsBehaviour = behavior;
        return this;
    }

    @Override
    public RasterSymbolizer build() {
        if (this.unset) {
            return null;
        }
        org.opengis.style.RasterSymbolizer symbolizer = this.sf.rasterSymbolizer(this.name, this.geometry, (Description)this.description.build(), (Unit)this.uom, this.opacity, (ChannelSelection)this.channelSelection.build(), this.overlapsBehaviour, (ColorMap)this.colorMap.build(), (ContrastEnhancement)this.contrast.build(), (ShadedRelief)this.shadedRelief.build(), this.outline != null ? this.outline.build() : null);
        symbolizer.getOptions().putAll(this.options);
        return symbolizer;
    }

    public RasterSymbolizerBuilder reset() {
        this.opacity = this.literal(1.0);
        this.channelSelection.unset();
        this.contrast.unset();
        this.unset = false;
        this.outline = null;
        return this;
    }

    public RasterSymbolizerBuilder reset(RasterSymbolizer symbolizer) {
        if (symbolizer == null) {
            return this.reset();
        }
        this.opacity = symbolizer.getOpacity();
        this.channelSelection.reset(symbolizer.getChannelSelection());
        this.colorMap.reset(symbolizer.getColorMap());
        this.contrast.reset(symbolizer.getContrastEnhancement());
        if (symbolizer.getImageOutline() instanceof LineSymbolizer) {
            this.outline = new LineSymbolizerBuilder().reset((LineSymbolizer)symbolizer.getImageOutline());
        } else if (symbolizer.getImageOutline() instanceof PolygonSymbolizer) {
            this.outline = new PolygonSymbolizerBuilder().reset((PolygonSymbolizer)symbolizer.getImageOutline());
        }
        this.unset = false;
        return this;
    }

    @Override
    protected void buildStyleInternal(StyleBuilder sb) {
        sb.featureTypeStyle().rule().raster().init(this);
    }

    @Override
    public RasterSymbolizerBuilder unset() {
        return (RasterSymbolizerBuilder)super.unset();
    }
}

