/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.expression;

import java.util.ArrayList;
import java.util.List;
import org.geotools.Builder;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.expression.ChildExpressionBuilder;
import org.geotools.filter.expression.LiteralBuilder;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;

public class FunctionBuilder
implements Builder<Function> {
    protected FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
    LiteralBuilder literal = new LiteralBuilder();
    boolean unset = false;
    private String name = null;
    List<Expression> args = new ArrayList<Expression>();
    ParamBuilder parent;

    public FunctionBuilder() {
        this.reset();
    }

    public FunctionBuilder(ParamBuilder parent) {
        this.reset();
        this.parent = parent;
    }

    public FunctionBuilder(Function origional) {
        this.reset(origional);
    }

    Expression put(int index, Expression expr) {
        if (index < this.args.size()) {
            this.args.set(index, expr);
        } else if (index == this.args.size()) {
            this.args.add(expr);
        } else {
            while (this.args.size() < index) {
                this.args.add(null);
            }
            this.args.add(expr);
        }
        return expr;
    }

    public ParamBuilder param() {
        return this.param(this.args.size());
    }

    public FunctionBuilder literal(Object literal) {
        this.put(this.args.size(), (Expression)this.ff.literal(literal));
        return this;
    }

    public FunctionBuilder property(String xpath) {
        this.put(this.args.size(), (Expression)this.ff.property(xpath));
        return this;
    }

    public FunctionBuilder function() {
        return this.param(this.args.size()).function();
    }

    public FunctionBuilder function(String name) {
        return this.param(this.args.size()).function(name);
    }

    public ParamBuilder param(int index) {
        return new ParamBuilder(index);
    }

    public FunctionBuilder name(String function) {
        this.name = function;
        return this;
    }

    public FunctionBuilder fallback(Object obj) {
        this.literal.value(obj);
        return this;
    }

    public LiteralBuilder fallback() {
        return this.literal;
    }

    @Override
    public Function build() {
        if (this.name == null) {
            return null;
        }
        Expression[] arguments = new Expression[this.args.size()];
        for (int index = 0; index < this.args.size(); ++index) {
            arguments[index] = this.args.get(index);
        }
        return this.ff.function(this.name, arguments);
    }

    public FunctionBuilder reset() {
        this.name = null;
        this.args.clear();
        this.literal.unset();
        return this;
    }

    public FunctionBuilder reset(Function original) {
        this.name = original.getName();
        this.args.clear();
        this.args.addAll(original.getParameters());
        this.literal.reset(original.getFallbackValue());
        return this;
    }

    public FunctionBuilder unset() {
        this.name = null;
        this.args.clear();
        this.literal.unset();
        return this;
    }

    public FunctionBuilder end() {
        if (this.parent == null) {
            throw new IllegalArgumentException("No parent set");
        }
        return (FunctionBuilder)this.parent.end();
    }

    public class ParamBuilder
    extends ChildExpressionBuilder<FunctionBuilder> {
        int index;

        ParamBuilder(int index) {
            super(FunctionBuilder.this, index < FunctionBuilder.this.args.size() ? FunctionBuilder.this.args.get(index) : null);
            this.index = index;
        }

        @Override
        public Expression build() {
            return FunctionBuilder.this.put(this.index, super.build());
        }

        public ParamBuilder param() {
            this.build();
            return new ParamBuilder(this.index + 1);
        }

        @Override
        public FunctionBuilder function() {
            this.delegate = new FunctionBuilder(this);
            this.unset = false;
            return (FunctionBuilder)this.delegate;
        }

        @Override
        public FunctionBuilder function(String name) {
            this.delegate = new FunctionBuilder(this).name(name);
            this.unset = false;
            return (FunctionBuilder)this.delegate;
        }
    }
}

