/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.thread;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.thread.DedicatedTaskRunner;
import org.apache.activemq.thread.PooledTaskRunner;
import org.apache.activemq.thread.Task;
import org.apache.activemq.thread.TaskRunner;

public class TaskRunnerFactory
implements Executor {
    private ExecutorService executor;
    private int maxIterationsPerRun;
    private String name;
    private int priority;
    private boolean daemon;
    private AtomicLong id = new AtomicLong(0L);
    private boolean dedicatedTaskRunner;
    private AtomicBoolean initDone = new AtomicBoolean(false);

    public TaskRunnerFactory() {
        this("ActiveMQ Task", 5, true, 1000);
    }

    private TaskRunnerFactory(String name, int priority, boolean daemon, int maxIterationsPerRun) {
        this(name, priority, daemon, maxIterationsPerRun, false);
    }

    public TaskRunnerFactory(String name, int priority, boolean daemon, int maxIterationsPerRun, boolean dedicatedTaskRunner) {
        this.name = name;
        this.priority = priority;
        this.daemon = daemon;
        this.maxIterationsPerRun = maxIterationsPerRun;
        this.dedicatedTaskRunner = dedicatedTaskRunner;
    }

    public void init() {
        if (this.initDone.compareAndSet(false, true)) {
            if (this.dedicatedTaskRunner || "true".equalsIgnoreCase(System.getProperty("org.apache.activemq.UseDedicatedTaskRunner"))) {
                this.executor = null;
            } else if (this.executor == null) {
                this.executor = this.createDefaultExecutor();
            }
        }
    }

    public void shutdown() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        this.initDone.set(false);
    }

    public TaskRunner createTaskRunner(Task task, String name) {
        this.init();
        if (this.executor != null) {
            return new PooledTaskRunner(this.executor, task, this.maxIterationsPerRun);
        }
        return new DedicatedTaskRunner(task, name, this.priority, this.daemon);
    }

    @Override
    public void execute(Runnable runnable) {
        this.execute(runnable, "ActiveMQ Task");
    }

    public void execute(Runnable runnable, String name) {
        this.init();
        if (this.executor != null) {
            this.executor.execute(runnable);
        } else {
            new Thread(runnable, name + "-" + this.id.incrementAndGet()).start();
        }
    }

    protected ExecutorService createDefaultExecutor() {
        ThreadPoolExecutor rc = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 30L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, TaskRunnerFactory.this.name + "-" + TaskRunnerFactory.this.id.incrementAndGet());
                thread.setDaemon(TaskRunnerFactory.this.daemon);
                thread.setPriority(TaskRunnerFactory.this.priority);
                return thread;
            }
        });
        return rc;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    public int getMaxIterationsPerRun() {
        return this.maxIterationsPerRun;
    }

    public void setMaxIterationsPerRun(int maxIterationsPerRun) {
        this.maxIterationsPerRun = maxIterationsPerRun;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public boolean isDedicatedTaskRunner() {
        return this.dedicatedTaskRunner;
    }

    public void setDedicatedTaskRunner(boolean dedicatedTaskRunner) {
        this.dedicatedTaskRunner = dedicatedTaskRunner;
    }
}

