/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadaptor;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.kaha.Marshaller;
import org.apache.activemq.kaha.impl.index.IndexItem;
import org.apache.activemq.store.kahadaptor.ConsumerMessageRef;

public class ConsumerMessageRefMarshaller
implements Marshaller {
    public void writePayload(Object object, DataOutput dataOut) throws IOException {
        ConsumerMessageRef ref = (ConsumerMessageRef)object;
        dataOut.writeUTF(ref.getMessageId().toString());
        IndexItem item = (IndexItem)ref.getMessageEntry();
        dataOut.writeLong(item.getOffset());
        item.write(dataOut);
        item = (IndexItem)ref.getAckEntry();
        dataOut.writeLong(item.getOffset());
        item.write(dataOut);
    }

    public Object readPayload(DataInput dataIn) throws IOException {
        ConsumerMessageRef ref = new ConsumerMessageRef();
        ref.setMessageId(new MessageId(dataIn.readUTF()));
        IndexItem item = new IndexItem();
        item.setOffset(dataIn.readLong());
        item.read(dataIn);
        ref.setMessageEntry(item);
        item = new IndexItem();
        item.setOffset(dataIn.readLong());
        item.read(dataIn);
        ref.setAckEntry(item);
        return ref;
    }
}

