/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import it.geosolutions.imageio.utilities.ImageIOUtilities;
import it.geosolutions.jaiext.range.NoDataContainer;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.factory.Hints;
import org.geotools.image.ImageWorker;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.resources.image.ColorUtilities;
import org.opengis.parameter.ParameterValueGroup;

final class BandSelector2D
extends GridCoverage2D {
    private static final long serialVersionUID = -2833594454437021628L;
    private final int[] bandIndices;

    private BandSelector2D(GridCoverage2D source, PlanarImage image, GridSampleDimension[] bands, int[] bandIndices, Hints hints) {
        super((CharSequence)source.getName(), image, source.getGridGeometry(), bands, new GridCoverage2D[]{source}, source.getProperties(), hints);
        this.bandIndices = bandIndices;
        assert (bandIndices == null || bandIndices.length == bands.length);
    }

    static GridCoverage2D create(ParameterValueGroup parameters, Hints hints) {
        int visibleTargetBand;
        int visibleSourceBand;
        RenderedImage sourceImage;
        GridSampleDimension[] targetBands;
        GridSampleDimension[] sourceBands;
        GridCoverage2D source = (GridCoverage2D)((Object)parameters.parameter("Source").getValue());
        int[] bandIndices = parameters.parameter("SampleDimensions").intValueList();
        if (bandIndices != null) {
            bandIndices = (int[])bandIndices.clone();
        }
        Integer visibleBand = (Integer)parameters.parameter("VisibleSampleDimension").getValue();
        while (true) {
            targetBands = sourceBands = source.getSampleDimensions();
            if (bandIndices != null) {
                if (bandIndices.length != sourceBands.length || !BandSelector2D.isIdentity(bandIndices)) {
                    targetBands = new GridSampleDimension[bandIndices.length];
                    for (int i = 0; i < bandIndices.length; ++i) {
                        targetBands[i] = sourceBands[bandIndices[i]];
                    }
                } else {
                    bandIndices = null;
                }
            }
            sourceImage = source.getRenderedImage();
            visibleSourceBand = CoverageUtilities.getVisibleBand(sourceImage);
            if (visibleBand != null) {
                visibleTargetBand = BandSelector2D.mapSourceToTarget(visibleBand, bandIndices);
                if (visibleSourceBand < 0) {
                    throw new IllegalArgumentException("Visible sample dimension is not among the ones specified in SampleDimensions param");
                }
            } else {
                visibleTargetBand = BandSelector2D.mapSourceToTarget(visibleSourceBand, bandIndices);
                if (visibleTargetBand < 0) {
                    visibleTargetBand = 0;
                }
            }
            if (bandIndices == null && visibleSourceBand == visibleTargetBand) {
                return source;
            }
            if (!(source instanceof BandSelector2D)) break;
            int[] parentIndices = ((BandSelector2D)source).bandIndices;
            if (parentIndices != null) {
                if (bandIndices != null) {
                    for (int i = 0; i < bandIndices.length; ++i) {
                        bandIndices[i] = parentIndices[bandIndices[i]];
                    }
                } else {
                    bandIndices = (int[])parentIndices.clone();
                }
            }
            assert (source.getSources().size() == 1) : source;
            source = (GridCoverage2D)source.getSources().get(0);
        }
        String operation = "Null";
        ImageLayout layout = null;
        if (hints != null) {
            layout = (ImageLayout)hints.get((Object)JAI.KEY_IMAGE_LAYOUT);
        }
        if (layout == null) {
            layout = new ImageLayout();
        }
        if (visibleBand != null || !layout.isValid(512)) {
            ColorModel colors = sourceImage.getColorModel();
            if (colors instanceof IndexColorModel && sourceBands[visibleSourceBand].equals(targetBands[visibleTargetBand])) {
                IndexColorModel indexed = (IndexColorModel)colors;
                int[] ARGB = new int[indexed.getMapSize()];
                indexed.getRGBs(ARGB);
                colors = ColorUtilities.getIndexColorModel(ARGB, targetBands.length, visibleTargetBand);
            } else {
                colors = targetBands[visibleTargetBand].getColorModel(visibleTargetBand, targetBands.length);
            }
            if (colors != null) {
                layout.setColorModel(colors);
            }
            if (hints != null) {
                hints = hints.clone();
                hints.put((Object)JAI.KEY_IMAGE_LAYOUT, (Object)layout);
            } else {
                hints = new Hints(JAI.KEY_IMAGE_LAYOUT, (Object)layout);
            }
        }
        if (visibleBand == null) {
            visibleBand = visibleTargetBand;
        }
        ImageWorker w = new ImageWorker(sourceImage);
        PlanarImage image = targetBands != sourceBands ? w.setRenderingHints((RenderingHints)hints).retainBands(bandIndices).getPlanarImage() : w.setRenderingHints((RenderingHints)hints).nullOp().getPlanarImage();
        if (image.getColorModel() == null) {
            layout = (ImageLayout)hints.get((Object)JAI.KEY_IMAGE_LAYOUT);
            ColorModel tempCM = ImageIOUtilities.createColorModel((SampleModel)image.getSampleModel());
            if (tempCM != null) {
                layout.setColorModel(tempCM);
                ImageWorker iw = new ImageWorker((RenderedImage)image).setRenderingHints((RenderingHints)hints).format(image.getSampleModel().getDataType());
                image = iw.getPlanarImage();
                Map properties = source.getProperties();
                if (properties != null && CoverageUtilities.getNoDataProperty(source) != null) {
                    NoDataContainer noDataC = CoverageUtilities.getNoDataProperty(source);
                    Range noData = RangeFactory.convert((Range)noDataC.getAsRange(), (int)image.getSampleModel().getDataType());
                    CoverageUtilities.setNoDataProperty(properties, noData);
                }
            }
        }
        image.setProperty("GC_VisibleBand", (Object)visibleBand);
        return new BandSelector2D(source, image, targetBands, bandIndices, hints);
    }

    private static int mapSourceToTarget(int sourceBand, int[] bandIndices) {
        if (bandIndices == null) {
            return sourceBand;
        }
        for (int i = 0; i < bandIndices.length; ++i) {
            if (bandIndices[i] != sourceBand) continue;
            return i;
        }
        return -1;
    }

    private static boolean isIdentity(int[] bands) {
        for (int i = 0; i < bands.length; ++i) {
            if (bands[i] == i) continue;
            return false;
        }
        return true;
    }
}

