/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.scale;

import com.sun.media.jai.mlib.MlibScaleRIF;
import com.sun.media.jai.opimage.CopyOpImage;
import com.sun.media.jai.opimage.RIFUtil;
import it.geosolutions.jaiext.interpolators.InterpolationBicubic;
import it.geosolutions.jaiext.interpolators.InterpolationBilinear;
import it.geosolutions.jaiext.interpolators.InterpolationNearest;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.scale.ScaleBicubicOpImage;
import it.geosolutions.jaiext.scale.ScaleBilinearOpImage;
import it.geosolutions.jaiext.scale.ScaleGeneralOpImage;
import it.geosolutions.jaiext.scale.ScaleNearestOpImage;
import it.geosolutions.jaiext.translate.TranslateIntOpImage;
import it.geosolutions.jaiext.utilities.ImageUtilities;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.CRIFImpl;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;

public class ScaleCRIF
extends CRIFImpl {
    private static final float TOLERANCE = 0.01f;

    public ScaleCRIF() {
        super("scale");
    }

    public RenderedImage create(ParameterBlock paramBlock, RenderingHints renderHints) {
        double destinationNoData;
        ImageLayout layout = RIFUtil.getImageLayoutHint((RenderingHints)renderHints);
        BorderExtender extender = RIFUtil.getBorderExtenderHint((RenderingHints)renderHints);
        RenderedImage source = paramBlock.getRenderedSource(0);
        float xScale = paramBlock.getFloatParameter(0);
        float yScale = paramBlock.getFloatParameter(1);
        float xTrans = paramBlock.getFloatParameter(2);
        float yTrans = paramBlock.getFloatParameter(3);
        Interpolation interp = (Interpolation)paramBlock.getObjectParameter(4);
        Range nodata = (Range)paramBlock.getObjectParameter(7);
        nodata = RangeFactory.convert((Range)nodata, (int)source.getSampleModel().getDataType());
        double[] backgroundValues = (double[])paramBlock.getObjectParameter(8);
        Object property = paramBlock.getObjectParameter(5);
        ROI roi = null;
        boolean useRoiAccessor = false;
        if (property instanceof ROI) {
            roi = (ROI)property;
            PlanarImage temp = PlanarImage.wrapRenderedImage((RenderedImage)source);
            temp.setProperty("ROI", (Object)roi);
            source = temp;
            useRoiAccessor = (Boolean)paramBlock.getObjectParameter(6);
        }
        Rectangle sourceBounds = new Rectangle(source.getMinX(), source.getMinY(), source.getWidth(), source.getHeight());
        if (xScale == 1.0f && yScale == 1.0f && xTrans == 0.0f && yTrans == 0.0f && (roi == null || roi.getBounds().isEmpty() || roi.contains(sourceBounds))) {
            return new CopyOpImage(source, (Map)renderHints, layout);
        }
        if (xScale == 1.0f && yScale == 1.0f && Math.abs(xTrans - (float)((int)xTrans)) < 0.01f && Math.abs(yTrans - (float)((int)yTrans)) < 0.01f && layout == null && (roi == null || roi.getBounds().isEmpty() || roi.contains(sourceBounds))) {
            return new TranslateIntOpImage(source, (Map)renderHints, (int)xTrans, (int)yTrans);
        }
        try {
            RenderedImage accelerated;
            if ((roi == null || ImageUtilities.isMediaLibAvailable() && (roi.getBounds().isEmpty() || roi.contains(sourceBounds))) && nodata == null && (accelerated = new MlibScaleRIF().create(paramBlock, renderHints)) != null) {
                return accelerated;
            }
        }
        catch (Exception accelerated) {
            // empty catch block
        }
        SampleModel sm = source.getSampleModel();
        boolean isBinary = sm instanceof MultiPixelPackedSampleModel && sm.getSampleSize(0) == 1 && (sm.getDataType() == 0 || sm.getDataType() == 1 || sm.getDataType() == 3);
        boolean nearestInterp = interp instanceof InterpolationNearest || interp instanceof javax.media.jai.InterpolationNearest;
        boolean bilinearInterp = interp instanceof InterpolationBilinear || interp instanceof javax.media.jai.InterpolationBilinear;
        boolean bicubicInterp = interp instanceof InterpolationBicubic || interp instanceof javax.media.jai.InterpolationBicubic || interp instanceof InterpolationBicubic2;
        int dataType = source.getSampleModel().getDataType();
        double d = destinationNoData = backgroundValues != null && backgroundValues.length > 0 ? backgroundValues[0] : 0.0;
        if (interp instanceof javax.media.jai.InterpolationNearest) {
            interp = new InterpolationNearest(nodata, useRoiAccessor, destinationNoData, dataType);
        } else if (interp instanceof javax.media.jai.InterpolationBilinear) {
            interp = new InterpolationBilinear(interp.getSubsampleBitsH(), nodata, useRoiAccessor, destinationNoData, dataType);
        } else if (interp instanceof javax.media.jai.InterpolationBicubic) {
            javax.media.jai.InterpolationBicubic bic = (javax.media.jai.InterpolationBicubic)interp;
            interp = new InterpolationBicubic(bic.getSubsampleBitsH(), nodata, useRoiAccessor, destinationNoData, dataType, true, bic.getPrecisionBits());
        } else if (interp instanceof InterpolationBicubic2) {
            InterpolationBicubic2 bic = (InterpolationBicubic2)interp;
            interp = new InterpolationBicubic(bic.getSubsampleBitsH(), nodata, useRoiAccessor, destinationNoData, dataType, false, bic.getPrecisionBits());
        }
        if (nearestInterp && isBinary) {
            return new ScaleGeneralOpImage(source, layout, (Map)renderHints, extender, interp, xScale, yScale, xTrans, yTrans, useRoiAccessor, nodata, backgroundValues);
        }
        if (nearestInterp && !isBinary) {
            return new ScaleNearestOpImage(source, layout, (Map)renderHints, extender, interp, xScale, yScale, xTrans, yTrans, useRoiAccessor, nodata, backgroundValues);
        }
        if (bilinearInterp && !isBinary) {
            return new ScaleBilinearOpImage(source, layout, (Map)renderHints, extender, interp, xScale, yScale, xTrans, yTrans, useRoiAccessor, nodata, backgroundValues);
        }
        if (bilinearInterp && isBinary) {
            return new ScaleGeneralOpImage(source, layout, (Map)renderHints, extender, interp, xScale, yScale, xTrans, yTrans, useRoiAccessor, nodata, backgroundValues);
        }
        if (bicubicInterp && !isBinary) {
            return new ScaleBicubicOpImage(source, layout, (Map)renderHints, extender, interp, xScale, yScale, xTrans, yTrans, useRoiAccessor, nodata, backgroundValues);
        }
        if (bicubicInterp && isBinary) {
            return new ScaleGeneralOpImage(source, layout, (Map)renderHints, extender, interp, xScale, yScale, xTrans, yTrans, useRoiAccessor, nodata, backgroundValues);
        }
        return new ScaleGeneralOpImage(source, layout, (Map)renderHints, extender, interp, xScale, yScale, xTrans, yTrans, useRoiAccessor, nodata, backgroundValues);
    }

    public RenderedImage create(RenderContext renderContext, ParameterBlock paramBlock) {
        return paramBlock.getRenderedSource(0);
    }

    public RenderContext mapRenderContext(int i, RenderContext renderContext, ParameterBlock paramBlock, RenderableImage image) {
        float scale_x = paramBlock.getFloatParameter(0);
        float scale_y = paramBlock.getFloatParameter(1);
        float trans_x = paramBlock.getFloatParameter(2);
        float trans_y = paramBlock.getFloatParameter(3);
        AffineTransform scale = new AffineTransform((double)scale_x, 0.0, 0.0, (double)scale_y, (double)trans_x, (double)trans_y);
        RenderContext RC = (RenderContext)renderContext.clone();
        AffineTransform usr2dev = RC.getTransform();
        usr2dev.concatenate(scale);
        RC.setTransform(usr2dev);
        return RC;
    }

    public Rectangle2D getBounds2D(ParameterBlock paramBlock) {
        RenderableImage source = paramBlock.getRenderableSource(0);
        float scale_x = paramBlock.getFloatParameter(0);
        float scale_y = paramBlock.getFloatParameter(1);
        float trans_x = paramBlock.getFloatParameter(2);
        float trans_y = paramBlock.getFloatParameter(3);
        float x0 = source.getMinX();
        float y0 = source.getMinY();
        float w = source.getWidth();
        float h = source.getHeight();
        float d_x0 = x0 * scale_x + trans_x;
        float d_y0 = y0 * scale_y + trans_y;
        float d_w = w * scale_x;
        float d_h = h * scale_y;
        return new Rectangle2D.Float(d_x0, d_y0, d_w, d_h);
    }
}

