/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search;

import bak.pcj.map.ObjectKeyIntMapIterator;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.fao.geonet.kernel.LocaleUtil;
import org.fao.geonet.kernel.search.LocalizedStringComparable;
import org.jdom.Element;

public class SummaryComparator
implements Comparator<SummaryElement>,
Serializable {
    private static final long serialVersionUID = -4668989929284491497L;
    private final Type _type;
    private final Element _configuration;
    private final Locale _locale;
    private SortOption _option;

    public SummaryComparator(SortOption option, Type type, String langCode, Element configuration) {
        this._option = option;
        this._type = type;
        this._configuration = configuration;
        this._locale = LocaleUtil.toLocale(langCode);
    }

    @Override
    public int compare(SummaryElement me1, SummaryElement me2) {
        String key1 = me1.name;
        String key2 = me2.name;
        int count1 = me1.count;
        int count2 = me2.count;
        switch (this._option) {
            case NAME: {
                int cmp = this.compareKeys(key1, key2);
                if (cmp != 0) {
                    return cmp;
                }
                return this.compareCount(count1, count2);
            }
            case FREQUENCY: {
                return this.compareCount(count1, count2);
            }
        }
        throw new AssertionError((Object)((Object)((Object)this._option) + "is not handled by this method"));
    }

    private int compareCount(Integer count1, Integer count2) {
        int cmp = count2.compareTo(count1);
        if (cmp != 0) {
            return cmp;
        }
        return -1;
    }

    private int compareKeys(String key1, String key2) {
        Comparable<? extends Object> value1 = this._type.value(key1, this._locale, this._configuration);
        Comparable<? extends Object> value2 = this._type.value(key2, this._locale, this._configuration);
        return value1.compareTo(value2);
    }

    public static class SummaryElement {
        public final String name;
        public final int count;

        public SummaryElement(ObjectKeyIntMapIterator next) {
            this.name = (String)next.getKey();
            this.count = next.getValue();
        }
    }

    public static enum SortOption {
        NAME,
        FREQUENCY;


        public static SortOption parse(String order) {
            if (order.equals("freq") || order.equals("frequency")) {
                return FREQUENCY;
            }
            return SortOption.valueOf(order.toUpperCase());
        }
    }

    public static enum Type {
        STRING{

            public Comparable<LocalizedStringComparable> value(String string, Locale locale, Element configuration) {
                return new LocalizedStringComparable(string, locale);
            }
        }
        ,
        NUMBER{

            public Comparable<Double> value(String string, Locale locale, Element configuration) {
                try {
                    return Double.valueOf(string.trim());
                }
                catch (NumberFormatException e) {
                    return 2.147483647E9;
                }
            }
        }
        ,
        SCALE{

            public Comparable<Double> value(String string, Locale locale, Element configuration) {
                String scale = string;
                if (string.contains("/")) {
                    String[] parts = string.split("/");
                    scale = parts[parts.length - 1];
                } else if (string.contains("\\")) {
                    String[] parts = string.split("\\\\");
                    scale = parts[parts.length - 1];
                } else if (string.contains(":")) {
                    String[] parts = string.split(":");
                    scale = parts[parts.length - 1];
                }
                try {
                    return Double.valueOf(scale.trim());
                }
                catch (NullPointerException e) {
                    return 2.147483647E9;
                }
            }
        }
        ,
        DATE{

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Comparable<Date> value(String string, Locale locale, Element configuration) {
                ArrayList<DateFormat> formats = new ArrayList<DateFormat>();
                for (Object child : configuration.getChildren("dateFormat")) {
                    Element elem = (Element)child;
                    Map map = dateformats;
                    synchronized (map) {
                        DateFormat format = (DateFormat)dateformats.get(elem.getValue());
                        if (format == null) {
                            dateformats.put(elem.getValue(), new SimpleDateFormat(elem.getValue()));
                        }
                        formats.add(format);
                    }
                }
                formats.add((DateFormat)dateformats.get(3));
                formats.add((DateFormat)dateformats.get(2));
                formats.add((DateFormat)dateformats.get(1));
                for (DateFormat dateFormat : formats) {
                    try {
                        Date date = dateFormat.parse(string);
                        return date;
                    }
                    catch (ParseException parseException) {
                    }
                }
                throw new IllegalArgumentException(string + " is not a recognized date pattern.  Add a dateFormat element to the configuration");
            }
        };

        private static Map<Object, DateFormat> dateformats;

        public static Type parse(String type) {
            return Type.valueOf(type.toUpperCase());
        }

        public abstract Comparable<? extends Object> value(String var1, Locale var2, Element var3);

        static {
            dateformats = new HashMap<Object, DateFormat>();
            dateformats.put(3, SimpleDateFormat.getDateInstance(3));
            dateformats.put(2, SimpleDateFormat.getDateInstance(2));
            dateformats.put(1, SimpleDateFormat.getDateInstance(1));
        }
    }
}

