/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.metadata;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.metamodel.SingularAttribute;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataStatus;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.domain.StatusValue;
import org.fao.geonet.domain.StatusValueNotificationLevel;
import org.fao.geonet.domain.StatusValueType;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.User_;
import org.fao.geonet.events.md.MetadataStatusChanged;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.IMetadataStatus;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.datamanager.draft.DraftMetadataManager;
import org.fao.geonet.kernel.metadata.StatusActions;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.SortUtils;
import org.fao.geonet.repository.StatusValueRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.util.MailUtil;
import org.fao.geonet.util.XslUtil;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;

public class DefaultStatusActions
implements StatusActions {
    public static final Pattern metadataLuceneField = Pattern.compile("\\{\\{index:([^\\}]+)\\}\\}");
    protected ServiceContext context;
    protected String language;
    protected DataManager dm;
    @Autowired
    protected IMetadataUtils metadataUtils;
    protected String siteUrl;
    protected String siteName;
    protected UserSession session;
    protected boolean emailNotes = true;
    private String from;
    private String replyTo;
    private String replyToDescr;
    private StatusValueRepository _statusValueRepository;
    private IMetadataStatus metadataStatusManager;

    @Override
    public void init(ServiceContext context) throws Exception {
        this.context = context;
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        this._statusValueRepository = (StatusValueRepository)applicationContext.getBean(StatusValueRepository.class);
        this.metadataUtils = (IMetadataUtils)applicationContext.getBean(IMetadataUtils.class);
        this.language = context.getLanguage();
        SettingManager sm = (SettingManager)applicationContext.getBean(SettingManager.class);
        this.siteName = sm.getSiteName();
        this.from = sm.getValue("system/feedback/email");
        if (this.from == null || this.from.length() == 0) {
            context.error("Mail feedback address not configured, email notifications won't be sent.");
            this.emailNotes = false;
        }
        this.session = context.getUserSession();
        this.replyTo = this.session.getEmailAddr();
        if (this.replyTo != null) {
            this.replyToDescr = this.session.getName() + " " + this.session.getSurname();
        } else {
            this.replyTo = this.from;
            this.replyToDescr = this.siteName;
        }
        this.dm = (DataManager)applicationContext.getBean(DataManager.class);
        this.metadataStatusManager = (IMetadataStatus)applicationContext.getBean(IMetadataStatus.class);
        this.siteUrl = sm.getSiteURL(context);
    }

    @Override
    public void onEdit(int id, boolean minorEdit) throws Exception {
        if (Log.isTraceEnabled((String)"geonetwork.datamanager")) {
            Log.trace((String)"geonetwork.datamanager", (Object)("DefaultStatusActions.onEdit(" + id + ", " + minorEdit + ") with status " + this.dm.getCurrentStatus(id)));
        }
        if (!minorEdit && this.dm.getCurrentStatus(id).equals("2") && this.context.getBean(IMetadataManager.class) instanceof DraftMetadataManager) {
            ResourceBundle messages = ResourceBundle.getBundle("org.fao.geonet.api.Messages", new Locale(this.language));
            String changeMessage = String.format(messages.getString("status_email_text"), this.replyToDescr, this.replyTo, id);
            Log.trace((String)"geonetwork.datamanager", (Object)("Set DRAFT to current record with id " + id));
            this.dm.setStatus(this.context, id, Integer.valueOf("1"), new ISODate(), changeMessage);
        }
    }

    @Override
    public Set<Integer> onStatusChange(List<MetadataStatus> listOfStatus) throws Exception {
        HashSet<Integer> unchanged = new HashSet<Integer>();
        for (MetadataStatus status : listOfStatus) {
            MetadataStatus currentStatus = this.dm.getStatus(status.getId().getMetadataId());
            String currentStatusId = currentStatus != null ? String.valueOf(currentStatus.getId().getStatusId()) : "";
            String statusId = status.getId().getStatusId() + "";
            HashSet<Integer> listOfId = new HashSet<Integer>(1);
            listOfId.add(status.getId().getMetadataId());
            if (status.getStatusValue().getType().equals((Object)StatusValueType.workflow) && statusId.equals(currentStatusId)) {
                if (this.context.isDebugEnabled()) {
                    this.context.debug(String.format("Metadata %s already has status %s ", status.getId().getMetadataId(), status.getId().getStatusId()));
                }
                unchanged.add(status.getId().getMetadataId());
                continue;
            }
            this.metadataStatusManager.setStatusExt(status);
            try {
                this.notify(this.getUserToNotify(status), status);
            }
            catch (Exception e) {
                this.context.warning(String.format("Failed to send notification on status change for metadata %s with status %s. Error is: %s", status.getId().getMetadataId(), status.getId().getStatusId(), e.getMessage()));
            }
            Log.trace((String)"geonetwork.datamanager", (Object)"Throw workflow events.");
            for (Integer mid : listOfId) {
                if (unchanged.contains(mid)) continue;
                Log.debug((String)"geonetwork.datamanager", (Object)("  > Status changed for record (" + mid + ") to status " + status));
                this.context.getApplicationContext().publishEvent((ApplicationEvent)new MetadataStatusChanged(this.metadataUtils.findOne(mid), status.getStatusValue(), status.getChangeMessage(), Integer.valueOf(status.getId().getUserId())));
            }
        }
        return unchanged;
    }

    private void applyRulesForStatusChange(MetadataStatus status) throws Exception {
        String statusId = status.getId().getStatusId() + "";
        if (statusId.equals("2")) {
            AccessManager accessManager = this.context.getBean(AccessManager.class);
            if (!accessManager.canReview(this.context, String.valueOf(status.getId().getMetadataId()))) {
                throw new SecurityException(String.format("You can't edit record with ID %s", String.valueOf(status.getId().getMetadataId())));
            }
        } else if (statusId.equals("1")) {
            this.unsetAllOperations(status.getId().getMetadataId());
        }
    }

    private void notify(List<User> userToNotify, MetadataStatus status) throws Exception {
        ResourceBundle messages = ResourceBundle.getBundle("org.fao.geonet.api.Messages", new Locale(this.language));
        String translatedStatusName = this.getTranslatedStatusName(status.getId().getStatusId());
        String subjectTemplate = "";
        try {
            subjectTemplate = messages.getString("status_change_" + status.getStatusValue().getName() + "_email_subject");
        }
        catch (MissingResourceException e) {
            subjectTemplate = messages.getString("status_change_default_email_subject");
        }
        String subject = MessageFormat.format(subjectTemplate, this.siteName, translatedStatusName, this.replyToDescr);
        HashSet<Integer> listOfId = new HashSet<Integer>(1);
        listOfId.add(status.getId().getMetadataId());
        String textTemplate = "";
        try {
            textTemplate = messages.getString("status_change_" + status.getStatusValue().getName() + "_email_text");
        }
        catch (MissingResourceException e) {
            textTemplate = messages.getString("status_change_default_email_text");
        }
        UserRepository userRepository = this.context.getBean(UserRepository.class);
        User owner = (User)userRepository.findOne((Serializable)status.getOwner());
        String message = MessageFormat.format(textTemplate, this.replyToDescr, status.getChangeMessage(), translatedStatusName, status.getId().getChangeDate(), status.getDueDate(), status.getCloseDate(), owner == null ? "" : owner.getName() + " " + owner.getSurname(), this.siteUrl);
        IMetadataUtils metadataRepository = (IMetadataUtils)ApplicationContextHolder.get().getBean(IMetadataUtils.class);
        AbstractMetadata metadata = metadataRepository.findOne(status.getId().getMetadataId());
        subject = DefaultStatusActions.compileMessageWithIndexFields(subject, metadata.getUuid(), this.language);
        message = DefaultStatusActions.compileMessageWithIndexFields(message, metadata.getUuid(), this.language);
        for (User user : userToNotify) {
            this.sendEmail(user.getEmail(), subject, message);
        }
    }

    protected List<User> getUserToNotify(MetadataStatus status) {
        StatusValueNotificationLevel notificationLevel = status.getStatusValue().getNotificationLevel();
        UserRepository userRepository = this.context.getBean(UserRepository.class);
        List<Object> users = new ArrayList<User>();
        HashSet<Integer> listOfId = new HashSet<Integer>(1);
        listOfId.add(status.getId().getMetadataId());
        if (notificationLevel != null) {
            SettingManager settingManager;
            String adminEmail;
            if (notificationLevel == StatusValueNotificationLevel.statusUserOwner) {
                User owner = (User)userRepository.findOne((Serializable)status.getOwner());
                users.add(owner);
            } else if (notificationLevel == StatusValueNotificationLevel.recordProfileReviewer) {
                List results = userRepository.findAllByGroupOwnerNameAndProfile(listOfId, Profile.Reviewer, SortUtils.createSort((SingularAttribute[])new SingularAttribute[]{User_.name}));
                for (Pair p : results) {
                    users.add((User)p.two());
                }
            } else if (notificationLevel == StatusValueNotificationLevel.recordUserAuthor) {
                List records = this.context.getBean(MetadataRepository.class).findAll(listOfId);
                for (Metadata r : records) {
                    users.add(userRepository.findOne((Serializable)r.getSourceInfo().getOwner()));
                }
            } else if (notificationLevel.name().startsWith("catalogueProfile")) {
                String profileId = notificationLevel.name().replace("catalogueProfile", "");
                Profile profile = Profile.findProfileIgnoreCase((String)profileId);
                users = userRepository.findAllByProfile(profile);
            } else if (notificationLevel == StatusValueNotificationLevel.catalogueAdministrator && StringUtils.isNotEmpty((String)(adminEmail = (settingManager = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class)).getValue("system/feedback/email")))) {
                HashSet<String> emails = new HashSet<String>(1);
                emails.add(adminEmail);
                User catalogueAdmin = new User().setEmailAddresses(emails);
                users.add(catalogueAdmin);
            }
        }
        return users;
    }

    private void unsetAllOperations(int mdId) throws Exception {
        Log.trace((String)"geonetwork.datamanager", (Object)("DefaultStatusActions.unsetAllOperations(" + mdId + ")"));
        int allGroup = 1;
        for (ReservedOperation op : ReservedOperation.values()) {
            this.dm.forceUnsetOperation(this.context, mdId, allGroup, op.getId());
        }
    }

    public static String compileMessageWithIndexFields(String message, String uuid, String language) {
        Matcher m = metadataLuceneField.matcher(message);
        ArrayList<String> fields = new ArrayList<String>();
        while (m.find()) {
            fields.add(m.group(1));
        }
        for (String f : fields) {
            String mdf = XslUtil.getIndexField(null, uuid, f, language);
            message = message.replace("{{index:" + f + "}}", mdf);
        }
        return message;
    }

    private String getTranslatedStatusName(int statusValueId) {
        String translatedStatusName = "";
        StatusValue s = this._statusValueRepository.findOneById(statusValueId);
        translatedStatusName = s == null ? statusValueId + " (Status not found in database translation table. Check the content of the StatusValueDes table.)" : s.getLabel(this.language);
        return translatedStatusName;
    }

    protected void sendEmail(String sendTo, String subject, String message) throws Exception {
        if (!this.emailNotes) {
            this.context.info("Would send email \nTo: " + sendTo + "\nSubject: " + subject + "\n Message:\n" + message);
        } else {
            ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
            SettingManager sm = (SettingManager)applicationContext.getBean(SettingManager.class);
            if (StringUtils.isNotBlank((String)sm.getValue("system/feedback/mailServer/username")) && StringUtils.isNotBlank((String)sm.getValue("system/feedback/mailServer/host"))) {
                ArrayList<String> to = new ArrayList<String>();
                to.add(sendTo);
                MailUtil.sendMail(to, subject, message, null, sm, this.replyTo, this.replyToDescr);
            }
        }
    }
}

