/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.datamanager.base;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import jeeves.xlink.Processor;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jetty.util.ConcurrentHashSet;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.records.attachments.Store;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Constants;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.InspireAtomFeed;
import org.fao.geonet.domain.MetadataCategory;
import org.fao.geonet.domain.MetadataStatus;
import org.fao.geonet.domain.MetadataStatusId_;
import org.fao.geonet.domain.MetadataStatus_;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.domain.MetadataValidation;
import org.fao.geonet.domain.MetadataValidationStatus;
import org.fao.geonet.domain.OperationAllowed;
import org.fao.geonet.domain.OperationAllowedId;
import org.fao.geonet.domain.ReservedGroup;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.domain.StatusValueType;
import org.fao.geonet.domain.User;
import org.fao.geonet.events.history.RecordDeletedEvent;
import org.fao.geonet.events.md.MetadataIndexCompleted;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.IndexMetadataTask;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.SelectionManager;
import org.fao.geonet.kernel.SvnManager;
import org.fao.geonet.kernel.XmlSerializer;
import org.fao.geonet.kernel.datamanager.IMetadataIndexer;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.datamanager.draft.DraftMetadataIndexer;
import org.fao.geonet.kernel.search.ISearchManager;
import org.fao.geonet.kernel.search.SearchManager;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.InspireAtomFeedRepository;
import org.fao.geonet.repository.MetadataStatusRepository;
import org.fao.geonet.repository.MetadataValidationRepository;
import org.fao.geonet.repository.OperationAllowedRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.repository.userfeedback.UserFeedbackRepository;
import org.fao.geonet.resources.Resources;
import org.fao.geonet.util.ThreadUtils;
import org.fao.geonet.utils.Log;
import org.jdom.Attribute;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.transaction.NoTransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

public class BaseMetadataIndexer
implements IMetadataIndexer,
ApplicationEventPublisherAware {
    Lock waitLoopLock = new ReentrantLock();
    Lock indexingLock = new ReentrantLock();
    @Autowired
    private SearchManager searchManager;
    @Autowired
    private GeonetworkDataDirectory geonetworkDataDirectory;
    @Autowired
    private MetadataStatusRepository statusRepository;
    private IMetadataUtils metadataUtils;
    private IMetadataManager metadataManager;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private OperationAllowedRepository operationAllowedRepository;
    @Autowired
    private GroupRepository groupRepository;
    @Autowired
    private MetadataValidationRepository metadataValidationRepository;
    @Autowired
    private SchemaManager schemaManager;
    @Autowired(required=false)
    private SvnManager svnManager;
    @Autowired
    private InspireAtomFeedRepository inspireAtomFeedRepository;
    @Autowired(required=false)
    private XmlSerializer xmlSerializer;
    @Autowired
    @Lazy
    private SettingManager settingManager;
    @Autowired
    private UserFeedbackRepository userFeedbackRepository;
    @Autowired
    @Qualifier(value="resourceStore")
    private Store store;
    @Autowired
    private Resources resources;
    private ServiceContext servContext;
    private ApplicationEventPublisher publisher;
    Set<String> waitForIndexing = new HashSet<String>();
    Set<String> indexing = new HashSet<String>();
    Set<IndexMetadataTask> batchIndex = new ConcurrentHashSet();

    @Override
    public void init(ServiceContext context, Boolean force) throws Exception {
        this.servContext = context;
    }

    @Override
    public void setMetadataUtils(IMetadataUtils metadataUtils) {
        this.metadataUtils = metadataUtils;
    }

    @Override
    public void setMetadataManager(IMetadataManager metadataManager) {
        this.metadataManager = metadataManager;
    }

    @Override
    public void forceIndexChanges() throws IOException {
        this.searchManager.forceIndexChanges();
    }

    @Override
    public int batchDeleteMetadataAndUpdateIndex(Specification<? extends AbstractMetadata> specification) throws Exception {
        List<? extends AbstractMetadata> metadataToDelete = this.metadataUtils.findAll(specification);
        metadataToDelete.forEach(md -> {
            try {
                UserSession userSession = ServiceContext.get().getUserSession();
                String xmlBefore = md.getData();
                this.store.delResources(ServiceContext.get(), md.getUuid());
                this.metadataManager.deleteMetadata(ServiceContext.get(), String.valueOf(md.getId()));
                new RecordDeletedEvent(Integer.valueOf(md.getId()), Integer.valueOf(userSession.getUserIdAsInt()), xmlBefore).publish((ApplicationContext)ApplicationContextHolder.get());
            }
            catch (Exception e) {
                Log.warning((String)"geonetwork.datamanager", (Object)String.format("Error during removal of metadata %s part of batch delete operation. This error may create a ghost record (ie. not in the index but still present in the database). You can reindex the catalogue to see it again. Error was: %s.", md.getUuid(), e.getMessage()));
                e.printStackTrace();
            }
        });
        return metadataToDelete.size();
    }

    @Override
    public synchronized void rebuildIndexXLinkedMetadata(ServiceContext context) throws Exception {
        Set<Integer> toIndex = this.searchManager.getDocsWithXLinks();
        if (Log.isDebugEnabled((String)"geonetwork.datamanager")) {
            Log.debug((String)"geonetwork.datamanager", (Object)("Will index " + toIndex.size() + " records with XLinks"));
        }
        if (toIndex.size() > 0) {
            Processor.clearCache();
            ArrayList<String> stringIds = new ArrayList<String>();
            for (Integer id : toIndex) {
                stringIds.add(id.toString());
            }
            this.batchIndexInThreadPool(context, stringIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void rebuildIndexForSelection(ServiceContext context, String bucket, boolean clearXlink) throws Exception {
        ArrayList<String> listOfIdsToIndex = new ArrayList<String>();
        UserSession session = context.getUserSession();
        SelectionManager sm = SelectionManager.getManager(session);
        Set<String> set = sm.getSelection(bucket);
        synchronized (set) {
            for (String uuid : sm.getSelection(bucket)) {
                String id = this.metadataUtils.getMetadataId(uuid);
                if (id == null) continue;
                listOfIdsToIndex.add(id);
            }
        }
        if (Log.isDebugEnabled((String)"geonetwork.datamanager")) {
            Log.debug((String)"geonetwork.datamanager", (Object)("Will index " + listOfIdsToIndex.size() + " records from selection."));
        }
        if (listOfIdsToIndex.size() > 0) {
            if (clearXlink) {
                Processor.clearCache();
            }
            this.batchIndexInThreadPool(context, listOfIdsToIndex);
        }
    }

    @Override
    public void batchIndexInThreadPool(ServiceContext context, List<?> metadataIds) {
        TransactionStatus transactionStatus = null;
        try {
            transactionStatus = TransactionAspectSupport.currentTransactionStatus();
        }
        catch (NoTransactionException noTransactionException) {
            // empty catch block
        }
        int threadCount = ThreadUtils.getNumberOfThreads();
        ExecutorService executor = Executors.newFixedThreadPool(threadCount);
        int perThread = metadataIds.size() < threadCount ? metadataIds.size() : metadataIds.size() / threadCount;
        int index = 0;
        if (Log.isDebugEnabled((String)"geonetwork.index")) {
            Log.debug((String)"geonetwork.index", (Object)("Indexing " + metadataIds.size() + " records."));
            Log.debug((String)"geonetwork.index", (Object)metadataIds.toString());
        }
        AtomicInteger numIndexedTracker = new AtomicInteger();
        while (index < metadataIds.size()) {
            int start = index;
            int count = Math.min(perThread, metadataIds.size() - start);
            int nbRecords = start + count;
            if (Log.isDebugEnabled((String)"geonetwork.index")) {
                Log.debug((String)"geonetwork.index", (Object)("Indexing records from " + start + " to " + nbRecords));
            }
            List<?> subList = metadataIds.subList(start, nbRecords);
            if (Log.isDebugEnabled((String)"geonetwork.index")) {
                Log.debug((String)"geonetwork.index", (Object)subList.toString());
            }
            IndexMetadataTask worker = new IndexMetadataTask(context, subList, this.batchIndex, transactionStatus, numIndexedTracker);
            executor.execute(worker);
            index += count;
        }
        executor.shutdown();
    }

    @Override
    public boolean isIndexing() {
        this.indexingLock.lock();
        try {
            boolean bl = !this.indexing.isEmpty() || !this.batchIndex.isEmpty();
            return bl;
        }
        finally {
            this.indexingLock.unlock();
        }
    }

    @Override
    public void indexMetadata(List<String> metadataIds) throws Exception {
        for (String metadataId : metadataIds) {
            this.indexMetadata(metadataId, false, null);
        }
        this.searchManager.forceIndexChanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void indexMetadata(String metadataId, boolean forceRefreshReaders, ISearchManager searchManager) throws Exception {
        AbstractMetadata fullMd;
        this.waitLoopLock.lock();
        if (this.waitForIndexing.contains(metadataId)) {
            return;
        }
        while (this.indexing.contains(metadataId)) {
            try {
                this.waitForIndexing.add(metadataId);
                BaseMetadataIndexer baseMetadataIndexer = this;
                synchronized (baseMetadataIndexer) {
                    this.wait(200L);
                }
                this.waitForIndexing.remove(metadataId);
            }
            catch (InterruptedException e) {
                this.waitForIndexing.remove(metadataId);
                this.waitLoopLock.unlock();
                return;
                catch (Throwable throwable) {
                    this.waitForIndexing.remove(metadataId);
                    throw throwable;
                }
            }
        }
        this.indexingLock.lock();
        try {
            this.indexing.add(metadataId);
        }
        finally {
            this.waitLoopLock.unlock();
        }
        try {
            List validationInfo;
            Object object;
            Group group;
            User user;
            String displayOrder;
            Vector<Element> moreFields = new Vector<Element>();
            int id$ = Integer.parseInt(metadataId);
            Element md = this.getXmlSerializer().selectNoXLinkResolver(metadataId, true, false);
            if (this.getXmlSerializer().resolveXLinks()) {
                List<Attribute> xlinks = Processor.getXLinks(md);
                if (xlinks.size() > 0) {
                    moreFields.add(SearchManager.makeField("_hasxlinks", "1", true, true));
                    for (Attribute xlink : xlinks) {
                        moreFields.add(SearchManager.makeField("_xlink", xlink.getValue(), true, true));
                    }
                    Processor.detachXLink(md, this.getServiceContext());
                } else {
                    moreFields.add(SearchManager.makeField("_hasxlinks", "0", true, true));
                }
            } else {
                moreFields.add(SearchManager.makeField("_hasxlinks", "0", true, true));
            }
            fullMd = this.metadataUtils.findOne(id$);
            String schema = fullMd.getDataInfo().getSchemaId();
            String createDate = fullMd.getDataInfo().getCreateDate().getDateAndTime();
            String changeDate = fullMd.getDataInfo().getChangeDate().getDateAndTime();
            String source = fullMd.getSourceInfo().getSourceId();
            MetadataType metadataType = fullMd.getDataInfo().getType();
            String root = fullMd.getDataInfo().getRoot();
            String uuid = fullMd.getUuid();
            String extra = fullMd.getDataInfo().getExtra();
            String isHarvested = String.valueOf(Constants.toYN_EnabledChar((boolean)fullMd.getHarvestInfo().isHarvested()));
            String owner = String.valueOf(fullMd.getSourceInfo().getOwner());
            Integer groupOwner = fullMd.getSourceInfo().getGroupOwner();
            String popularity = String.valueOf(fullMd.getDataInfo().getPopularity());
            String rating = String.valueOf(fullMd.getDataInfo().getRating());
            String string = displayOrder = fullMd.getDataInfo().getDisplayOrder() == null ? null : String.valueOf(fullMd.getDataInfo().getDisplayOrder());
            if (Log.isDebugEnabled((String)"geonetwork.datamanager")) {
                Log.debug((String)"geonetwork.datamanager", (Object)("record schema (" + schema + ")"));
                Log.debug((String)"geonetwork.datamanager", (Object)("record createDate (" + createDate + ")"));
            }
            moreFields.add(SearchManager.makeField("_root", root, true, true));
            moreFields.add(SearchManager.makeField("_schema", schema, true, true));
            moreFields.add(SearchManager.makeField("_createDate", createDate, true, true));
            moreFields.add(SearchManager.makeField("_changeDate", changeDate, true, true));
            moreFields.add(SearchManager.makeField("_source", source, true, true));
            moreFields.add(SearchManager.makeField("_isTemplate", metadataType.codeString, true, true));
            moreFields.add(SearchManager.makeField("_uuid", uuid, true, true));
            moreFields.add(SearchManager.makeField("_isHarvested", isHarvested, true, true));
            moreFields.add(SearchManager.makeField("_owner", owner, true, true));
            moreFields.add(SearchManager.makeField("_dummy", "0", false, true));
            moreFields.add(SearchManager.makeField("_popularity", popularity, true, true));
            moreFields.add(SearchManager.makeField("_rating", rating, true, true));
            if ("advanced".equals(this.settingManager.getValue("system/localrating/enable"))) {
                int nbOfFeedback = this.userFeedbackRepository.findByMetadata_Uuid(uuid).size();
                moreFields.add(SearchManager.makeField("feedbackCount", nbOfFeedback + "", true, true));
            }
            moreFields.add(SearchManager.makeField("_displayOrder", displayOrder, true, false));
            moreFields.add(SearchManager.makeField("_extra", extra, false, true));
            InspireAtomFeed feed = this.inspireAtomFeedRepository.findByMetadataId(id$);
            if (feed != null && StringUtils.isNotEmpty((String)feed.getAtom())) {
                moreFields.add(SearchManager.makeField("has_atom", "y", true, true));
                moreFields.add(SearchManager.makeField("any", feed.getAtom(), false, true));
            }
            if (owner != null && (user = (User)this.userRepository.findOne((Serializable)fullMd.getSourceInfo().getOwner())) != null) {
                moreFields.add(SearchManager.makeField("_userinfo", user.getUsername() + "|" + user.getSurname() + "|" + user.getName() + "|" + user.getProfile(), true, false));
                moreFields.add(SearchManager.makeField("recordOwner", user.getName() + " " + user.getSurname(), true, true));
            }
            String logoUUID = null;
            if (groupOwner != null && (group = (Group)this.groupRepository.findOne((Serializable)groupOwner)) != null) {
                moreFields.add(SearchManager.makeField("_groupOwner", String.valueOf(groupOwner), true, true));
                boolean preferGroup = this.settingManager.getValueAsBool("system/metadata/prefergrouplogo", true);
                if (group.getWebsite() != null && !group.getWebsite().isEmpty() && preferGroup) {
                    moreFields.add(SearchManager.makeField("_groupWebsite", group.getWebsite(), true, false));
                }
                if (group.getLogo() != null && preferGroup) {
                    logoUUID = group.getLogo();
                }
            }
            boolean added = false;
            if (StringUtils.isNotEmpty(logoUUID)) {
                Path harvesterLogosDir = this.resources.locateHarvesterLogosDir(this.getServiceContext());
                Resources.ResourceHolder logo = this.resources.getImage(this.getServiceContext(), logoUUID, harvesterLogosDir);
                object = null;
                try {
                    if (logo != null) {
                        added = true;
                        moreFields.add(SearchManager.makeField("_logo", "/images/harvesting/" + logo.getPath().getFileName(), true, false));
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (logo != null) {
                        if (object != null) {
                            try {
                                logo.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            logo.close();
                        }
                    }
                }
            }
            if (!added) {
                logoUUID = source + ".png";
                Path logosDir = this.resources.locateLogosDir(this.getServiceContext());
                Resources.ResourceHolder image = this.resources.getImage(this.getServiceContext(), logoUUID, logosDir);
                object = null;
                try {
                    if (image != null) {
                        moreFields.add(SearchManager.makeField("_logo", "/images/logos/" + logoUUID, true, false));
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (image != null) {
                        if (object != null) {
                            try {
                                image.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            image.close();
                        }
                    }
                }
            }
            List operationsAllowed = this.operationAllowedRepository.findAllById_MetadataId(id$);
            boolean isPublishedToAll = false;
            for (OperationAllowed operationAllowed : operationsAllowed) {
                Group g;
                OperationAllowedId operationAllowedId = operationAllowed.getId();
                int groupId = operationAllowedId.getGroupId();
                int operationId = operationAllowedId.getOperationId();
                moreFields.add(SearchManager.makeField("_op" + operationId, String.valueOf(groupId), true, true));
                if (operationId != ReservedOperation.view.getId() || (g = (Group)this.groupRepository.findOne((Serializable)Integer.valueOf(groupId))) == null) continue;
                moreFields.add(SearchManager.makeField("_groupPublished", g.getName(), true, true));
                if (g.getId() != ReservedGroup.all.getId()) continue;
                isPublishedToAll = true;
            }
            if (isPublishedToAll) {
                moreFields.add(SearchManager.makeField("_isPublishedToAll", "y", true, true));
            } else {
                moreFields.add(SearchManager.makeField("_isPublishedToAll", "n", true, true));
            }
            for (MetadataCategory category : fullMd.getCategories()) {
                moreFields.add(SearchManager.makeField("_cat", category.getName(), true, true));
            }
            Sort statusSort = new Sort(Sort.Direction.DESC, new String[]{MetadataStatus_.id.getName() + "." + MetadataStatusId_.changeDate.getName()});
            List statuses = this.statusRepository.findAllByIdAndByType(id$, StatusValueType.workflow, statusSort);
            if (!statuses.isEmpty()) {
                MetadataStatus stat = (MetadataStatus)statuses.get(0);
                String status = String.valueOf(stat.getId().getStatusId());
                moreFields.add(SearchManager.makeField("_status", status, true, true));
                String statusChangeDate = stat.getId().getChangeDate().getDateAndTime();
                moreFields.add(SearchManager.makeField("_statusChangeDate", statusChangeDate, true, true));
            }
            if ((validationInfo = this.metadataValidationRepository.findAllById_MetadataId(id$)).isEmpty()) {
                moreFields.add(SearchManager.makeField("_valid", "-1", true, true));
            } else {
                String isValid = "1";
                boolean hasInspireValidation = false;
                for (MetadataValidation vi : validationInfo) {
                    String type = vi.getId().getValidationType();
                    MetadataValidationStatus status = vi.getStatus();
                    if (!type.equalsIgnoreCase("inspire")) {
                        if (status == MetadataValidationStatus.INVALID && vi.isRequired().booleanValue()) {
                            isValid = "0";
                        }
                    } else {
                        hasInspireValidation = true;
                        moreFields.add(SearchManager.makeField("_inspireValidationDate", vi.getValidationDate().getDateAndTime(), true, true));
                        moreFields.add(SearchManager.makeField("_inspireReportUrl", vi.getReportUrl(), true, true));
                    }
                    moreFields.add(SearchManager.makeField("_valid_" + type, status.getCode(), true, true));
                }
                moreFields.add(SearchManager.makeField("_valid", isValid, true, true));
                if (!hasInspireValidation) {
                    moreFields.add(SearchManager.makeField("_valid_inspire", "-1", true, true));
                }
            }
            this.addExtraFields(fullMd, moreFields);
            if (searchManager == null) {
                searchManager = this.servContext.getBean(SearchManager.class);
            }
            searchManager.index(this.schemaManager.getSchemaDir(schema), md, metadataId, moreFields, metadataType, root, forceRefreshReaders);
        }
        catch (Exception x) {
            Log.error((String)"geonetwork.datamanager", (Object)("The metadata document index with id=" + metadataId + " is corrupt/invalid - ignoring it. Error: " + x.getMessage()), (Throwable)x);
            fullMd = null;
        }
        finally {
            this.indexingLock.lock();
            try {
                this.indexing.remove(metadataId);
            }
            finally {
                this.indexingLock.unlock();
            }
        }
        if (fullMd != null) {
            this.publisher.publishEvent((ApplicationEvent)new MetadataIndexCompleted(fullMd));
        }
    }

    protected void addExtraFields(AbstractMetadata fullMd, Vector<Element> moreFields) {
        if (!DraftMetadataIndexer.class.isInstance(this)) {
            moreFields.addElement(SearchManager.makeField("_draft", "n", true, true));
        }
    }

    private XmlSerializer getXmlSerializer() {
        return this.xmlSerializer;
    }

    @Override
    public void versionMetadata(ServiceContext context, String id, Element md) throws Exception {
        if (this.svnManager != null) {
            this.svnManager.createMetadataDir(id, context, md);
        }
    }

    @Override
    public void rescheduleOptimizer(Calendar beginAt, int interval) throws Exception {
        this.searchManager.rescheduleOptimizer(beginAt, interval);
    }

    @Override
    public void disableOptimizer() throws Exception {
        this.searchManager.disableOptimizer();
    }

    private ServiceContext getServiceContext() {
        ServiceContext context = ServiceContext.get();
        return context == null ? this.servContext : context;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }
}

