/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.rdbms;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import org.openrdf.sesame.sail.SailInternalException;
import org.openrdf.sesame.sail.query.PathExpression;
import org.openrdf.sesame.sail.query.Var;
import org.openrdf.sesame.sailimpl.rdbms.RDBMS;
import org.openrdf.sesame.sailimpl.rdbms.RdfSource;
import org.openrdf.sesame.sailimpl.rdbms.model.IdValue;

public class RdbmsPathExpression
implements PathExpression {
    protected RdfSource _creator;
    protected RDBMS _rdbms;
    protected Connection _databaseCon;
    protected Statement _statement;
    protected ResultSet _resultSet;
    protected List _varList;
    protected String _sqlQuery;
    protected int[] _previousValues;

    public RdbmsPathExpression(RdfSource creator, RDBMS rdbms, List varList, String sqlQuery) {
        this._creator = creator;
        this._rdbms = rdbms;
        this._varList = varList;
        this._sqlQuery = sqlQuery;
        this._previousValues = new int[this._varList.size()];
    }

    public void initialize(org.openrdf.sesame.sail.RdfSource rdfSource) {
        try {
            this._databaseCon = this._rdbms.getConnection();
            this._statement = this._databaseCon.createStatement();
            this._resultSet = this._statement.executeQuery(this._sqlQuery);
        }
        catch (SQLException e) {
            throw new SailInternalException(e);
        }
    }

    public boolean selectNext(org.openrdf.sesame.sail.RdfSource rdfSource) {
        try {
            boolean moreResults = this._resultSet.next();
            if (moreResults) {
                for (int i = 0; i < this._varList.size(); ++i) {
                    Var var = (Var)this._varList.get(i);
                    int valueId = this._resultSet.getInt(i + 1);
                    if (valueId == this._previousValues[i]) continue;
                    IdValue value = this._creator.getValue(valueId);
                    var.setValue(value);
                    this._previousValues[i] = valueId;
                }
            } else {
                this.clear();
                for (int i = 0; i < this._varList.size(); ++i) {
                    Var var = (Var)this._varList.get(i);
                    var.setValue(null);
                }
            }
            return moreResults;
        }
        catch (SQLException e) {
            throw new SailInternalException(e);
        }
    }

    public void clear() {
        if (this._databaseCon != null) {
            try {
                if (this._resultSet != null) {
                    this._resultSet.close();
                    this._resultSet = null;
                }
                if (this._statement != null) {
                    this._statement.close();
                    this._statement = null;
                }
                this._databaseCon.close();
                this._databaseCon = null;
            }
            catch (SQLException e) {
                throw new SailInternalException(e);
            }
        }
    }

    public void getVariables(Collection variables) {
        variables.addAll(this._varList);
    }

    protected void finalize() {
        try {
            this.clear();
        }
        catch (SailInternalException sailInternalException) {
            // empty catch block
        }
    }
}

