/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.fao.geonet.domain.Constants;
import org.fao.geonet.domain.GeonetEntity;
import org.fao.geonet.entitylistener.MapServerEntityListenerManager;

@Entity
@Table(name="Mapservers")
@Cacheable
@Access(value=AccessType.PROPERTY)
@EntityListeners(value={MapServerEntityListenerManager.class})
@SequenceGenerator(name="mapserver_id_seq", initialValue=100, allocationSize=1)
public class MapServer
extends GeonetEntity {
    static final String ID_SEQ_NAME = "mapserver_id_seq";
    private int _id;
    private String _name;
    private String _description;
    private String _configurl;
    private String _wmsurl;
    private String _wfsurl;
    private String _wcsurl;
    private String _stylerurl;
    private String _username;
    private String _password;
    private String _namespaceprefix;
    private String _namespace;
    private char _pushstyleinworkspace = (char)110;

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="mapserver_id_seq")
    @Column(nullable=false)
    public int getId() {
        return this._id;
    }

    public MapServer setId(int id) {
        this._id = id;
        return this;
    }

    @Column(nullable=false, length=32)
    public String getName() {
        return this._name;
    }

    public MapServer setName(String name) {
        this._name = name;
        return this;
    }

    @Column(length=255)
    public String getDescription() {
        return this._description;
    }

    public MapServer setDescription(String description) {
        this._description = description;
        return this;
    }

    @Column(nullable=false, length=255)
    public String getConfigurl() {
        return this._configurl;
    }

    public MapServer setConfigurl(String configurl) {
        this._configurl = configurl;
        return this;
    }

    @Column(length=255)
    public String getWmsurl() {
        return this._wmsurl;
    }

    public MapServer setWmsurl(String _wmsurl) {
        this._wmsurl = _wmsurl;
        return this;
    }

    @Column(length=255)
    public String getWfsurl() {
        return this._wfsurl;
    }

    public MapServer setWfsurl(String _wfsurl) {
        this._wfsurl = _wfsurl;
        return this;
    }

    @Column(length=255)
    public String getWcsurl() {
        return this._wcsurl;
    }

    public MapServer setWcsurl(String _wcsurl) {
        this._wcsurl = _wcsurl;
        return this;
    }

    @Column(length=255)
    public String getStylerurl() {
        return this._stylerurl;
    }

    public MapServer setStylerurl(String _stylerurl) {
        this._stylerurl = _stylerurl;
        return this;
    }

    @Column(length=128)
    public String getUsername() {
        return this._username;
    }

    public MapServer setUsername(String _username) {
        this._username = _username;
        return this;
    }

    @Column(length=128)
    public String getPassword() {
        return this._password;
    }

    public MapServer setPassword(String _password) {
        this._password = _password;
        return this;
    }

    public String getNamespacePrefix() {
        return this._namespaceprefix;
    }

    public MapServer setNamespacePrefix(String _namespaceprefix) {
        this._namespaceprefix = _namespaceprefix;
        return this;
    }

    public String getNamespace() {
        return this._namespace;
    }

    public MapServer setNamespace(String _namespace) {
        this._namespace = _namespace;
        return this;
    }

    @Column(name="pushstyleinworkspace", length=1)
    protected char getPushStyleInWorkspace_JpaWorkaround() {
        return this._pushstyleinworkspace;
    }

    protected void setPushStyleInWorkspace_JpaWorkaround(char _pushStyleInWorkspace) {
        this._pushstyleinworkspace = _pushStyleInWorkspace;
    }

    @Transient
    public boolean pushStyleInWorkspace() {
        return Constants.toBoolean_fromYNChar(this.getPushStyleInWorkspace_JpaWorkaround());
    }

    public MapServer setPushStyleInWorkspace(boolean _pushStyleInWorkspace) {
        this.setPushStyleInWorkspace_JpaWorkaround(Constants.toYN_EnabledChar(_pushStyleInWorkspace));
        return this;
    }

    public String toString() {
        return "MapServer [_id=" + this._id + ", _name=" + this._name + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this._id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MapServer other = (MapServer)obj;
        return this._id == other._id;
    }
}

