/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.provider.iface;

import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import org.jzkit.search.provider.iface.Diagnostic;
import org.jzkit.search.provider.iface.DiagnosticEvent;
import org.jzkit.search.provider.iface.DiagnosticHandler;
import org.jzkit.search.provider.iface.IREvent;

public class DiagnosticObserver
implements Observer {
    protected DiagnosticHandler diagnostic_handler = null;
    protected Properties diagnostic_props = new Properties();

    public DiagnosticObserver(DiagnosticHandler diagnostic_handler) {
        this.diagnostic_handler = diagnostic_handler;
        try {
            this.diagnostic_props.load(this.getClass().getResourceAsStream("/com/k_int/IR/diagnostics.properties"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void update(Observable o, Object arg) {
        if (((IREvent)arg).event_type != 1003) {
            return;
        }
        DiagnosticEvent e = (DiagnosticEvent)arg;
        Diagnostic the_diagnostic = (Diagnostic)e.event_info;
        if (the_diagnostic.status_code.toUpperCase().startsWith("DIAG.BIB1")) {
            this.bib1Diagnostic(the_diagnostic);
        } else if (the_diagnostic.status_code.toUpperCase().startsWith("DIAG.K-INT")) {
            this.kIntDiagnostic(the_diagnostic);
        } else {
            this.additionalDiagnostics(the_diagnostic);
        }
    }

    protected void bib1Diagnostic(Diagnostic the_diagnostic) {
        the_diagnostic.message = (String)this.diagnostic_props.get(the_diagnostic.status_code);
        int int_status_code = the_diagnostic.getIntegerDiagnosticCode();
        switch (int_status_code) {
            case 101: {
                this.diagnostic_handler.onAccessControlFailure(the_diagnostic);
                break;
            }
            case 236: {
                this.diagnostic_handler.onAccessToSpecifiedDatabaseDenied(the_diagnostic);
                break;
            }
            case 243: {
                this.diagnostic_handler.onAdditionalRangesParamUnsupported(the_diagnostic);
                break;
            }
            case 247: {
                this.diagnostic_handler.onAttrSetinAttrElementUnsupported(the_diagnostic);
                break;
            }
            case 246: {
                this.diagnostic_handler.onAttrValueComplexUnsupported(the_diagnostic);
                break;
            }
            case 21: {
                this.diagnostic_handler.onCantOverwriteExistingResSetName(the_diagnostic);
                break;
            }
            case 207: {
                this.diagnostic_handler.onCantSortAccordingToSequence(the_diagnostic);
                break;
            }
            case 104: {
                this.diagnostic_handler.onChallengeFailedRecNotSent(the_diagnostic);
                break;
            }
            case 102: {
                this.diagnostic_handler.onChallengeRequiredOperationTerminated(the_diagnostic);
                break;
            }
            case 103: {
                this.diagnostic_handler.onChallengeRequiredRecNotSent(the_diagnostic);
                break;
            }
            case 244: {
                this.diagnostic_handler.onCompSpecParamUnsupported(the_diagnostic);
                break;
            }
            case 23: {
                this.diagnostic_handler.onDatabaseCombinationUnsupported(the_diagnostic);
                break;
            }
            case 235: {
                this.diagnostic_handler.onDatabaseDoesntExist(the_diagnostic);
                break;
            }
            case 210: {
                this.diagnostic_handler.onDatabaseSpecifcSortUnsupported(the_diagnostic);
                break;
            }
            case 209: {
                this.diagnostic_handler.onDatabaseSpecificSortOnly(the_diagnostic);
                break;
            }
            case 109: {
                this.diagnostic_handler.onDatabaseUnavailable(the_diagnostic);
                break;
            }
            case 212: {
                this.diagnostic_handler.onDuplicateSortKeys(the_diagnostic);
                break;
            }
            case 24: {
                this.diagnostic_handler.onElementSetNamesNotSupported(the_diagnostic);
                break;
            }
            case 100: {
                this.diagnostic_handler.onError(the_diagnostic);
                break;
            }
            case 224: {
                this.diagnostic_handler.onESImmediateExecutionFailed(the_diagnostic);
                break;
            }
            case 226: {
                this.diagnostic_handler.onESImmediateExecutionNotSupportedForParams(the_diagnostic);
                break;
            }
            case 225: {
                this.diagnostic_handler.onESImmediateExecutionNotSupportedForService(the_diagnostic);
                break;
            }
            case 219: {
                this.diagnostic_handler.onESNoSuchPackageForModifyOrDelete(the_diagnostic);
                break;
            }
            case 218: {
                this.diagnostic_handler.onESPackageNameAlreadyInUse(the_diagnostic);
                break;
            }
            case 223: {
                this.diagnostic_handler.onESPermissionDeniedCantModifyOrDelete(the_diagnostic);
                break;
            }
            case 222: {
                this.diagnostic_handler.onESPermissionDeniedUnauthorizedId(the_diagnostic);
                break;
            }
            case 220: {
                this.diagnostic_handler.onESQuotaExceeded(the_diagnostic);
                break;
            }
            case 221: {
                this.diagnostic_handler.onESTypeUnsupported(the_diagnostic);
                break;
            }
            case 25: {
                this.diagnostic_handler.onESNNotValidForSpecifiedDatabase(the_diagnostic);
                break;
            }
            case 215: {
                this.diagnostic_handler.onIllegalCaseValue(the_diagnostic);
                break;
            }
            case 216: {
                this.diagnostic_handler.onIllegalMissingDataAction(the_diagnostic);
                break;
            }
            case 130: {
                this.diagnostic_handler.onIllegalResSetInProximitySearch(the_diagnostic);
                break;
            }
            case 128: {
                this.diagnostic_handler.onIllegalResSetName(the_diagnostic);
                break;
            }
            case 237: {
                this.diagnostic_handler.onIllegalSort(the_diagnostic);
                break;
            }
            case 214: {
                this.diagnostic_handler.onIllegalSortRelation(the_diagnostic);
                break;
            }
            case 126: {
                this.diagnostic_handler.onIllegalTermValforAttr(the_diagnostic);
                break;
            }
            case 231: {
                this.diagnostic_handler.onIncompatibleRecFormatsForSort(the_diagnostic);
                break;
            }
            case 10: {
                this.diagnostic_handler.onInvalidRecordNumberFormat(the_diagnostic);
                break;
            }
            case 108: {
                this.diagnostic_handler.onMalformedQuery(the_diagnostic);
                break;
            }
            case 228: {
                this.diagnostic_handler.onMalformedScan(the_diagnostic);
                break;
            }
            case 125: {
                this.diagnostic_handler.onMalformedSearchTerm(the_diagnostic);
                break;
            }
            case 242: {
                this.diagnostic_handler.onMaxSegmentSizeTooSmall(the_diagnostic);
                break;
            }
            case 106: {
                this.diagnostic_handler.onNoAgreedSyntaxForRec(the_diagnostic);
                break;
            }
            case 227: {
                this.diagnostic_handler.onNoDataAvailableInRequestedSyntax(the_diagnostic);
                break;
            }
            case 208: {
                this.diagnostic_handler.onNoResSetNameSuppliedOnSort(the_diagnostic);
                break;
            }
            case 29: {
                this.diagnostic_handler.onOneOfSpecifiedDatabasesIsLocked(the_diagnostic);
                break;
            }
            case 26: {
                this.diagnostic_handler.onOnlyGenericESNSupported(the_diagnostic);
                break;
            }
            case 110: {
                this.diagnostic_handler.onOperatorUnsupported(the_diagnostic);
                break;
            }
            case 1: {
                this.diagnostic_handler.onPermanentSystemError(the_diagnostic);
                break;
            }
            case 13: {
                this.diagnostic_handler.onPresentRequestOutOfRange(the_diagnostic);
                break;
            }
            case 201: {
                this.diagnostic_handler.onProximityUnsupportedWithSuppliedAttrs(the_diagnostic);
                break;
            }
            case 129: {
                this.diagnostic_handler.onProximitySetSearchUnsupported(the_diagnostic);
                break;
            }
            case 203: {
                this.diagnostic_handler.onProximityOrderedFlagNotSupported(the_diagnostic);
                break;
            }
            case 107: {
                this.diagnostic_handler.onQueryTypeNotSupported(the_diagnostic);
                break;
            }
            case 17: {
                this.diagnostic_handler.onRecExceedsExceptionalSize(the_diagnostic);
                break;
            }
            case 16: {
                this.diagnostic_handler.onRecExceedsPreferredMessageSize(the_diagnostic);
                break;
            }
            case 238: {
                this.diagnostic_handler.onRecNotAvailableInRequestedSyntax(the_diagnostic);
                break;
            }
            case 239: {
                this.diagnostic_handler.onRecSyntaxNotSupported(the_diagnostic);
                break;
            }
            case 15: {
                this.diagnostic_handler.onRecUnauthorisedInterSystem(the_diagnostic);
                break;
            }
            case 217: {
                this.diagnostic_handler.onRecsMightNotFitSpecifiedSegments(the_diagnostic);
                break;
            }
            case 18: {
                this.diagnostic_handler.onResSetUnsupportedAsSearchTerm(the_diagnostic);
                break;
            }
            case 32: {
                this.diagnostic_handler.onResourcesExhaustedUnpredictableResults(the_diagnostic);
                break;
            }
            case 31: {
                this.diagnostic_handler.onResourcesExhaustedNoResults(the_diagnostic);
                break;
            }
            case 33: {
                this.diagnostic_handler.onResourcesExhaustedValidSubsetAvailable(the_diagnostic);
                break;
            }
            case 245: {
                this.diagnostic_handler.onRestrictionResultAttrOperandUnsupported(the_diagnostic);
                break;
            }
            case 27: {
                this.diagnostic_handler.onResultSetAlreadyDeletedByTarget(the_diagnostic);
                break;
            }
            case 28: {
                this.diagnostic_handler.onResultSetInUse(the_diagnostic);
                break;
            }
            case 22: {
                this.diagnostic_handler.onResultSetNamingNotSupported(the_diagnostic);
                break;
            }
            case 240: {
                this.diagnostic_handler.onScanResourcesExhaustedNoSatisfyingTerms(the_diagnostic);
                break;
            }
            case 20: {
                this.diagnostic_handler.onSingleResSetAsSearchTermUseAndOnly(the_diagnostic);
                break;
            }
            case 19: {
                this.diagnostic_handler.onSingleResSetAsSearchTermOnly(the_diagnostic);
                break;
            }
            case 30: {
                this.diagnostic_handler.onSpecifiedResultSetDoesNotExist(the_diagnostic);
                break;
            }
            case 206: {
                this.diagnostic_handler.onScanSpecifedStepSizeNotSupported(the_diagnostic);
                break;
            }
            case 241: {
                this.diagnostic_handler.onStartOrEndOFTermListForScan(the_diagnostic);
                break;
            }
            case 14: {
                this.diagnostic_handler.onSysErrorPresentingRecords(the_diagnostic);
                break;
            }
            case 205: {
                this.diagnostic_handler.onScanZeroStepSizeOnly(the_diagnostic);
                break;
            }
            case 2: {
                this.diagnostic_handler.onTemporarySystemError(the_diagnostic);
                break;
            }
            case 232: {
                this.diagnostic_handler.onTermListUnsupportedForScan(the_diagnostic);
                break;
            }
            case 229: {
                this.diagnostic_handler.onTermTypeNotSupported(the_diagnostic);
                break;
            }
            case 105: {
                this.diagnostic_handler.onTerminatedAtOriginRequest(the_diagnostic);
                break;
            }
            case 4: {
                this.diagnostic_handler.onTermsOnlyStopWords(the_diagnostic);
                break;
            }
            case 5: {
                this.diagnostic_handler.onTooManyArgumentWords(the_diagnostic);
                break;
            }
            case 6: {
                this.diagnostic_handler.onTooManyBooleanOperators(the_diagnostic);
                break;
            }
            case 11: {
                this.diagnostic_handler.onTooManyCharsInSearchStmt(the_diagnostic);
                break;
            }
            case 111: {
                this.diagnostic_handler.onTooManyDatabasesSpecified(the_diagnostic);
                break;
            }
            case 234: {
                this.diagnostic_handler.onTooManyIndexTermsProcessed(the_diagnostic);
                break;
            }
            case 230: {
                this.diagnostic_handler.onTooManyInputResultsForSort(the_diagnostic);
                break;
            }
            case 12: {
                this.diagnostic_handler.onTooManyRecordsRetrieved(the_diagnostic);
                break;
            }
            case 112: {
                this.diagnostic_handler.onTooManyResultSetsCreated(the_diagnostic);
                break;
            }
            case 211: {
                this.diagnostic_handler.onTooManySortKeys(the_diagnostic);
                break;
            }
            case 8: {
                this.diagnostic_handler.onTooManyIncompleteSubfields(the_diagnostic);
                break;
            }
            case 7: {
                this.diagnostic_handler.onTooManyTruncatedWords(the_diagnostic);
                break;
            }
            case 9: {
                this.diagnostic_handler.onTruncatedWordsTooShort(the_diagnostic);
                break;
            }
            case 127: {
                this.diagnostic_handler.onUnparsableFormatForUnNormalizedVal(the_diagnostic);
                break;
            }
            case 123: {
                this.diagnostic_handler.onUnsupportedAttrCombination(the_diagnostic);
                break;
            }
            case 121: {
                this.diagnostic_handler.onUnsupportedAttrSet(the_diagnostic);
                break;
            }
            case 113: {
                this.diagnostic_handler.onUnsupportedAttributeType(the_diagnostic);
                break;
            }
            case 124: {
                this.diagnostic_handler.onUnsupportedCodedValForTerm(the_diagnostic);
                break;
            }
            case 122: {
                this.diagnostic_handler.onUnsupportedCompletenessAttr(the_diagnostic);
                break;
            }
            case 213: {
                this.diagnostic_handler.onUnsupportedMissingDataAction(the_diagnostic);
                break;
            }
            case 119: {
                this.diagnostic_handler.onUnsupportedPositionAttr(the_diagnostic);
                break;
            }
            case 202: {
                this.diagnostic_handler.onUnsupportedProximityDistance(the_diagnostic);
                break;
            }
            case 131: {
                this.diagnostic_handler.onUnsupportedProximityRelation(the_diagnostic);
                break;
            }
            case 132: {
                this.diagnostic_handler.onUnsupportedProximityUnitCode(the_diagnostic);
                break;
            }
            case 117: {
                this.diagnostic_handler.onUnsupportedRelationAttr(the_diagnostic);
                break;
            }
            case 3: {
                this.diagnostic_handler.onUnsupportedSearch(the_diagnostic);
                break;
            }
            case 118: {
                this.diagnostic_handler.onUnsupportedStructureAttr(the_diagnostic);
                break;
            }
            case 115: {
                this.diagnostic_handler.onUnsupportedTermValForUseAttr(the_diagnostic);
                break;
            }
            case 120: {
                this.diagnostic_handler.onUnsupportedTruncationAttr(the_diagnostic);
                break;
            }
            case 114: {
                this.diagnostic_handler.onUnsupportedUseAttribute(the_diagnostic);
                break;
            }
            case 233: {
                this.diagnostic_handler.onUnsupportedValofPositionInResponseForScan(the_diagnostic);
                break;
            }
            case 116: {
                this.diagnostic_handler.onUseAttrRequiredButNotSupplied(the_diagnostic);
                break;
            }
        }
    }

    protected void kIntDiagnostic(Diagnostic the_diagnostic) {
        the_diagnostic.message = (String)this.diagnostic_props.get(the_diagnostic.status_code);
        int int_status_code = the_diagnostic.getIntegerDiagnosticCode();
        switch (int_status_code) {
            case 4: {
                this.diagnostic_handler.onKintConnectionFailed(the_diagnostic);
                break;
            }
            case 2: {
                this.diagnostic_handler.onKintInvalidQuery(the_diagnostic);
                break;
            }
            case 1: {
                this.diagnostic_handler.onKintIOExceptionSendingMessage(the_diagnostic);
                break;
            }
            case 5: {
                this.diagnostic_handler.onKintProblemParsingSortSpecification(the_diagnostic);
                break;
            }
            case 3: {
                this.diagnostic_handler.onKintSearchException(the_diagnostic);
                break;
            }
            case 6: {
                this.diagnostic_handler.onKintSortFailure(the_diagnostic);
                break;
            }
            case 7: {
                this.diagnostic_handler.onKintExternalCIDResponse(the_diagnostic);
                break;
            }
        }
    }

    protected void additionalDiagnostics(Diagnostic the_diagnostic) {
    }
}

