/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.ByteCollection;
import bak.pcj.adapter.CollectionToByteCollectionAdapter;
import bak.pcj.adapter.SetToIntSetAdapter;
import bak.pcj.map.AbstractIntKeyByteMap;
import bak.pcj.map.IntKeyByteMap;
import bak.pcj.map.IntKeyByteMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.IntSet;
import bak.pcj.util.Exceptions;
import java.util.Iterator;
import java.util.Map;

public class MapToIntKeyByteMapAdapter
extends AbstractIntKeyByteMap
implements IntKeyByteMap {
    protected Map map;
    protected Byte lastValue;

    public MapToIntKeyByteMapAdapter(Map map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
    }

    public MapToIntKeyByteMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(int key) {
        this.lastValue = (Byte)this.map.get(new Integer(key));
        return this.lastValue != null;
    }

    public boolean containsValue(byte value) {
        return this.map.containsValue(new Byte(value));
    }

    public IntKeyByteMapIterator entries() {
        return new IntKeyByteMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToIntKeyByteMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public int getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Integer)this.lastEntry.getKey();
            }

            public byte getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Byte)this.lastEntry.getValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public byte get(int key) {
        Byte value = (Byte)this.map.get(new Integer(key));
        return value == null ? MapDefaults.defaultByte() : value;
    }

    public IntSet keySet() {
        return new SetToIntSetAdapter(this.map.keySet());
    }

    public byte lget() {
        if (this.lastValue == null) {
            Exceptions.noLastElement();
        }
        return this.lastValue;
    }

    public byte put(int key, byte value) {
        Byte oldValue = this.map.put(new Integer(key), new Byte(value));
        return oldValue == null ? MapDefaults.defaultByte() : oldValue;
    }

    public byte remove(int key) {
        Byte value = (Byte)this.map.remove(new Integer(key));
        return value == null ? MapDefaults.defaultByte() : value;
    }

    public int size() {
        return this.map.size();
    }

    public ByteCollection values() {
        return new CollectionToByteCollectionAdapter(this.map.values());
    }

    public byte tget(int key) {
        Byte value = (Byte)this.map.get(new Integer(key));
        if (value == null) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public boolean validate() {
        return Adapter.isIntKeyByteAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

