/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.utils;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version
implements Comparable<Version> {
    private static final Pattern PATTERN = Pattern.compile("^(\\d*)?[\\.|-]?(\\d*)?[\\.|-]?(\\d*)?[\\.|-]?(\\d*)?[\\.|-]?(\\S*)?$");
    private final Integer major;
    private final Integer minor;
    private final Integer patch;
    private final Integer build;
    private final String qualifier;

    public Version() {
        this("0", "0", "0");
    }

    public Version(String major, String minor, String patch) {
        this(major, minor, patch, null, null);
    }

    public Version(String major, String minor, String patch, String build, String qualifier) {
        this.major = major != null && !major.isEmpty() ? Integer.valueOf(major) : null;
        this.minor = minor != null && !minor.isEmpty() ? Integer.valueOf(minor) : null;
        this.patch = patch != null && !patch.isEmpty() ? Integer.valueOf(patch) : null;
        this.build = build != null && !build.isEmpty() ? Integer.valueOf(build) : null;
        this.qualifier = qualifier != null && !qualifier.isEmpty() ? qualifier : null;
    }

    public static Version parseVersionNumber(String number) {
        Matcher parsed = PATTERN.matcher(number);
        if (parsed.find()) {
            String major = parsed.group(1);
            String minor = parsed.group(2);
            String patch = parsed.group(3);
            String build = parsed.group(4);
            String qualifier = parsed.group(5);
            return new Version(major, minor, patch, build, qualifier);
        }
        return new Version(null, null, null, null, number);
    }

    private static final int order(Integer number, String qualifier) {
        return number != null ? number : Version.order(qualifier);
    }

    private static final int order(String qualifier) {
        if (qualifier == null) {
            return 0;
        }
        if ("SNAPSHOT".equalsIgnoreCase(qualifier)) {
            return Integer.MAX_VALUE;
        }
        if ("RC".equalsIgnoreCase(qualifier)) {
            return -1;
        }
        if ("0".equalsIgnoreCase(qualifier)) {
            return 0;
        }
        if ("final".equalsIgnoreCase(qualifier)) {
            return 0;
        }
        return -2;
    }

    @Override
    public int compareTo(Version o) {
        int majorCompare = Integer.compare(Version.order(this.major, this.qualifier), Version.order(o.major, o.qualifier));
        int minorCompare = Integer.compare(Version.order(this.minor, this.qualifier), Version.order(o.minor, o.qualifier));
        int patchCompare = Integer.compare(Version.order(this.patch, this.qualifier), Version.order(o.patch, o.qualifier));
        int buildCompare = Integer.compare(Version.order(this.build, this.qualifier), Version.order(o.build, o.qualifier));
        int qualifierCompare = Integer.compare(Version.order(this.qualifier), Version.order(o.qualifier));
        if (this.major == null && o.major == null) {
            return qualifierCompare;
        }
        if (majorCompare != 0) {
            return majorCompare;
        }
        if (this.minor == null && o.minor == null) {
            return qualifierCompare;
        }
        if (minorCompare != 0) {
            return minorCompare;
        }
        if (this.patch == null && o.patch == null) {
            return qualifierCompare;
        }
        if (patchCompare != 0) {
            return patchCompare;
        }
        if (this.build == null && o.build == null) {
            return qualifierCompare;
        }
        if (buildCompare != 0) {
            return buildCompare;
        }
        return qualifierCompare;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.compareTo(version) == 0;
    }

    public int hashCode() {
        int placeholder = "SNAPSHOT".equals(this.qualifier) ? Integer.MAX_VALUE : 0;
        return Objects.hash(Version.order(this.major, this.qualifier), Version.order(this.minor, this.qualifier), Version.order(this.patch, this.qualifier), Version.order(this.build, this.qualifier), Version.order(this.qualifier));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.major != null) {
            sb.append(this.major);
        }
        if (this.minor != null) {
            sb.append(".").append(this.minor);
        }
        if (this.patch != null) {
            sb.append(".").append(this.patch);
        }
        if (this.build != null) {
            sb.append(".").append(this.build);
        }
        if (this.qualifier != null) {
            if (sb.length() != 0) {
                sb.append("-");
            }
            sb.append(this.qualifier);
        }
        return sb.toString();
    }
}

