/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.v1_1_0;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import net.opengis.ows10.DCPType;
import net.opengis.ows10.DomainType;
import net.opengis.ows10.KeywordsType;
import net.opengis.ows10.OnlineResourceType;
import net.opengis.ows10.OperationType;
import net.opengis.ows10.OperationsMetadataType;
import net.opengis.ows10.Ows10Factory;
import net.opengis.ows10.RequestMethodType;
import net.opengis.ows10.ServiceIdentificationType;
import net.opengis.ows10.ServiceProviderType;
import net.opengis.ows10.WGS84BoundingBoxType;
import net.opengis.wfs.DescribeFeatureTypeType;
import net.opengis.wfs.FeatureTypeType;
import net.opengis.wfs.GetCapabilitiesType;
import net.opengis.wfs.GetFeatureType;
import net.opengis.wfs.GetGmlObjectType;
import net.opengis.wfs.LockFeatureType;
import net.opengis.wfs.OutputFormatListType;
import net.opengis.wfs.ResultTypeType;
import net.opengis.wfs.TransactionType;
import net.opengis.wfs.WFSCapabilitiesType;
import org.apache.commons.io.IOUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.geotools.data.DataSourceException;
import org.geotools.data.ows.HTTPClient;
import org.geotools.data.ows.HTTPResponse;
import org.geotools.data.wfs.protocol.http.HttpMethod;
import org.geotools.data.wfs.protocol.http.HttpUtil;
import org.geotools.data.wfs.protocol.wfs.GetFeature;
import org.geotools.data.wfs.protocol.wfs.Version;
import org.geotools.data.wfs.protocol.wfs.WFSOperationType;
import org.geotools.data.wfs.protocol.wfs.WFSProtocol;
import org.geotools.data.wfs.protocol.wfs.WFSResponse;
import org.geotools.data.wfs.v1_1_0.DefaultWFSStrategy;
import org.geotools.data.wfs.v1_1_0.GetFeatureQueryAdapter;
import org.geotools.data.wfs.v1_1_0.WFSStrategy;
import org.geotools.data.wfs.v1_1_0.parsers.EmfAppSchemaParser;
import org.geotools.filter.Capabilities;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.logging.Logging;
import org.geotools.wfs.WFS;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;
import org.geotools.xml.Parser;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.capability.FilterCapabilities;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xml.sax.SAXException;

public class WFS_1_1_0_Protocol
implements WFSProtocol {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.wfs");
    private WFSStrategy strategy;
    final WFSCapabilitiesType capabilities;
    private final Map<String, FeatureTypeType> typeInfos;
    protected HTTPClient http;
    protected final Charset defaultEncoding;

    public WFS_1_1_0_Protocol(InputStream capabilitiesReader, HTTPClient http, Charset defaultEncoding, WFSStrategy strategy) throws IOException {
        this.defaultEncoding = defaultEncoding;
        this.strategy = strategy;
        if (this.strategy == null) {
            this.strategy = new DefaultWFSStrategy();
        }
        this.capabilities = this.parseCapabilities(capabilitiesReader);
        this.http = http;
        this.typeInfos = new HashMap<String, FeatureTypeType>();
        EList ftypes = this.capabilities.getFeatureTypeList().getFeatureType();
        for (FeatureTypeType ftype : ftypes) {
            QName typeName = ftype.getName();
            String prefixedTypeName = this.strategy.getPrefixedTypeName(typeName);
            this.typeInfos.put(prefixedTypeName, ftype);
        }
    }

    public void setStrategy(WFSStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public Version getServiceVersion() {
        return Version.v1_1_0;
    }

    @Override
    public String getServiceTitle() {
        return this.getServiceIdentification().getTitle();
    }

    @Override
    public String getServiceAbstract() {
        return this.getServiceIdentification().getAbstract();
    }

    @Override
    public Set<String> getServiceKeywords() {
        EList capsKeywords = this.getServiceIdentification().getKeywords();
        return this.extractKeywords((List<KeywordsType>)capsKeywords);
    }

    private ServiceIdentificationType getServiceIdentification() {
        ServiceIdentificationType serviceId = this.capabilities.getServiceIdentification();
        if (serviceId == null) {
            LOGGER.info("Capabilities did not provide a ServiceIdentification section");
            serviceId = Ows10Factory.eINSTANCE.createServiceIdentificationType();
            this.capabilities.setServiceIdentification(serviceId);
        }
        return serviceId;
    }

    @Override
    public URI getServiceProviderUri() {
        ServiceProviderType serviceProvider = this.capabilities.getServiceProvider();
        if (serviceProvider == null) {
            return null;
        }
        OnlineResourceType providerSite = serviceProvider.getProviderSite();
        if (providerSite == null) {
            return null;
        }
        String href = providerSite.getHref();
        if (href == null) {
            return null;
        }
        try {
            return new URI(href);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @Override
    public Set<String> getSupportedGetFeatureOutputFormats() {
        OperationType operationMetadata = this.getOperationMetadata(WFSOperationType.GET_FEATURE);
        EList parameters = operationMetadata.getParameter();
        EList featuretypes = this.capabilities.getFeatureTypeList().getFeatureType();
        EList supportedByAllFeatureTypes = null;
        for (int i = 0; i < featuretypes.size(); ++i) {
            FeatureTypeType ft = (FeatureTypeType)featuretypes.get(i);
            if (ft.getOutputFormats() == null) continue;
            EList value = ft.getOutputFormats().getFormat();
            if (supportedByAllFeatureTypes == null) {
                supportedByAllFeatureTypes = value;
                continue;
            }
            ArrayList removeOutputFormats = new ArrayList();
            for (Object o : supportedByAllFeatureTypes) {
                if (value.contains(o)) continue;
                removeOutputFormats.add(o);
            }
            for (Object o : removeOutputFormats) {
                supportedByAllFeatureTypes.remove(o);
            }
            if (supportedByAllFeatureTypes.size() == 0) break;
        }
        HashSet<String> outputFormats = new HashSet<String>();
        for (DomainType param : parameters) {
            String paramName = param.getName();
            if (!"outputFormat".equals(paramName)) continue;
            EList value = param.getValue();
            outputFormats.addAll((Collection<String>)value);
        }
        if (supportedByAllFeatureTypes != null) {
            outputFormats.addAll((Collection<String>)supportedByAllFeatureTypes);
        }
        return outputFormats;
    }

    @Override
    public Set<String> getSupportedOutputFormats(String typeName) {
        Set<String> serviceOutputFormats = this.getSupportedGetFeatureOutputFormats();
        FeatureTypeType typeInfo = this.getFeatureTypeInfo(typeName);
        OutputFormatListType outputFormats = typeInfo.getOutputFormats();
        HashSet<String> ftypeFormats = new HashSet<String>();
        if (outputFormats != null) {
            EList ftypeDeclaredFormats = outputFormats.getFormat();
            ftypeFormats.addAll((Collection<String>)ftypeDeclaredFormats);
        }
        ftypeFormats.addAll(serviceOutputFormats);
        return ftypeFormats;
    }

    @Override
    public Set<QName> getFeatureTypeNames() {
        HashSet<QName> typeNames = new HashSet<QName>();
        for (FeatureTypeType typeInfo : this.typeInfos.values()) {
            QName name = typeInfo.getName();
            typeNames.add(name);
        }
        return typeNames;
    }

    @Override
    public QName getFeatureTypeName(String typeName) {
        FeatureTypeType featureTypeInfo = this.getFeatureTypeInfo(typeName);
        QName name = featureTypeInfo.getName();
        return name;
    }

    @Override
    public FilterCapabilities getFilterCapabilities() {
        FilterCapabilities wfsFilterCapabilities = this.capabilities.getFilterCapabilities();
        return wfsFilterCapabilities;
    }

    @Override
    public boolean supportsOperation(WFSOperationType operation, boolean post) {
        if (post && !this.strategy.supportsPost()) {
            return false;
        }
        if (!post && !this.strategy.supportsGet()) {
            return false;
        }
        HttpMethod method = post ? HttpMethod.POST : HttpMethod.GET;
        return null != this.getOperationURI(operation, method);
    }

    @Override
    public URL getOperationURL(WFSOperationType operation, boolean post) {
        HttpMethod method = post ? HttpMethod.POST : HttpMethod.GET;
        String href = this.getOperationURI(operation, method);
        if (href != null) {
            try {
                return new URL(href);
            }
            catch (MalformedURLException e) {
                LOGGER.log(Level.INFO, "Malformed " + (Object)((Object)method) + " URL for " + (Object)((Object)operation), e);
            }
        }
        return null;
    }

    @Override
    public String getFeatureTypeTitle(String typeName) {
        FeatureTypeType featureTypeInfo = this.getFeatureTypeInfo(typeName);
        return featureTypeInfo.getTitle();
    }

    @Override
    public String getFeatureTypeAbstract(String typeName) {
        FeatureTypeType featureTypeInfo = this.getFeatureTypeInfo(typeName);
        return featureTypeInfo.getAbstract();
    }

    @Override
    public ReferencedEnvelope getFeatureTypeWGS84Bounds(String typeName) {
        FeatureTypeType featureTypeInfo = this.getFeatureTypeInfo(typeName);
        EList bboxList = featureTypeInfo.getWGS84BoundingBox();
        if (bboxList != null && bboxList.size() > 0) {
            WGS84BoundingBoxType bboxType = (WGS84BoundingBoxType)bboxList.get(0);
            List lowerCorner = bboxType.getLowerCorner();
            List upperCorner = bboxType.getUpperCorner();
            double minLon = (Double)lowerCorner.get(0);
            double minLat = (Double)lowerCorner.get(1);
            double maxLon = (Double)upperCorner.get(0);
            double maxLat = (Double)upperCorner.get(1);
            ReferencedEnvelope latLonBounds = new ReferencedEnvelope(minLon, maxLon, minLat, maxLat, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            return latLonBounds;
        }
        throw new IllegalStateException("The capabilities document does not supply the ows:WGS84BoundingBox element");
    }

    @Override
    public String getDefaultCRS(String typeName) {
        FeatureTypeType featureTypeInfo = this.getFeatureTypeInfo(typeName);
        String defaultSRS = featureTypeInfo.getDefaultSRS();
        return defaultSRS;
    }

    @Override
    public Set<String> getSupportedCRSIdentifiers(String typeName) {
        FeatureTypeType featureTypeInfo = this.getFeatureTypeInfo(typeName);
        String defaultSRS = featureTypeInfo.getDefaultSRS();
        EList otherSRS = featureTypeInfo.getOtherSRS();
        HashSet<String> ftypeCrss = new HashSet<String>();
        ftypeCrss.add(defaultSRS);
        ftypeCrss.addAll((Collection<String>)otherSRS);
        return ftypeCrss;
    }

    @Override
    public Set<String> getFeatureTypeKeywords(String typeName) {
        FeatureTypeType featureTypeInfo = this.getFeatureTypeInfo(typeName);
        EList ftKeywords = featureTypeInfo.getKeywords();
        Set<String> ftypeKeywords = this.extractKeywords((List<KeywordsType>)ftKeywords);
        return ftypeKeywords;
    }

    @Override
    public URL getDescribeFeatureTypeURLGet(String typeName) {
        String outputFormat = "text/xml; subtype=gml/3.1.1";
        return this.getDescribeFeatureTypeURLGet(typeName, "text/xml; subtype=gml/3.1.1");
    }

    @Override
    public WFSResponse describeFeatureTypeGET(String typeName, String outputFormat) throws IOException {
        if (!this.supportsOperation(WFSOperationType.DESCRIBE_FEATURETYPE, false)) {
            throw new UnsupportedOperationException("The server does not support DescribeFeatureType for HTTP method GET");
        }
        URL url = this.getDescribeFeatureTypeURLGet(typeName, outputFormat);
        WFSResponse response = this.issueGetRequest(null, url, Collections.EMPTY_MAP);
        return response;
    }

    @Override
    public WFSResponse describeFeatureTypePOST(String typeName, String outputFormat) throws IOException {
        throw new UnsupportedOperationException("POST not implemented yet for DescribeFeatureType");
    }

    @Override
    public WFSResponse issueGetFeatureGET(GetFeature request) throws IOException {
        GetFeatureQueryAdapter adapter;
        if (!this.supportsOperation(WFSOperationType.GET_FEATURE, false)) {
            throw new UnsupportedOperationException("The server does not support GetFeature for HTTP method GET");
        }
        URL url = this.getOperationURL(WFSOperationType.GET_FEATURE, false);
        WFSStrategy.RequestComponents reqParts = this.strategy.createGetFeatureRequest(this, request);
        GetFeatureType requestType = reqParts.getServerRequest();
        Map<String, String> getFeatureKvp = reqParts.getKvpParameters();
        if (request instanceof GetFeatureQueryAdapter && (adapter = (GetFeatureQueryAdapter)request).getVendorParameter() != null) {
            getFeatureKvp.putAll(adapter.getVendorParameter());
        }
        if (request.getResultType() == GetFeature.ResultType.HITS) {
            getFeatureKvp.put("RESULTTYPE", ResultTypeType.HITS_LITERAL.getLiteral());
        }
        WFSResponse response = this.issueGetRequest((EObject)requestType, url, getFeatureKvp);
        return response;
    }

    @Override
    public WFSResponse issueGetFeaturePOST(GetFeature request) throws IOException {
        GetFeatureQueryAdapter adapter;
        if (!this.supportsOperation(WFSOperationType.GET_FEATURE, true)) {
            throw new UnsupportedOperationException("The server does not support GetFeature for HTTP method POST");
        }
        URL postURL = this.getOperationURL(WFSOperationType.GET_FEATURE, true);
        if (request instanceof GetFeatureQueryAdapter && (adapter = (GetFeatureQueryAdapter)request).getVendorParameter() != null) {
            String url = postURL.toString();
            if (url == null || !url.endsWith("?")) {
                url = url + "?";
            }
            boolean first = true;
            for (Map.Entry<String, String> entry : adapter.getVendorParameter().entrySet()) {
                if (first) {
                    first = false;
                } else {
                    url = url + "&";
                }
                url = url + entry.getKey() + "=" + URLEncoder.encode(entry.getValue(), "UTF-8");
            }
            postURL = new URL(url);
        }
        WFSStrategy.RequestComponents reqParts = this.strategy.createGetFeatureRequest(this, request);
        GetFeatureType serverRequest = reqParts.getServerRequest();
        Encoder encoder = new Encoder(this.strategy.getWfsConfiguration());
        String typeName = reqParts.getKvpParameters().get("TYPENAME");
        QName fullName = this.getFeatureTypeName(typeName);
        String prefix = fullName.getPrefix();
        String namespace = fullName.getNamespaceURI();
        if (!"".equals(prefix)) {
            encoder.getNamespaces().declarePrefix(prefix, namespace);
        }
        WFSResponse response = this.issuePostRequest((EObject)serverRequest, postURL, encoder);
        return response;
    }

    @Override
    public void dispose() {
    }

    private FeatureTypeType getFeatureTypeInfo(String typeName) {
        if (!this.typeInfos.containsKey(typeName)) {
            throw new IllegalArgumentException("Type name not found: " + typeName);
        }
        return this.typeInfos.get(typeName);
    }

    protected WFSCapabilitiesType parseCapabilities(InputStream capabilitiesReader) throws IOException {
        Object parsed;
        Configuration wfsConfig = this.strategy.getWfsConfiguration();
        Parser parser = new Parser(wfsConfig);
        try {
            parsed = parser.parse(capabilitiesReader);
        }
        catch (SAXException e) {
            throw new DataSourceException("Exception parsing WFS 1.1.0 capabilities", e);
        }
        catch (ParserConfigurationException e) {
            throw new DataSourceException("WFS 1.1.0 parsing configuration error", e);
        }
        if (parsed == null) {
            throw new DataSourceException("WFS 1.1.0 capabilities was not parsed");
        }
        if (!(parsed instanceof WFSCapabilitiesType)) {
            throw new DataSourceException("Expected WFS Capabilities, got " + parsed);
        }
        return (WFSCapabilitiesType)parsed;
    }

    private Set<String> extractKeywords(List<KeywordsType> keywordsList) {
        HashSet<String> keywords = new HashSet<String>();
        for (KeywordsType keys : keywordsList) {
            keywords.addAll((Collection<String>)keys.getKeyword());
        }
        return keywords;
    }

    private OperationType getOperationMetadata(WFSOperationType operation) {
        OperationsMetadataType operationsMetadata = this.capabilities.getOperationsMetadata();
        EList operations = operationsMetadata.getOperation();
        String expectedOperationName = operation.getName();
        for (OperationType operationType : operations) {
            String operationName = operationType.getName();
            if (!expectedOperationName.equalsIgnoreCase(operationName)) continue;
            return operationType;
        }
        throw new NoSuchElementException("Operation metadata not found for " + expectedOperationName + " in the capabilities document");
    }

    private URL getDescribeFeatureTypeURLGet(String typeName, String outputFormat) {
        URL url;
        FeatureTypeType typeInfo = this.getFeatureTypeInfo(typeName);
        URL describeFeatureTypeUrl = this.getOperationURL(WFSOperationType.DESCRIBE_FEATURETYPE, false);
        HashMap<String, String> kvp = new HashMap<String, String>();
        kvp.put("SERVICE", "WFS");
        kvp.put("VERSION", this.getServiceVersion().toString());
        kvp.put("REQUEST", "DescribeFeatureType");
        kvp.put("TYPENAME", typeName);
        QName name = typeInfo.getName();
        if (!"".equals(name.getPrefix())) {
            String nsUri = name.getNamespaceURI();
            kvp.put("NAMESPACE", "xmlns(" + name.getPrefix() + "=" + nsUri + ")");
        }
        try {
            url = HttpUtil.createUrl(describeFeatureTypeUrl, kvp);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return url;
    }

    private WFSResponse issueGetRequest(EObject request, URL url, Map<String, String> kvp) throws IOException {
        URL targetUrl = HttpUtil.createUrl(url, kvp);
        HTTPResponse httpResponse = this.http.get(targetUrl);
        String responseCharset = httpResponse.getResponseCharset();
        Charset charset = responseCharset == null ? null : Charset.forName(responseCharset);
        String contentType = httpResponse.getContentType();
        InputStream responseStream = httpResponse.getResponseStream();
        WFSResponse response = new WFSResponse(targetUrl.toExternalForm(), request, charset, contentType, responseStream);
        return response;
    }

    private WFSResponse issuePostRequest(EObject request, URL url, Encoder encoder) throws IOException {
        Charset charset = this.defaultEncoding == null ? Charset.forName("UTF-8") : this.defaultEncoding;
        encoder.setEncoding(charset);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        WFS_1_1_0_Protocol.encode(request, encoder, out);
        ByteArrayInputStream postContent = new ByteArrayInputStream(out.toByteArray());
        HTTPResponse httpResponse = this.http.post(url, (InputStream)postContent, "text/xml");
        String responseCharset = httpResponse.getResponseCharset();
        Charset charset2 = responseCharset == null ? null : Charset.forName(responseCharset);
        String contentType = httpResponse.getContentType();
        InputStream responseStream = httpResponse.getResponseStream();
        WFSResponse response = new WFSResponse(url.toExternalForm(), request, charset2, contentType, responseStream);
        return response;
    }

    private String getOperationURI(WFSOperationType operation, HttpMethod method) {
        OperationType operationType = this.getOperationMetadata(operation);
        EList dcps = operationType.getDCP();
        for (DCPType dcp : dcps) {
            EList requests = HttpMethod.GET == method ? dcp.getHTTP().getGet() : dcp.getHTTP().getPost();
            Iterator iterator = requests.iterator();
            if (!iterator.hasNext()) continue;
            RequestMethodType req = (RequestMethodType)iterator.next();
            String href = req.getHref();
            return href;
        }
        return null;
    }

    public static void encode(EObject request, Configuration configuration, OutputStream out, Charset charset) throws IOException {
        Encoder encoder = new Encoder(configuration);
        encoder.setEncoding(charset);
        WFS_1_1_0_Protocol.encode(request, encoder, out);
    }

    private static void encode(EObject request, Encoder encoder, OutputStream out) throws IOException {
        encoder.setIndentSize(1);
        QName encodeElementName = WFS_1_1_0_Protocol.getElementName(request);
        encoder.encode((Object)request, encodeElementName, out);
    }

    private static QName getElementName(EObject originatingRequest) {
        QName encodeElementName;
        if (originatingRequest instanceof GetCapabilitiesType) {
            encodeElementName = WFS.GetCapabilities;
        } else if (originatingRequest instanceof GetFeatureType) {
            encodeElementName = WFS.GetFeature;
        } else if (originatingRequest instanceof DescribeFeatureTypeType) {
            encodeElementName = WFS.DescribeFeatureType;
        } else if (originatingRequest instanceof GetCapabilitiesType) {
            encodeElementName = WFS.GetCapabilities;
        } else if (originatingRequest instanceof GetGmlObjectType) {
            encodeElementName = WFS.GetGmlObject;
        } else if (originatingRequest instanceof LockFeatureType) {
            encodeElementName = WFS.LockFeature;
        } else if (originatingRequest instanceof TransactionType) {
            encodeElementName = WFS.Transaction;
        } else {
            throw new IllegalArgumentException("Unknown xml element name for " + originatingRequest);
        }
        return encodeElementName;
    }

    @Override
    public String getDefaultOutputFormat(WFSOperationType operation) {
        return this.strategy.getDefaultOutputFormat(this, operation);
    }

    @Override
    public Filter[] splitFilters(Filter filter) {
        FilterCapabilities filterCapabilities = this.getFilterCapabilities();
        Capabilities filterCaps = new Capabilities();
        if (filterCapabilities != null) {
            filterCaps.addAll(filterCapabilities);
        }
        return this.strategy.splitFilters(filterCaps, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimpleFeatureType issueDescribeFeatureTypeGET(String prefixedTypeName, CoordinateReferenceSystem crs) throws IOException {
        SimpleFeatureType featureType;
        URL describeUrl;
        boolean isAuth;
        File tmpFile = null;
        boolean bl = isAuth = this.http.getUser() != null;
        if (isAuth) {
            WFSResponse wfsResponse = this.describeFeatureTypeGET(prefixedTypeName, null);
            tmpFile = File.createTempFile("describeft", ".xsd");
            FileOutputStream output = new FileOutputStream(tmpFile);
            InputStream response = wfsResponse.getInputStream();
            try {
                IOUtils.copy((InputStream)response, (OutputStream)output);
            }
            finally {
                output.flush();
                ((OutputStream)output).close();
                response.close();
            }
            describeUrl = tmpFile.toURI().toURL();
        } else {
            describeUrl = this.getDescribeFeatureTypeURLGet(prefixedTypeName);
        }
        Configuration wfsConfiguration = this.strategy.getWfsConfiguration();
        QName featureDescriptorName = this.getFeatureTypeName(prefixedTypeName);
        try {
            featureType = EmfAppSchemaParser.parseSimpleFeatureType(wfsConfiguration, featureDescriptorName, describeUrl, crs, this.strategy.getNamespaceURIMappings(), this.strategy.getFieldTypeMappings(), this.strategy.canIgnoreMissingElementDeclaration());
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
        return featureType;
    }
}

