/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.resources;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.context.ServiceContext;
import jeeves.server.dispatchers.ServiceManager;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.api.records.attachments.Store;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.MetadataResourceVisibility;
import org.fao.geonet.domain.OperationAllowed;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.OperationAllowedRepository;
import org.fao.geonet.services.resources.handlers.IResourceDownloadHandler;
import org.fao.geonet.util.MailSender;
import org.fao.geonet.utils.FilePathChecker;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.NativeWebRequest;

@Controller
@Deprecated
public class Download {
    @Autowired
    private DataManager dataManager;
    @Autowired
    private ServiceManager serviceManager;

    @RequestMapping(value={"/{portal}/{lang}/resources.get"})
    public HttpEntity<byte[]> exec(@PathVariable String lang, @RequestParam(value="id", required=false) String idParam, @RequestParam(value="uuid", required=false) String uuidParam, @RequestParam(value="fname") String fname, @RequestParam(value="access", defaultValue="public") String access, NativeWebRequest request) throws Exception {
        String id = null;
        if (idParam != null) {
            id = idParam;
        } else if (uuidParam != null) {
            id = this.dataManager.getMetadataId(uuidParam);
        } else {
            throw new Exception("Request must contain a UUID (uuid) or an ID (id)");
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)request.getNativeRequest(HttpServletRequest.class);
        ServiceContext context = this.serviceManager.createServiceContext("resources.get", lang, httpServletRequest);
        boolean doNotify = false;
        FilePathChecker.verify((String)fname);
        if (access.equals("private")) {
            Lib.resource.checkPrivilege(context, id, ReservedOperation.download);
            doNotify = true;
        }
        Store store = (Store)context.getBean("resourceStore", Store.class);
        if (uuidParam == null) {
            uuidParam = this.dataManager.getMetadataUuid(id);
        }
        try (Store.ResourceHolder resource = store.getResource(context, uuidParam, MetadataResourceVisibility.parse((String)access), fname, Boolean.valueOf(true));){
            Path file = resource.getPath();
            context.info("File is : " + file);
            GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
            SettingManager sm = (SettingManager)gc.getBean(SettingManager.class);
            DataManager dm = (DataManager)gc.getBean(DataManager.class);
            if (access.equals("private")) {
                dm.increasePopularity(context, id);
            }
            if (doNotify) {
                String host = sm.getValue("system/feedback/mailServer/host");
                String port = sm.getValue("system/feedback/mailServer/port");
                String from = sm.getValue("system/feedback/email");
                String fromDescr = "GeoNetwork administrator";
                if (host.trim().length() == 0 || from.trim().length() == 0) {
                    if (context.isDebugEnabled()) {
                        context.debug("Skipping email notification");
                    }
                } else {
                    if (context.isDebugEnabled()) {
                        context.debug("Sending email notification for file : " + file);
                    }
                    OperationAllowedRepository opAllowedRepo = (OperationAllowedRepository)context.getBean(OperationAllowedRepository.class);
                    GroupRepository groupRepository = (GroupRepository)context.getBean(GroupRepository.class);
                    List opsAllowed = opAllowedRepo.findByMetadataId(id);
                    for (OperationAllowed opAllowed : opsAllowed) {
                        if (opAllowed.getId().getOperationId() != ReservedOperation.notify.getId()) continue;
                        Group group = (Group)groupRepository.findOne((Serializable)Integer.valueOf(opAllowed.getId().getGroupId()));
                        String name = group.getName();
                        String email = group.getEmail();
                        if (email == null || email.trim().length() == 0) continue;
                        String subject = "File " + fname + " has been downloaded";
                        String message = "GeoNetwork notifies you, as contact person of group " + name + " that data file " + fname + " belonging metadata " + id + " has beed downloaded from address " + context.getIpAddress() + ".";
                        try {
                            MailSender sender = new MailSender(context);
                            sender.send(host, Integer.parseInt(port), sm.getValue("system/feedback/mailServer/username"), sm.getValue("system/feedback/mailServer/password"), sm.getValueAsBool("system/feedback/mailServer/ssl"), sm.getValueAsBool("system/feedback/mailServer/tls"), sm.getValueAsBool("system/feedback/mailServer/ignoreSslCertificateErrors"), from, fromDescr, email, null, subject, message);
                        }
                        catch (Exception e) {
                            Log.error((String)"geonetwork.resources", (Object)e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
            IResourceDownloadHandler downloadHook = (IResourceDownloadHandler)context.getApplicationContext().getBean("resourceDownloadHandler");
            HttpEntity<byte[]> httpEntity = downloadHook.onDownload(context, request, Integer.parseInt(id), fname, file);
            return httpEntity;
        }
    }
}

