/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.guiservices.versioning;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.fao.geonet.guiservices.versioning.MetadataAction;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;

public class MyLogEntryHandler
implements ISVNLogEntryHandler {
    private final List<MetadataAction> metadataActionList = new ArrayList<MetadataAction>();

    public void handleLogEntry(SVNLogEntry logEntry) {
        List<MetadataAction> metadataActions = this.createMetadataActions(logEntry);
        if (metadataActions != null && metadataActions.size() > 0) {
            this.metadataActionList.addAll(metadataActions);
        }
    }

    private List<MetadataAction> createMetadataActions(SVNLogEntry logEntry) {
        ArrayList<MetadataAction> list = new ArrayList<MetadataAction>();
        MetadataAction ma = new MetadataAction();
        SVNProperties revisionProperties = logEntry.getRevisionProperties();
        String userName = this.getUserName(revisionProperties);
        if (userName == null) {
            return null;
        }
        ma.setRevision(logEntry.getRevision());
        ma.setUsername(userName);
        ma.setIp(this.getIp(revisionProperties));
        Date date = logEntry.getDate();
        ma.setDate(this.getDate(date));
        Map changedPaths = logEntry.getChangedPaths();
        Integer previousId = null;
        for (Object o : changedPaths.values()) {
            if (!(o instanceof SVNLogEntryPath)) {
                return null;
            }
            SVNLogEntryPath svnLogEntryPath = (SVNLogEntryPath)o;
            String path = svnLogEntryPath.getPath();
            char action = this.getAction(svnLogEntryPath.getType());
            String subject = this.getSubject(path);
            if (subject == null && action != 'D') {
                return null;
            }
            ma.setAction(action);
            if (action == 'M' || action == 'A' && subject.equals("status")) {
                ma.setSubject(subject);
            } else {
                ma.setSubject("all");
            }
            Integer id = this.getId(path);
            if (id == null) break;
            if (changedPaths.size() == 1) {
                ma.setId(id);
                list.add(ma);
            } else if (!id.equals(previousId) || action == 'M' && !this.subjectsAreSame(changedPaths)) {
                MetadataAction newMetadataAction = new MetadataAction(ma);
                newMetadataAction.setId(id);
                list.add(newMetadataAction);
            }
            previousId = id;
        }
        return list;
    }

    private boolean subjectsAreSame(Map changedPaths) {
        Collection values = changedPaths.values();
        boolean allAreSame = true;
        String subject = null;
        for (Object next : values) {
            SVNLogEntryPath svnLogEntryPath = (SVNLogEntryPath)next;
            String currentSubject = this.getSubject(svnLogEntryPath.getPath());
            if (subject == null) {
                subject = currentSubject;
            } else {
                boolean bl = allAreSame = allAreSame && subject.compareTo(currentSubject) == 0;
            }
            if (allAreSame) continue;
            return allAreSame;
        }
        return allAreSame;
    }

    private String getSubject(String path) {
        String[] split = path.split("/");
        String subject = null;
        if (split.length > 2) {
            subject = split[2].split(".xml")[0];
        }
        return subject;
    }

    private Integer getId(String path) {
        String[] split = path.split("/");
        Integer id = null;
        if (split.length > 1) {
            id = Integer.valueOf(split[1]);
        }
        return id;
    }

    private char getAction(char action) {
        return action;
    }

    private Date getDate(Date date) {
        return date;
    }

    private String getUserName(SVNProperties revProp) {
        String[] split;
        SVNPropertyValue svnPropertyValue = revProp.getSVNPropertyValue("svn:log");
        String s = null;
        if (svnPropertyValue != null && svnPropertyValue.isString() && (split = svnPropertyValue.getString().split("Username: ")).length > 1) {
            s = split[1].split(" ")[0];
        }
        return s;
    }

    private String getIp(SVNProperties revProp) {
        String[] split;
        SVNPropertyValue svnPropertyValue = revProp.getSVNPropertyValue("svn:log");
        String s = null;
        if (svnPropertyValue != null && svnPropertyValue.isString() && (split = svnPropertyValue.getString().split("IP address ")).length > 1) {
            s = split[1].split(" ")[0];
        }
        return s;
    }

    public final List<MetadataAction> getMetadataActionList() {
        return this.metadataActionList;
    }
}

