/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.site;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.ResourceAlreadyExistException;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.domain.Group;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.resources.Resources;
import org.fao.geonet.utils.FilePathChecker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"/{portal}/api/logos", "/{portal}/api/0.1/logos"})
@Api(value="logos", tags={"logos"}, description="Logos operations")
@Controller(value="siteLogos")
public class LogosApi {
    private static final String[] iconExt = new String[]{".gif", ".png", ".jpg", ".jpeg"};
    private DirectoryStream.Filter<Path> iconFilter = new DirectoryStream.Filter<Path>(){

        @Override
        public boolean accept(Path file) {
            if (file == null || Files.exists(file, new LinkOption[0]) && !Files.isRegularFile(file, new LinkOption[0])) {
                return false;
            }
            if (file.getFileName() != null) {
                String name = file.getFileName().toString();
                for (String ext : iconExt) {
                    if (!name.endsWith(ext)) continue;
                    return true;
                }
            }
            return false;
        }
    };
    @Autowired
    GeonetworkDataDirectory dataDirectory;
    @Autowired
    GroupRepository groupRepository;

    @ApiOperation(value="Get all logos", notes="Logos are used for the catalog, the groups logos, and harvester icons. Logos are stored in the data directory in <dataDirectory>/resources/images/harvesting.<br/> Records are attached to a source. A source can be the local catalog or a harvester node. When a source is created, its logo is located in the images/logos folder with the source UUID as filename. For some sources the logo can be automatically retrieved (eg. when harvesting GeoNetwork catalogs). For others, the logo is usually manually defined when configuring the harvester.", nickname="getLogos")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public Set<String> get(HttpServletRequest request) {
        ConfigurableApplicationContext context = ApplicationContextHolder.get();
        Set icons = ((Resources)context.getBean(Resources.class)).listFiles(ApiUtils.createServiceContext(request), "harvesting", this.iconFilter);
        HashSet<String> iconsList = new HashSet<String>(icons.size());
        for (Path i : icons) {
            iconsList.add(i.getFileName().toString());
        }
        return iconsList;
    }

    @ApiOperation(value="Add a logo", notes="", authorizations={@Authorization(value="basicAuth")}, nickname="addLogo")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('UserAdmin')")
    @ApiResponses(value={@ApiResponse(code=201, message="Logo added."), @ApiResponse(code=403, message="Operation not allowed. Only UserAdmins can access it.")})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public ResponseEntity addLogo(@ApiParam(value="The logo image to upload") @RequestParam(value="file") MultipartFile[] file, @ApiParam(value="Overwrite if exists", required=false) @RequestParam(defaultValue="false", required=false) boolean overwrite, HttpServletRequest request) throws Exception {
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        Resources resources = (Resources)appContext.getBean(Resources.class);
        ServiceContext serviceContext = ApiUtils.createServiceContext(request);
        Path directoryPath = resources.locateHarvesterLogosDirSMVC((ApplicationContext)appContext);
        for (MultipartFile f : file) {
            String fileName = f.getOriginalFilename();
            this.checkFileName(fileName);
            try (Resources.ResourceHolder holder = resources.getWritableImage(serviceContext, fileName, directoryPath);){
                if (Files.exists(holder.getPath(), new LinkOption[0]) && !overwrite) {
                    holder.abort();
                    throw new ResourceAlreadyExistException(fileName);
                }
                Files.copy(f.getInputStream(), holder.getPath(), new CopyOption[0]);
            }
        }
        return new ResponseEntity(HttpStatus.CREATED);
    }

    private void checkFileName(String fileName) throws Exception {
        FilePathChecker.verify((String)fileName);
        if (StringUtils.isEmpty((String)fileName)) {
            throw new Exception("File name is not defined.");
        }
    }

    @ApiOperation(value="Remove a logo", notes="", authorizations={@Authorization(value="basicAuth")}, nickname="deleteLogo")
    @RequestMapping(path={"/{file:.+}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @PreAuthorize(value="hasRole('UserAdmin')")
    @ApiResponses(value={@ApiResponse(code=204, message="Logo removed."), @ApiResponse(code=404, message="Resource not found."), @ApiResponse(code=403, message="Operation not allowed. Only UserAdmins can access it.")})
    @ResponseBody
    public void deleteLogo(@ApiParam(value="The logo filename to delete") @PathVariable String file, HttpServletRequest request) throws Exception {
        block14: {
            this.checkFileName(file);
            FilePathChecker.verify((String)file);
            ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
            Resources resources = (Resources)appContext.getBean(Resources.class);
            ServiceContext serviceContext = ApiUtils.createServiceContext(request);
            Path nodeLogoDirectory = resources.locateHarvesterLogosDirSMVC((ApplicationContext)appContext);
            try (Resources.ResourceHolder image = resources.getImage(serviceContext, file, nodeLogoDirectory);){
                if (image != null) {
                    List groups = this.groupRepository.findByLogo(file);
                    if (groups != null && groups.size() > 0) {
                        List groupIds = groups.stream().map(Group::getName).collect(Collectors.toList());
                        throw new IllegalArgumentException(String.format("Logo '%s' is used by %d group(s). Assign another logo to the following groups: %s.", file, groups.size(), groupIds.toString()));
                    }
                    resources.deleteImageIfExists(file, nodeLogoDirectory);
                    break block14;
                }
                throw new ResourceNotFoundException(String.format("No logo found with filename '%s'.", file));
            }
        }
    }
}

