/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sail.query;

import java.util.Collection;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.sesame.sail.RdfSchemaSource;
import org.openrdf.sesame.sail.RdfSource;
import org.openrdf.sesame.sail.StatementIterator;
import org.openrdf.sesame.sail.query.SailQueryException;
import org.openrdf.sesame.sail.query.TriplePattern;
import org.openrdf.sesame.sail.query.Var;
import org.openrdf.sesame.sail.util.EmptyStatementIterator;

public class DirectSubPropertyOf
extends TriplePattern {
    private static final Var PREDICATE_VAR = new Var("_directSubPropertyOf", (Value)URIImpl.RDFS_SUBPROPERTYOF);

    public DirectSubPropertyOf(Var subjectVar, Var objectVar) {
        super(subjectVar, PREDICATE_VAR, objectVar);
    }

    protected StatementIterator _getStatementIterator(RdfSource rdfSource, Resource subj, URI pred, Value obj) throws SailQueryException {
        try {
            RdfSchemaSource rss = (RdfSchemaSource)rdfSource;
            if (obj == null || obj instanceof Resource) {
                return rss.getDirectSubPropertyOf(subj, (Resource)obj);
            }
            return new EmptyStatementIterator();
        }
        catch (ClassCastException e) {
            throw new SailQueryException("Cannot evaluate directSubPropertyOf on a non-inferencing repository");
        }
    }

    public void getVariables(Collection variables) {
        variables.add(this.getSubjectVar());
        variables.add(this.getObjectVar());
    }

    public String toString() {
        StringBuffer result = new StringBuffer(128);
        result.append("(");
        if (this.getSubjectVar().hasValue()) {
            result.append(this.getSubjectVar().getString());
        } else {
            result.append(this.getSubjectVar().toString());
        }
        result.append(",");
        result.append("serql:directSubPropertyOf");
        result.append(",");
        if (this.getObjectVar().hasValue()) {
            result.append(this.getObjectVar().getString());
        } else {
            result.append(this.getObjectVar().toString());
        }
        result.append(")");
        return result.toString();
    }
}

