/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.AbstractCharCollection;
import bak.pcj.Adapter;
import bak.pcj.CharIterator;
import bak.pcj.adapter.IteratorToCharIteratorAdapter;
import bak.pcj.util.Exceptions;
import java.util.Collection;

public class CollectionToCharCollectionAdapter
extends AbstractCharCollection {
    protected Collection collection;

    public CollectionToCharCollectionAdapter(Collection collection) {
        this(collection, false);
    }

    public CollectionToCharCollectionAdapter(Collection collection, boolean validate) {
        if (collection == null) {
            Exceptions.nullArgument("collection");
        }
        this.collection = collection;
        if (validate) {
            this.evalidate();
        }
    }

    public boolean add(char v) {
        return this.collection.add(new Character(v));
    }

    public void clear() {
        this.collection.clear();
    }

    public boolean contains(char v) {
        return this.collection.contains(new Character(v));
    }

    public int hashCode() {
        return this.collection.hashCode();
    }

    public CharIterator iterator() {
        return new IteratorToCharIteratorAdapter(this.collection.iterator());
    }

    public boolean remove(char v) {
        return this.collection.remove(new Character(v));
    }

    public int size() {
        return this.collection.size();
    }

    public boolean validate() {
        return Adapter.isCharAdaptable(this.collection);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("collection");
        }
    }
}

