/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.adapter.CharIteratorToIteratorAdapter;
import bak.pcj.set.CharSet;
import bak.pcj.util.Exceptions;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;

public class CharSetToSetAdapter
extends AbstractSet {
    protected CharSet set;

    public CharSetToSetAdapter(CharSet set) {
        if (set == null) {
            Exceptions.nullArgument("set");
        }
        this.set = set;
    }

    public boolean add(Object o) {
        if (o == null) {
            Exceptions.nullElementNotAllowed();
        }
        return this.set.add(((Character)o).charValue());
    }

    public void clear() {
        this.set.clear();
    }

    public boolean contains(Object o) {
        try {
            return this.set.contains(((Character)o).charValue());
        }
        catch (ClassCastException cce) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public int hashCode() {
        return this.set.hashCode();
    }

    public Iterator iterator() {
        return new CharIteratorToIteratorAdapter(this.set.iterator());
    }

    public boolean remove(Object o) {
        try {
            return this.set.remove(((Character)o).charValue());
        }
        catch (ClassCastException cce) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public boolean retainAll(Collection c) {
        if (c == null) {
            Exceptions.nullArgument("collection");
        }
        return super.retainAll(c);
    }

    public int size() {
        return this.set.size();
    }
}

