/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search.function;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.queries.CustomScoreProvider;
import org.apache.lucene.queries.CustomScoreQuery;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.fao.geonet.domain.ISODate;

public class RecencyBoostingQuery
extends CustomScoreQuery {
    private static int SEC_PER_DAY = 86400;
    private double multiplier;
    private ISODate today = new ISODate();
    private int maxDaysAgo;
    private String dayField;

    public RecencyBoostingQuery(Query q, double multiplier, int maxDaysAgo, String dayField) {
        super(q);
        this.multiplier = multiplier;
        this.maxDaysAgo = maxDaysAgo;
        this.dayField = dayField;
    }

    public CustomScoreProvider getCustomScoreProvider(AtomicReaderContext r) throws IOException {
        return new RecencyBooster(r);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.dayField == null ? 0 : this.dayField.hashCode());
        result = 31 * result + this.maxDaysAgo;
        long temp = Double.doubleToLongBits(this.multiplier);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.today == null ? 0 : this.today.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        RecencyBoostingQuery other = (RecencyBoostingQuery)((Object)obj);
        if (this.dayField == null ? other.dayField != null : !this.dayField.equals(other.dayField)) {
            return false;
        }
        if (this.maxDaysAgo != other.maxDaysAgo) {
            return false;
        }
        if (Double.doubleToLongBits(this.multiplier) != Double.doubleToLongBits(other.multiplier)) {
            return false;
        }
        return !(this.today == null ? other.today != null : !this.today.equals((Object)other.today));
    }

    private class RecencyBooster
    extends CustomScoreProvider {
        final SortedDocValues publishDay;

        public RecencyBooster(AtomicReaderContext r) throws IOException {
            super(r);
            this.publishDay = FieldCache.DEFAULT.getTermsIndex(r.reader(), RecencyBoostingQuery.this.dayField);
        }

        public float customScore(int doc, float subQueryScore, float valSrcScore) {
            BytesRef ret = new BytesRef();
            this.publishDay.get(doc);
            ISODate d = new ISODate(ret.utf8ToString());
            long daysAgo = RecencyBoostingQuery.this.today.timeDifferenceInSeconds(d) / (long)SEC_PER_DAY;
            if (daysAgo < (long)RecencyBoostingQuery.this.maxDaysAgo) {
                float boost = (float)(RecencyBoostingQuery.this.multiplier * (double)((long)RecencyBoostingQuery.this.maxDaysAgo - daysAgo) / (double)RecencyBoostingQuery.this.maxDaysAgo);
                return (float)((double)subQueryScore * (1.0 + (double)boost));
            }
            return subQueryScore;
        }
    }
}

