/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.util.ResultSet;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.Vector;
import jdbm.RecordManager;
import jdbm.RecordManagerFactory;
import jdbm.btree.BTree;
import jdbm.helper.StringComparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jzkit.search.util.RecordBuilder.RecordBuilderException;
import org.jzkit.search.util.RecordBuilder.RecordBuilderService;
import org.jzkit.search.util.RecordConversion.FragmentTransformationException;
import org.jzkit.search.util.RecordConversion.FragmentTransformerService;
import org.jzkit.search.util.RecordModel.ExplicitRecordFormatSpecification;
import org.jzkit.search.util.RecordModel.InformationFragment;
import org.jzkit.search.util.RecordModel.InformationFragmentImpl;
import org.jzkit.search.util.RecordModel.RecordFormatSpecification;
import org.jzkit.search.util.ResultSet.AbstractIRResultSet;
import org.jzkit.search.util.ResultSet.AggregatedResultSetEntry;
import org.jzkit.search.util.ResultSet.IFSNotificationTarget;
import org.jzkit.search.util.ResultSet.IRResultSet;
import org.jzkit.search.util.ResultSet.IRResultSetException;
import org.jzkit.search.util.ResultSet.IRResultSetInfo;
import org.jzkit.search.util.ResultSet.PendingGet;
import org.jzkit.search.util.ResultSet.ReadAheadEnumeration;
import org.jzkit.search.util.ResultSet.ResultSetEvent;
import org.jzkit.search.util.ResultSet.TransformingIRResultSet;
import org.w3c.dom.Document;

public class SimpleAggregatingResultSet
extends AbstractIRResultSet
implements Observer,
TransformingIRResultSet {
    private static Log log = LogFactory.getLog(SimpleAggregatingResultSet.class);
    private Map sources = new HashMap();
    private RecordManager recman = null;
    private BTree result_set = null;
    private int total_sources = 0;
    private int unknown_status = 0;
    private int partial_status = 0;
    private int complete_status = 0;
    private int error_status = 0;
    private boolean strict_mode = true;
    private Object counter_sync = new Object();
    private Object new_records_lock = new Object();
    protected int target_record_hwm = -1;
    protected int record_hwm = -1;
    private int total_records_available = 0;
    private int num_records_held = 0;
    private int rec_counter = 0;
    private ResultSetThread rs_aggregator_thread = null;
    private Vector pending_async_gets = new Vector();
    private FragmentTransformerService transformation_service = null;
    private RecordFormatSpecification default_format = null;
    private String results_file_name = null;
    private RecordBuilderService record_builder_service = null;
    private int status = 1;
    private static long instance_counter = 0L;

    public SimpleAggregatingResultSet(FragmentTransformerService transformation_service, RecordBuilderService record_builder_service, RecordFormatSpecification default_format) {
        this(transformation_service, record_builder_service, default_format, false);
    }

    public SimpleAggregatingResultSet(FragmentTransformerService transformation_service, RecordBuilderService record_builder_service, RecordFormatSpecification default_format, boolean strict_mode) {
        this.transformation_service = transformation_service;
        this.default_format = default_format;
        this.record_builder_service = record_builder_service;
        this.strict_mode = strict_mode;
        log.debug((Object)("new SimpleAggregatingResultSet : " + ++instance_counter));
        try {
            File results_file = null;
            String dir = System.getProperty("com.k_int.inode.tmpdir");
            results_file = dir != null ? File.createTempFile("AFS", "jdbm", new File(dir)) : File.createTempFile("AFS", "jdbm");
            this.results_file_name = results_file.toString();
            Properties props = new Properties();
            props.put("jdbm.cache.size", "500");
            props.put("jdbm.disableTransactions", "true");
            this.recman = RecordManagerFactory.createRecordManager((String)this.results_file_name, (Properties)props);
            results_file.delete();
            this.result_set = BTree.createInstance((RecordManager)this.recman, (Comparator)new StringComparator());
        }
        catch (Exception e) {
            log.warn((Object)"Problem creating results file name", (Throwable)e);
        }
        log.debug((Object)"Creating new ResultSetThread()");
        this.rs_aggregator_thread = new ResultSetThread();
        this.rs_aggregator_thread.start();
    }

    protected void finalize() {
        log.debug((Object)("SimpleAggregatingResultSet::finalize() : " + --instance_counter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSource(IRResultSet ir_result_set) {
        log.debug((Object)("addSource " + ir_result_set.getSetID()));
        Object object = this.counter_sync;
        synchronized (object) {
            this.sources.put(ir_result_set.getSetID(), new SourceInfo(ir_result_set, this.default_format, this.total_sources));
            ++this.total_sources;
            ++this.unknown_status;
        }
        ir_result_set.addObserver((Observer)this);
        ir_result_set.requestStatusNotification();
    }

    public InformationFragment[] getFragment(int starting_fragment, int count, RecordFormatSpecification spec) throws IRResultSetException {
        int tmp_int;
        log.debug((Object)("SimpleAggregatingResultSet::getFragment(" + starting_fragment + "," + count + "," + spec + ")"));
        if (starting_fragment < 1) {
            throw new IRResultSetException("Starting fragment out of bounds (" + starting_fragment + ") must be >= 1");
        }
        InformationFragment[] result = null;
        int top_record = starting_fragment + count - 1;
        int default_timeout = 20000;
        String default_timeout_str = System.getProperty("org.jzkit.resultset.timeout");
        if (default_timeout_str != null && (tmp_int = Integer.parseInt(default_timeout_str)) > 0) {
            default_timeout = tmp_int;
        }
        this.ensureRecordAvailable(top_record);
        this.waitForResult(top_record, default_timeout);
        int num_to_present = this.num_records_held - starting_fragment + 1;
        if (num_to_present > count) {
            num_to_present = count;
        } else if (num_to_present < 0) {
            num_to_present = 0;
        }
        log.debug((Object)("After wait, count=" + this.getFragmentCount() + ", records held=" + this.num_records_held + " required top rec=" + top_record + " num to present=" + num_to_present));
        result = new InformationFragment[num_to_present];
        for (int i = 0; i < num_to_present; ++i) {
            AggregatedResultSetEntry are = this.getHeader(starting_fragment + i);
            result[i] = this.retrieve(are, spec);
        }
        log.debug((Object)("SimpleAggregatingResultSet::getFragment returning - result array size=" + result.length));
        return result;
    }

    public void asyncGetFragment(int starting_fragment, int count, RecordFormatSpecification spec, IFSNotificationTarget target) throws IRResultSetException {
        this.asyncGetFragment(starting_fragment, count, spec, null, target);
    }

    public int getFragmentCount() {
        return this.total_records_available;
    }

    public int getRecordAvailableHWM() {
        return 0;
    }

    public void close() {
        log.debug((Object)("close() SAR=" + this.hashCode()));
        Collection c = this.sources.values();
        if (this.rs_aggregator_thread != null) {
            this.rs_aggregator_thread.close();
        }
        log.debug((Object)"Closing source result sets");
        for (SourceInfo source : c) {
            IRResultSet rs = source.ir_result_set;
            log.debug((Object)("Close child: " + rs));
            rs.close();
            source.ir_result_set = null;
            source.rae = null;
        }
        log.debug((Object)"Done closing source result sets");
        this.sources.clear();
        c.clear();
        try {
            log.debug((Object)"Closing record manager");
            this.recman.close();
            log.debug((Object)("Deleting " + this.results_file_name + ".db"));
            File f = new File(this.results_file_name + ".db");
            f.delete();
            f = null;
            f = new File(this.results_file_name + ".lg");
            f.delete();
            f = null;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public synchronized void update(Observable o, Object arg) {
        log.debug((Object)"update.....");
        if (arg != null) {
            if (arg instanceof ResultSetEvent) {
                ResultSetEvent e = (ResultSetEvent)arg;
                if (o instanceof IRResultSet) {
                    IRResultSet rs = (IRResultSet)o;
                    SourceInfo si = (SourceInfo)this.sources.get(rs.getSetID());
                    if (si.status != rs.getStatus()) {
                        log.debug((Object)(" Detected a state change in RS " + rs.getSetID() + " stored status is " + si.status + " new status is " + rs.getStatus()));
                        switch (si.status) {
                            case 1: {
                                --this.unknown_status;
                                break;
                            }
                            case 4: {
                                --this.complete_status;
                                break;
                            }
                            case 8: {
                                --this.complete_status;
                                break;
                            }
                            case 2: {
                                --this.partial_status;
                            }
                        }
                        switch (rs.getStatus()) {
                            case 4: {
                                ++this.complete_status;
                                break;
                            }
                            case 8: {
                                ++this.complete_status;
                                ++this.error_status;
                                break;
                            }
                            case 2: {
                                ++this.partial_status;
                            }
                        }
                        si.status = rs.getStatus();
                        if (this.total_sources == this.complete_status) {
                            if (this.error_status > 0) {
                                log.debug((Object)"At least 1 component searches failed");
                                if (this.strict_mode || this.error_status == this.total_sources) {
                                    log.debug((Object)"In strict mode, fail entire search");
                                    this.setStatus(8);
                                } else {
                                    log.debug((Object)"Not strict mode... continue");
                                    this.setStatus(4);
                                }
                            } else {
                                log.debug((Object)"All component searches completed OK");
                                this.setStatus(4);
                            }
                        } else if (this.complete_status > 1) {
                            log.debug((Object)"Set status to SUBSET");
                            this.setStatus(2);
                        } else {
                            log.debug((Object)"Set status to IDLE");
                            this.setStatus(1);
                        }
                    }
                    log.debug((Object)("UPDATE: Record count, status=" + si.status + ", local count=" + si.result_count + ", rs count=" + rs.getFragmentCount()));
                    if ((si.status == 4 || si.status == 2) && si.result_count != rs.getFragmentCount()) {
                        if (si.result_count == -1) {
                            si.result_count = rs.getFragmentCount();
                            this.total_records_available += si.result_count;
                        } else {
                            int diff = rs.getFragmentCount() - si.result_count;
                            this.total_records_available += diff;
                        }
                    } else {
                        log.warn((Object)"Source Result set status is idle or failure");
                    }
                } else {
                    log.warn((Object)("Update to aggregating result set did not come from Result set, but from " + o.getClass().getName()));
                }
            } else {
                log.warn((Object)("Update arg was not Result set event, but from " + arg.getClass().getName()));
            }
        } else {
            log.warn((Object)"Update to aggregating result passed null arg");
        }
        log.debug((Object)("After update, " + this.total_records_available + " records available, Aggr-RS Status is " + this.getStatus()));
        log.debug((Object)("total_sources=" + this.total_sources + " complete_status=" + this.complete_status));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetchAnyNewRecords() {
        int records_fetched = 1;
        boolean needs_notify = false;
        while (records_fetched > 0 && this.target_record_hwm > this.record_hwm) {
            records_fetched = 0;
            for (SourceInfo si : this.sources.values()) {
                if (!si.rae.nextIsAvailable()) continue;
                InformationFragment rec = (InformationFragment)si.rae.nextElement();
                if (rec != null) {
                    ++records_fetched;
                    ++this.record_hwm;
                    rec.setSourceRepositoryID(si.ir_result_set.getResultSetName());
                    String source_rec_key = this.store(rec, si.ir_result_set.getSetID(), new Long(rec.getHitNo()), this.default_format);
                    String header_key = "H:" + ++this.rec_counter;
                    try {
                        this.result_set.insert((Object)header_key, (Object)new AggregatedResultSetEntry(si.ir_result_set.getSetID(), new Long(rec.getHitNo())), true);
                        ++this.num_records_held;
                    }
                    catch (IOException ioe) {
                        log.error((Object)"Problem storing fragment header", (Throwable)ioe);
                    }
                    continue;
                }
                log.error((Object)"**ERROR** Information Fragment was null");
            }
            if (records_fetched <= 0) continue;
            needs_notify = true;
        }
        if (needs_notify) {
            Object object = this.new_records_lock;
            synchronized (object) {
                this.new_records_lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForResult(int index, int wait_timeout) throws IRResultSetException {
        log.debug((Object)("Wait for result(" + index + "," + wait_timeout + ")"));
        long starttime = System.currentTimeMillis();
        boolean record_is_available = this.num_records_held >= index;
        long endtime = starttime + (long)wait_timeout;
        while (!record_is_available && System.currentTimeMillis() < endtime) {
            try {
                long time_left_to_wait = endtime - System.currentTimeMillis();
                Object object = this.new_records_lock;
                synchronized (object) {
                    if (this.num_records_held >= index) {
                        record_is_available = true;
                    } else if (time_left_to_wait > 0L) {
                        this.new_records_lock.wait(time_left_to_wait);
                    }
                }
            }
            catch (InterruptedException ie) {
                log.warn((Object)"someone notified the new_records_lock that records have become available");
            }
            Thread.yield();
        }
        if (this.num_records_held > index) {
            record_is_available = true;
        }
        if (!record_is_available) {
            log.debug((Object)("Record not avail.. required=" + index + " rs size = " + this.getResultSetSize()));
        }
        return true;
    }

    public int getResultSetSize() {
        return this.num_records_held;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureRecordAvailable(int index) {
        log.debug((Object)("ensureRecordAvailable: " + index));
        this.target_record_hwm = index;
        SimpleAggregatingResultSet simpleAggregatingResultSet = this;
        synchronized (simpleAggregatingResultSet) {
            this.notifyAll();
        }
    }

    private String store(InformationFragment f, String source_id, Long hitno, RecordFormatSpecification format) {
        String key = "S:" + source_id + ":" + hitno + ":" + format.toString();
        log.debug((Object)("Store fragment " + key));
        try {
            if (f != null) {
                this.result_set.insert((Object)key, (Object)f, true);
            }
        }
        catch (IOException ioe) {
            log.warn((Object)"Problem storing fragment", (Throwable)ioe);
        }
        log.debug((Object)("Store fragment complete " + key));
        return key;
    }

    private InformationFragment retrieve(AggregatedResultSetEntry are) {
        return this.retrieve(are, this.default_format);
    }

    private InformationFragment retrieve(AggregatedResultSetEntry are, RecordFormatSpecification format) {
        InformationFragment retval;
        block5: {
            retval = null;
            try {
                String record_key = "S:" + are.getSourceId() + ":" + are.getHitnoAtSource() + ":" + format.toString();
                log.debug((Object)("trying to retrieve actual record..." + record_key));
                retval = (InformationFragment)this.result_set.find((Object)record_key);
                if (retval != null) break block5;
                log.debug((Object)("Attempt direct retrieval from source rs:" + are.getSourceId() + " hitno is " + are.getHitnoAtSource()));
                SourceInfo si = (SourceInfo)this.sources.get(are.getSourceId());
                log.debug((Object)("Got SourceInfo:" + si));
                try {
                    InformationFragment[] result = si.ir_result_set.getFragment(are.getHitnoAtSource().intValue(), 1, format);
                    if (result.length == 1) {
                        retval = result[0];
                        this.result_set.insert((Object)record_key, (Object)retval, true);
                    }
                }
                catch (IRResultSetException irrse) {
                    log.warn((Object)"Problem fetching alternate syntax", (Throwable)irrse);
                }
            }
            catch (IOException ioe) {
                log.warn((Object)"Problem fetching fragment", (Throwable)ioe);
            }
        }
        log.debug((Object)("returnung " + retval));
        return retval;
    }

    private AggregatedResultSetEntry getHeader(int index) throws IRResultSetException {
        String header_key = "H:" + index;
        AggregatedResultSetEntry are = null;
        try {
            are = (AggregatedResultSetEntry)this.result_set.find((Object)header_key);
        }
        catch (IOException ioe) {
            throw new IRResultSetException("Problem looking up result header", (Object)ioe);
        }
        return are;
    }

    public InformationFragment[] getFragment(int starting_fragment, int count, RecordFormatSpecification request_spec, ExplicitRecordFormatSpecification transform_spec, Map additional_properties) throws IRResultSetException {
        InformationFragment[] records = this.getFragment(starting_fragment, count, request_spec);
        if (transform_spec != null) {
            return this.transformRecords(records, transform_spec, starting_fragment, additional_properties);
        }
        return records;
    }

    public InformationFragment[] getFragment(int starting_fragment, int count, RecordFormatSpecification request_spec, ExplicitRecordFormatSpecification transform_spec) throws IRResultSetException {
        return this.getFragment(starting_fragment, count, request_spec, transform_spec, null);
    }

    public void asyncGetFragment(int starting_fragment, int count, RecordFormatSpecification request_spec, ExplicitRecordFormatSpecification transformation_spec, IFSNotificationTarget target, Map additional_properties) throws IRResultSetException {
        log.debug((Object)("asyncGetFragment(" + starting_fragment + "," + count + "," + request_spec + "," + transformation_spec + "," + target + ")"));
        int top_record = starting_fragment + count - 1;
        if (this.getResultSetSize() >= top_record) {
            log.debug((Object)"request can be met by records currently in rs, just send them");
            InformationFragment[] retval = new InformationFragment[count];
            for (int i = 0; i < count; ++i) {
                AggregatedResultSetEntry are = this.getHeader(starting_fragment + i);
                retval[i] = this.retrieve(are, request_spec);
            }
            target.notifyRecords(retval);
        } else {
            log.debug((Object)"Storring pending get - request will processes as soon as records are available");
            PendingGet pg = new PendingGet(starting_fragment, count, request_spec, target, transformation_spec);
            this.pending_async_gets.add(pg);
            this.ensureRecordAvailable(top_record);
        }
    }

    public void asyncGetFragment(int starting_fragment, int count, RecordFormatSpecification request_spec, ExplicitRecordFormatSpecification transformation_spec, IFSNotificationTarget target) throws IRResultSetException {
        this.asyncGetFragment(starting_fragment, count, request_spec, transformation_spec, target, null);
    }

    private InformationFragment[] transformRecords(InformationFragment[] records, ExplicitRecordFormatSpecification transform_spec, int starting_fragment, Map default_props) {
        InformationFragment[] result = new InformationFragment[records.length];
        for (int i = 0; i < records.length; ++i) {
            try {
                if (records[i] != null) {
                    Hashtable trans_props = null;
                    trans_props = default_props != null ? new Hashtable(default_props) : new Hashtable();
                    ExplicitRecordFormatSpecification source_spec = records[i].getFormatSpecification();
                    log.debug((Object)("Trying to get from " + source_spec + " to " + transform_spec));
                    if (source_spec.getEncoding().equals(transform_spec.getEncoding()) && (transform_spec.getSchema() == null || source_spec.getSchema().equals(transform_spec.getSchema())) && (transform_spec.getSetname() == null || transform_spec.getSetname().toString().equalsIgnoreCase(source_spec.getSetname().toString()))) {
                        log.debug((Object)"Request pattern matches held record, just returning");
                        result[i] = records[i];
                        continue;
                    }
                    log.debug((Object)("Determine record factory for record type " + records[i].getFormatSpecification()));
                    String factory_name = "org.jzkit.recordbuilder." + records[i].getFormatSpecification().getEncoding();
                    log.debug((Object)("Obtain record model plugin for " + factory_name));
                    log.debug((Object)"Get the xml for the input document type");
                    Document d = this.record_builder_service.getCanonicalXML(records[i]);
                    log.debug((Object)("Translating from " + source_spec + " to " + transform_spec));
                    Document raw_data = (Document)this.transformation_service.convert(d, source_spec.toString(), transform_spec.toString(), trans_props);
                    log.debug((Object)"Creating instance of record model");
                    result[i] = new InformationFragmentImpl((long)(starting_fragment + i), "svc", "coll", null, (Object)raw_data, transform_spec);
                    continue;
                }
                result[i] = new InformationFragmentImpl((long)(starting_fragment + i), null, null, null, (Object)"No source record", new ExplicitRecordFormatSpecification("string:diag:F"));
                continue;
            }
            catch (FragmentTransformationException fte) {
                log.warn((Object)("transformRecords - Problem transforming record " + i + " into " + transform_spec), (Throwable)fte);
                result[i] = new InformationFragmentImpl((long)(starting_fragment + i), null, null, null, (Object)fte.toString(), new ExplicitRecordFormatSpecification("string:diag:F"));
                continue;
            }
            catch (RecordBuilderException rbe) {
                log.warn((Object)("transformRecords - Problem transforming record " + i + " into " + transform_spec), (Throwable)rbe);
                result[i] = new InformationFragmentImpl((long)(starting_fragment + i), null, null, null, (Object)rbe.toString(), new ExplicitRecordFormatSpecification("string:diag:F"));
            }
        }
        return result;
    }

    private void checkPendingFecthList() {
        log.debug((Object)"checkPendingFecthList()");
    }

    public IRResultSetInfo getResultSetInfo() {
        ArrayList<IRResultSetInfo> child_reports = new ArrayList<IRResultSetInfo>();
        Collection c = this.sources.values();
        for (SourceInfo source : c) {
            IRResultSet rs = source.ir_result_set;
            child_reports.add(rs.getResultSetInfo());
        }
        return new IRResultSetInfo(this.result_set_name, "AGGREGATOR", "SIMPLE", this.getFragmentCount(), this.getStatus(), child_reports);
    }

    private class ResultSetThread
    extends Thread {
        boolean running = true;

        public ResultSetThread() {
            log.debug((Object)("new ResultSetThread for " + SimpleAggregatingResultSet.this.hashCode()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            log.debug((Object)("Start rs loop.. target_hwm=" + SimpleAggregatingResultSet.this.target_record_hwm + ", current=" + SimpleAggregatingResultSet.this.record_hwm));
            while (this.running) {
                if (SimpleAggregatingResultSet.this.target_record_hwm > SimpleAggregatingResultSet.this.record_hwm) {
                    log.debug((Object)"Read-ahead fetch of records required.. call fetchAnyNewRecords");
                    SimpleAggregatingResultSet.this.fetchAnyNewRecords();
                }
                if (!this.running) continue;
                try {
                    SimpleAggregatingResultSet simpleAggregatingResultSet = SimpleAggregatingResultSet.this;
                    synchronized (simpleAggregatingResultSet) {
                        log.debug((Object)("Waiting for more records to become available. Current hwm=" + SimpleAggregatingResultSet.this.record_hwm + " id=" + SimpleAggregatingResultSet.this.hashCode()));
                        SimpleAggregatingResultSet.this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                log.debug((Object)"Aggregate thread woken");
            }
        }

        public void close() {
            this.running = false;
            this.interrupt();
        }
    }

    private class SourceInfo {
        public int status = 1;
        public IRResultSet ir_result_set = null;
        public int result_count = -1;
        public ReadAheadEnumeration rae = null;
        public int source_identifier;

        public SourceInfo(IRResultSet ir_result_set, RecordFormatSpecification default_format, int source_identifier) {
            this.ir_result_set = ir_result_set;
            this.source_identifier = source_identifier;
            this.rae = new ReadAheadEnumeration(ir_result_set, default_format, (Object)SimpleAggregatingResultSet.this);
        }
    }
}

