/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.piecewise;

import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.operation.matrix.Matrix1;
import org.geotools.referencing.piecewise.DefaultConstantPiecewiseTransformElement;
import org.geotools.referencing.piecewise.DefaultDomainElement1D;
import org.geotools.referencing.piecewise.DefaultLinearPiecewiseTransform1DElement;
import org.geotools.referencing.piecewise.DefaultPassthroughPiecewiseTransform1DElement;
import org.geotools.referencing.piecewise.PiecewiseTransform1DElement;
import org.geotools.referencing.piecewise.PiecewiseUtilities;
import org.geotools.referencing.wkt.UnformattableObjectException;
import org.geotools.renderer.i18n.Errors;
import org.geotools.util.NumberRange;
import org.geotools.util.Utilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public class DefaultPiecewiseTransform1DElement
extends DefaultDomainElement1D
implements PiecewiseTransform1DElement {
    private static final long serialVersionUID = 7422178060824402864L;
    private MathTransform1D transform;
    private MathTransform1D inverse;
    private int hashCode = -1;

    public static DefaultPiecewiseTransform1DElement create(CharSequence name, NumberRange<? extends Number> inRange, double value) {
        return new DefaultConstantPiecewiseTransformElement(name, inRange, value);
    }

    public static DefaultPiecewiseTransform1DElement create(CharSequence name, NumberRange<? extends Number> inRange, byte value) {
        return new DefaultConstantPiecewiseTransformElement(name, inRange, value);
    }

    public static DefaultPiecewiseTransform1DElement create(CharSequence name, NumberRange<? extends Number> inRange, int value) {
        return new DefaultConstantPiecewiseTransformElement(name, inRange, value);
    }

    public static DefaultPiecewiseTransform1DElement create(CharSequence name, NumberRange<? extends Number> inRange, NumberRange<? extends Number> outRange) {
        return new DefaultLinearPiecewiseTransform1DElement(name, inRange, outRange);
    }

    public static DefaultPiecewiseTransform1DElement create(CharSequence name) throws IllegalArgumentException {
        return new DefaultPassthroughPiecewiseTransform1DElement(name, (NumberRange<? extends Number>)NumberRange.create((double)Double.NEGATIVE_INFINITY, (double)Double.POSITIVE_INFINITY));
    }

    public static DefaultPiecewiseTransform1DElement create(CharSequence name, NumberRange<? extends Number> valueRange) throws IllegalArgumentException {
        return new DefaultPassthroughPiecewiseTransform1DElement(name, valueRange);
    }

    protected DefaultPiecewiseTransform1DElement(CharSequence name, NumberRange<? extends Number> valueRange) throws IllegalArgumentException {
        super(name, valueRange);
    }

    protected DefaultPiecewiseTransform1DElement(CharSequence name, NumberRange<? extends Number> valueRange, MathTransform1D transform) throws IllegalArgumentException {
        super(name, valueRange);
        PiecewiseUtilities.ensureNonNull("transform", transform);
        this.transform = transform;
    }

    public String toWKT() throws UnsupportedOperationException {
        throw new UnformattableObjectException("Not yet implemented.", this.getClass());
    }

    protected synchronized MathTransform1D getTransform() {
        return this.transform;
    }

    public synchronized double transform(double value) throws TransformException {
        if (this.transform == null) {
            throw new IllegalStateException();
        }
        if (this.contains(value)) {
            return this.transform.transform(value);
        }
        throw new IllegalArgumentException(Errors.format(9, "Provided value is not contained in this domain"));
    }

    public synchronized double derivative(double value) throws TransformException {
        if (this.transform == null) {
            throw new IllegalStateException();
        }
        if (this.contains(value)) {
            return this.transform.derivative(value);
        }
        throw new TransformException(Errors.format(5, new Double(value)));
    }

    public DirectPosition transform(DirectPosition ptSrc, DirectPosition ptDst) throws TransformException {
        PiecewiseUtilities.checkDimension(ptSrc);
        if (ptDst == null) {
            ptDst = new GeneralDirectPosition(1);
        } else {
            PiecewiseUtilities.checkDimension(ptDst);
        }
        ptDst.setOrdinate(0, this.transform(ptSrc.getOrdinate(0)));
        return ptDst;
    }

    public Matrix derivative(DirectPosition point) throws TransformException {
        PiecewiseUtilities.ensureNonNull("DirectPosition", point);
        PiecewiseUtilities.checkDimension(point);
        return new Matrix1(this.derivative(point.getOrdinate(0)));
    }

    public void transform(double[] arg0, int arg1, double[] arg2, int arg3, int arg4) throws TransformException {
        throw new UnsupportedOperationException(Errors.format(15, "transform"));
    }

    public void transform(float[] arg0, int arg1, float[] arg2, int arg3, int arg4) throws TransformException {
        throw new UnsupportedOperationException(Errors.format(15, "transform"));
    }

    public void transform(float[] arg0, int arg1, double[] arg2, int arg3, int arg4) throws TransformException {
        throw new UnsupportedOperationException(Errors.format(15, "transform"));
    }

    public void transform(double[] arg0, int arg1, float[] arg2, int arg3, int arg4) throws TransformException {
        throw new UnsupportedOperationException(Errors.format(15, "transform"));
    }

    public int getSourceDimensions() {
        return this.transform.getSourceDimensions();
    }

    public int getTargetDimensions() {
        return this.transform.getTargetDimensions();
    }

    public synchronized MathTransform1D inverse() throws NoninvertibleTransformException {
        if (this.inverse != null) {
            return this.inverse;
        }
        if (this.transform == null) {
            throw new IllegalStateException(Errors.format(16));
        }
        this.inverse = this.transform.inverse();
        return this.inverse;
    }

    public boolean isIdentity() {
        return this.transform.isIdentity();
    }

    protected synchronized void setInverse(MathTransform1D mathTransform) {
        if (this.inverse != null) {
            throw new IllegalStateException(Errors.format(16));
        }
        this.inverse = mathTransform;
    }

    protected synchronized void setTransform(MathTransform1D transform) {
        PiecewiseUtilities.ensureNonNull("transform", transform);
        if (this.transform != null) {
            throw new IllegalStateException(Errors.format(16));
        }
        this.transform = transform;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DefaultPiecewiseTransform1DElement)) {
            return false;
        }
        DefaultPiecewiseTransform1DElement that = (DefaultPiecewiseTransform1DElement)obj;
        if (this.getEquivalenceClass() != that.getEquivalenceClass()) {
            return false;
        }
        if (!Utilities.equals((Object)this.transform, (Object)that.transform)) {
            return false;
        }
        if (!Utilities.equals((Object)this.inverse, (Object)that.inverse)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder(super.toString());
        buffer.append("\n").append("wkt transform=").append(this.transform.toWKT());
        return buffer.toString();
    }

    @Override
    protected Class<?> getEquivalenceClass() {
        return DefaultPiecewiseTransform1DElement.class;
    }

    @Override
    public int hashCode() {
        if (this.hashCode >= 0) {
            return this.hashCode;
        }
        this.hashCode = 37;
        this.hashCode = Utilities.hash((Object)this.transform, (int)this.hashCode);
        this.hashCode = Utilities.hash((Object)this.inverse, (int)this.hashCode);
        this.hashCode = Utilities.hash((int)super.hashCode(), (int)this.hashCode);
        return this.hashCode;
    }

    public static DefaultPiecewiseTransform1DElement create(String string, NumberRange<? extends Number> range, MathTransform1D mathTransform1D) {
        return new DefaultPiecewiseTransform1DElement(string, range, mathTransform1D);
    }
}

