/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.search;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.fao.geonet.kernel.search.LuceneConfig;
import org.fao.geonet.kernel.search.facet.Dimension;
import org.fao.geonet.kernel.search.facet.ItemConfig;
import org.fao.geonet.kernel.search.facet.SummaryType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="search/facet/config")
public class FacetsService {
    @Autowired
    private LuceneConfig luceneConfig;

    @RequestMapping(value={"/{portal}/{lang:[a-z]{3}}/search/facet/config"}, produces={"application/json"})
    @ResponseBody
    public Map<String, List<Facet>> getConfig() {
        LinkedHashMap results = Maps.newLinkedHashMap();
        for (SummaryType summaryType : this.luceneConfig.getSummaryTypes().getSummaryTypes()) {
            ArrayList facets = Lists.newArrayList();
            for (ItemConfig itemConfig : summaryType.getItems()) {
                facets.add(new Facet(itemConfig));
            }
            results.put(summaryType.getName(), facets);
        }
        return results;
    }

    public static class Facet {
        private final String key;
        private final String name;
        private final String label;
        private final Integer pageSize;

        public Facet(ItemConfig itemConfig) {
            Dimension dimension = itemConfig.getDimension();
            this.key = dimension.getIndexKey();
            this.label = dimension.getLabel();
            this.name = dimension.getName();
            this.pageSize = itemConfig.getPageSize();
        }

        public String getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        public String getLabel() {
            return this.label;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }
    }

    public static class FacetConfig {
        final String id;
        final List<Facet> items = Lists.newArrayList();

        public FacetConfig(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public List<Facet> getItems() {
            return this.items;
        }
    }
}

