/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.extent;

import com.vividsolutions.jts.awt.ShapeWriter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import javax.imageio.ImageIO;
import jeeves.server.context.ServiceContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.api.records.extent.ExpandFactor;
import org.fao.geonet.api.regions.GeomFormat;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.kernel.region.Region;
import org.fao.geonet.kernel.region.RegionNotFoundEx;
import org.fao.geonet.kernel.region.RegionsDAO;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.springframework.context.ConfigurableApplicationContext;

public class MapRenderer {
    private final ServiceContext context;
    private static final double WGS_DIAG = Math.sqrt(Math.pow(360.0, 2.0) + Math.pow(180.0, 2.0));

    public MapRenderer(ServiceContext context) {
        this.context = context;
    }

    public static AffineTransform worldToScreenTransform(Envelope mapExtent, Dimension screenSize) {
        double scaleX = screenSize.getWidth() / mapExtent.getWidth();
        double scaleY = screenSize.getHeight() / mapExtent.getHeight();
        double tx = -mapExtent.getMinX() * scaleX;
        double ty = mapExtent.getMinY() * scaleY + screenSize.getHeight();
        return new AffineTransform(scaleX, 0.0, 0.0, -scaleY, tx, ty);
    }

    public static Geometry computeGeomInDomainOfValidity(Geometry geom, CoordinateReferenceSystem mapCRS) {
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
        Extent domainOfValidity = mapCRS.getDomainOfValidity();
        Geometry adjustedGeom = geom;
        if (domainOfValidity != null) {
            for (GeographicExtent extent : domainOfValidity.getGeographicElements()) {
                if (Boolean.FALSE.equals(extent.getInclusion()) || !(extent instanceof GeographicBoundingBox) || extent == null) continue;
                GeographicBoundingBox box = (GeographicBoundingBox)extent;
                Envelope env = new Envelope(box.getWestBoundLongitude(), box.getEastBoundLongitude(), box.getSouthBoundLatitude(), box.getNorthBoundLatitude());
                if (env.contains(geom.getEnvelopeInternal())) {
                    return geom;
                }
                Polygon extentPolygon = JTS.toGeometry((Envelope)env);
                adjustedGeom = geom.intersection((Geometry)extentPolygon);
            }
            return adjustedGeom;
        }
        return geom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BufferedImage render(String id, String srs, Integer width, Integer height, String background, String geomParam, String geomType, String geomSrs, String fillColor, String strokeColor) throws Exception {
        BufferedImage image;
        Throwable error;
        Dimension imageDimensions;
        Envelope bboxOfImage;
        Geometry geom;
        block23: {
            block24: {
                block26: {
                    Map regionGetMapBackgroundLayers;
                    block25: {
                        ConfigurableApplicationContext appContext = this.context.getApplicationContext();
                        regionGetMapBackgroundLayers = (Map)appContext.getBean("regionGetMapBackgroundLayers", Map.class);
                        SortedSet regionGetMapExpandFactors = (SortedSet)appContext.getBean("regionGetMapExpandFactors", SortedSet.class);
                        SettingManager settingManager = (SettingManager)appContext.getBean(SettingManager.class);
                        geom = null;
                        if (id != null) {
                            RegionsDAO regionsDAO;
                            Collection daos = this.context.getApplicationContext().getBeansOfType(RegionsDAO.class).values();
                            Iterator iterator = daos.iterator();
                            while (iterator.hasNext() && (geom = (regionsDAO = (RegionsDAO)iterator.next()).getGeom(this.context, id, false, srs)) == null) {
                            }
                            if (geom == null) {
                                throw new RegionNotFoundEx(id);
                            }
                        } else {
                            GeomFormat format = GeomFormat.find(geomType);
                            geom = format.parse(geomParam);
                            if (!geomSrs.equals(srs)) {
                                CoordinateReferenceSystem mapCRS = Region.decodeCRS((String)srs);
                                CoordinateReferenceSystem geomCRS = Region.decodeCRS((String)geomSrs);
                                geom = MapRenderer.computeGeomInDomainOfValidity(geom, mapCRS);
                                MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)geomCRS, (CoordinateReferenceSystem)mapCRS, (boolean)true);
                                geom = JTS.transform((Geometry)geom, (MathTransform)transform);
                            }
                        }
                        bboxOfImage = new Envelope(geom.getEnvelopeInternal());
                        double expandFactor = this.calculateExpandFactor(regionGetMapExpandFactors, bboxOfImage, srs);
                        bboxOfImage.expandBy(bboxOfImage.getWidth() * expandFactor, bboxOfImage.getHeight() * expandFactor);
                        imageDimensions = this.calculateImageSize(bboxOfImage, width, height);
                        error = null;
                        if (background == null) break block24;
                        if (!background.equalsIgnoreCase("settings")) break block25;
                        String bgSetting = settingManager.getValue("region/getmap/background");
                        if (bgSetting.startsWith("http://") || bgSetting.startsWith("https://")) {
                            background = settingManager.getValue("region/getmap/background");
                            break block26;
                        } else if (regionGetMapBackgroundLayers.containsKey(bgSetting)) {
                            background = (String)regionGetMapBackgroundLayers.get(bgSetting);
                        }
                        break block26;
                    }
                    if (regionGetMapBackgroundLayers.containsKey(background)) {
                        background = (String)regionGetMapBackgroundLayers.get(background);
                    }
                }
                String minx = Double.toString(bboxOfImage.getMinX());
                String maxx = Double.toString(bboxOfImage.getMaxX());
                String miny = Double.toString(bboxOfImage.getMinY());
                String maxy = Double.toString(bboxOfImage.getMaxY());
                background = background.replace("{minx}", minx).replace("{maxx}", maxx).replace("{miny}", miny).replace("{maxy}", maxy).replace("{srs}", srs).replace("{width}", Integer.toString(imageDimensions.width)).replace("{height}", Integer.toString(imageDimensions.height)).replace("{MINX}", minx).replace("{MAXX}", maxx).replace("{MINY}", miny).replace("{MAXY}", maxy).replace("{SRS}", srs).replace("{WIDTH}", Integer.toString(imageDimensions.width)).replace("{HEIGHT}", Integer.toString(imageDimensions.height));
                InputStream in = null;
                try {
                    URL imageUrl = new URL(background);
                    HttpURLConnection conn = Lib.net.setupProxy(this.context, imageUrl);
                    int status = conn.getResponseCode();
                    if (status != 200) {
                        if (status == 302 || status == 301 || status == 303) {
                            imageUrl = new URL(conn.getHeaderField("Location"));
                        }
                        conn = (HttpURLConnection)imageUrl.openConnection();
                    }
                    in = conn.getInputStream();
                    BufferedImage original = ImageIO.read(in);
                    image = new BufferedImage(original.getWidth(), original.getHeight(), 2);
                    Graphics2D g2d = image.createGraphics();
                    g2d.drawImage((Image)original, 0, 0, null);
                    if (in != null) {
                    }
                    break block23;
                }
                catch (IOException e) {
                    image = new BufferedImage(imageDimensions.width, imageDimensions.height, 2);
                    error = e;
                    break block23;
                }
                IOUtils.closeQuietly((InputStream)in);
                break block23;
                finally {
                    if (in != null) {
                        IOUtils.closeQuietly(in);
                    }
                }
            }
            image = new BufferedImage(imageDimensions.width, imageDimensions.height, 2);
        }
        Graphics2D graphics = image.createGraphics();
        try {
            if (error != null) {
                graphics.drawString(error.getMessage(), 0, imageDimensions.height / 2);
            }
            ShapeWriter shapeWriter = new ShapeWriter();
            Color geomFillColor = this.getColor(fillColor, new Color(0, 0, 0, 50));
            Color geomStrokeColor = this.getColor(strokeColor, new Color(0, 0, 0, 255));
            AffineTransform worldToScreenTransform = MapRenderer.worldToScreenTransform(bboxOfImage, imageDimensions);
            int i = 0;
            while (i < geom.getNumGeometries()) {
                Shape shape = worldToScreenTransform.createTransformedShape(shapeWriter.toShape(geom.getGeometryN(i)));
                graphics.setColor(geomFillColor);
                graphics.fill(shape);
                graphics.setColor(geomStrokeColor);
                graphics.setStroke(new BasicStroke(2.0f));
                graphics.draw(shape);
                ++i;
            }
            return image;
        }
        finally {
            graphics.dispose();
        }
    }

    private Color getColor(String color, Color defaultColor) {
        if (StringUtils.isNotEmpty((String)color)) {
            String[] colorsConfig = color.split(",");
            if (colorsConfig.length == 4) {
                try {
                    return new Color(Integer.parseInt(colorsConfig[0]), Integer.parseInt(colorsConfig[1]), Integer.parseInt(colorsConfig[2]), Integer.parseInt(colorsConfig[3]));
                }
                catch (Exception e) {
                    throw new BadParameterEx(String.format("Invalid color configuration '%s'. Error is '%s'. Format must be 'RED,GREEN,BLUE,ALPHA' with integer value from 0 to 255.", color, e.getMessage()));
                }
            }
            throw new BadParameterEx(String.format("Invalid color configuration '%s'. Format must be 'RED,GREEN,BLUE,ALPHA' with integer value from 0 to 255.", color));
        }
        return defaultColor;
    }

    private double calculateExpandFactor(SortedSet<ExpandFactor> regionGetMapExpandFactors, Envelope bboxOfImage, String srs) throws Exception {
        CoordinateReferenceSystem crs = Region.decodeCRS((String)srs);
        ReferencedEnvelope env = new ReferencedEnvelope(bboxOfImage, crs);
        env = env.transform(Region.WGS84, true);
        double diag = Math.sqrt(Math.pow(env.getWidth(), 2.0) + Math.pow(env.getHeight(), 2.0));
        double scale = diag / WGS_DIAG;
        for (ExpandFactor factor : regionGetMapExpandFactors) {
            if (!(scale < factor.proportion)) continue;
            return factor.factor;
        }
        return regionGetMapExpandFactors.last().factor;
    }

    private Dimension calculateImageSize(Envelope bboxOfImage, Integer width, Integer height) {
        if (width != null) {
            return new Dimension(width, (int)Math.round(bboxOfImage.getHeight() / bboxOfImage.getWidth() * (double)width.intValue()));
        }
        return new Dimension((int)Math.round(bboxOfImage.getWidth() / bboxOfImage.getHeight() * (double)height.intValue()), height);
    }
}

