/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jeeves.server.context.ServiceContext;
import jeeves.services.ReadWriteController;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.doi.client.DoiManager;
import org.fao.geonet.domain.AbstractMetadata;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@RequestMapping(value={"/{portal}/api/records", "/{portal}/api/0.1/records"})
@Api(value="records", tags={"records"})
@Controller(value="doi")
@PreAuthorize(value="hasRole('Editor')")
@ReadWriteController
public class DoiApi {
    @Autowired
    private DoiManager doiManager;

    @ApiOperation(value="Check that a record can be submitted to DataCite for DOI creation. DataCite requires some fields to be populated.", nickname="checkDoiStatus")
    @RequestMapping(value={"/{metadataUuid}/doi/checkPreConditions"}, method={RequestMethod.GET}, produces={"application/json"})
    @PreAuthorize(value="hasRole('Editor')")
    @ApiResponses(value={@ApiResponse(code=200, message="Record can be proposed to DataCite."), @ApiResponse(code=404, message="Metadata not found."), @ApiResponse(code=400, message="Record does not meet preconditions. Check error message."), @ApiResponse(code=500, message="Service unavailable."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseBody
    public ResponseEntity<Map<String, Boolean>> checkDoiStatus(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @ApiParam(hidden=true) @ApiIgnore HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        ServiceContext serviceContext = ApiUtils.createServiceContext(request);
        Map reportStatus = this.doiManager.check(serviceContext, metadata, null);
        return new ResponseEntity((Object)reportStatus, HttpStatus.OK);
    }

    @ApiOperation(value="Submit a record to the Datacite metadata store in order to create a DOI.", nickname="createDoi")
    @RequestMapping(value={"/{metadataUuid}/doi"}, method={RequestMethod.PUT}, produces={"application/json"})
    @PreAuthorize(value="hasRole('Editor')")
    @ApiResponses(value={@ApiResponse(code=201, message="Check status of the report."), @ApiResponse(code=404, message="Metadata not found."), @ApiResponse(code=500, message="Service unavailable."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseBody
    public ResponseEntity<Map<String, String>> createDoi(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @ApiParam(hidden=true) @ApiIgnore HttpServletRequest request, @ApiParam(hidden=true) @ApiIgnore HttpSession session) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        ServiceContext serviceContext = ApiUtils.createServiceContext(request);
        Map doiInfo = this.doiManager.register(serviceContext, metadata);
        return new ResponseEntity((Object)doiInfo, HttpStatus.CREATED);
    }

    @ApiOperation(value="Remove a DOI (this is not recommended, DOI are supposed to be persistent once created. This is mainly here for testing).", nickname="deleteDoi")
    @RequestMapping(value={"/{metadataUuid}/doi"}, method={RequestMethod.DELETE}, produces={"application/json"})
    @PreAuthorize(value="hasRole('Administrator')")
    @ApiResponses(value={@ApiResponse(code=204, message="DOI unregistered."), @ApiResponse(code=404, message="Metadata or DOI not found."), @ApiResponse(code=500, message="Service unavailable."), @ApiResponse(code=403, message="Operation not allowed. Only Administrators can access it.")})
    public ResponseEntity deleteDoi(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @ApiParam(hidden=true) @ApiIgnore HttpServletRequest request, @ApiParam(hidden=true) @ApiIgnore HttpSession session) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        ServiceContext serviceContext = ApiUtils.createServiceContext(request);
        this.doiManager.unregisterDoi(metadata, serviceContext);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }
}

