/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2017 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
define(["./defined-2a4f2d00","./Check-e5651467","./freezeObject-a51e076f","./defaultValue-29c9b1af","./Math-7782f09e","./Cartesian2-ba70b51f","./defineProperties-c817531e","./Transforms-5119c07b","./RuntimeError-51c34ab4","./WebGLConstants-90dbfe2f","./ComponentDatatype-418b1c61","./when-1faa3867","./AttributeCompression-5601f533","./IndexDatatype-2bcfc06b","./IntersectionTests-35b85442","./Plane-475170f0","./WebMercatorProjection-1ecca5ba","./createTaskProcessorWorker","./EllipsoidTangentPlane-0decb876","./OrientedBoundingBox-2b5c2949","./TerrainEncoding-114aa591"],function(fe,e,t,r,Te,be,i,pe,n,a,o,s,ye,xe,c,u,Ne,d,Me,Ce,ve){"use strict";var we=32767,Ae=new be.Cartesian3,Ee=new be.Cartesian3,Pe=new be.Cartesian3,Se=new be.Cartographic,Be=new be.Cartesian2,Fe=new be.Cartesian3,Ve=new pe.Matrix4,We=new pe.Matrix4;function _e(e,t,r,i,n,a,o,s,c){var u=Number.POSITIVE_INFINITY,d=n.north,h=n.south,m=n.east,I=n.west;m<I&&(m+=Te.CesiumMath.TWO_PI);for(var l=e.length,g=0;g<l;++g){var f=e[g],T=r[f],b=i[f];Se.longitude=Te.CesiumMath.lerp(I,m,b.x),Se.latitude=Te.CesiumMath.lerp(h,d,b.y),Se.height=T-t;var p=a.cartographicToCartesian(Se,Ae);pe.Matrix4.multiplyByPoint(o,p,p),be.Cartesian3.minimumByComponent(p,s,s),be.Cartesian3.maximumByComponent(p,c,c),u=Math.min(u,Se.height)}return u}function ke(e,t,r,i,n,a,o,s,c,u,d,h,m,I,l,g,f,T){var b,p,y;y=m?(b=n.length-1,p=-1):(b=0,p=n.length,1);var x=-1,N=fe.defined(c),M=t/a.getStride(),C=d.north,v=d.south,w=d.east,A=d.west;w<A&&(w+=Te.CesiumMath.TWO_PI);for(var E=b;E!==p;E+=y){var P=n[E],S=o[P],B=s[P];Se.longitude=Te.CesiumMath.lerp(A,w,B.x)+f,Se.latitude=Te.CesiumMath.lerp(v,C,B.y)+T,Se.height=S-h;var F,V=u.cartographicToCartesian(Se,Ae);if(N){var W=2*P;if(Be.x=c[W],Be.y=c[1+W],1!==I){var _=ye.AttributeCompression.octDecode(Be.x,Be.y,Fe),k=pe.Transforms.eastNorthUpToFixedFrame(Ae,u,We),H=pe.Matrix4.inverseTransformation(k,Ve);pe.Matrix4.multiplyByPointAsVector(H,_,_),_.z*=I,be.Cartesian3.normalize(_,_),pe.Matrix4.multiplyByPointAsVector(k,_,_),be.Cartesian3.normalize(_,_),ye.AttributeCompression.octEncode(_,Be)}}a.hasWebMercatorT&&(F=(Ne.WebMercatorProjection.geodeticLatitudeToMercatorAngle(Se.latitude)-l)*g),t=a.encode(e,t,V,B,Se.height,Be,F),-1!==x&&(r[i++]=x,r[i++]=M-1,r[i++]=P,r[i++]=M-1,r[i++]=M,r[i++]=P),x=P,++M}return i}function He(e,t){var r;return"function"==typeof e.slice&&"function"!=typeof(r=e.slice()).sort&&(r=void 0),fe.defined(r)||(r=Array.prototype.slice.call(e)),r.sort(t),r}return d(function(e,t){var r,i,n=e.quantizedVertices,a=n.length/3,o=e.octEncodedNormals,s=e.westIndices.length+e.eastIndices.length+e.southIndices.length+e.northIndices.length,c=e.includeWebMercatorT,u=e.rectangle,d=u.west,h=u.south,m=u.east,I=u.north,l=be.Ellipsoid.clone(e.ellipsoid),g=e.exaggeration,f=e.minimumHeight*g,T=e.maximumHeight*g,b=e.relativeToCenter,p=pe.Transforms.eastNorthUpToFixedFrame(b,l),y=pe.Matrix4.inverseTransformation(p,new pe.Matrix4);c&&(r=Ne.WebMercatorProjection.geodeticLatitudeToMercatorAngle(h),i=1/(Ne.WebMercatorProjection.geodeticLatitudeToMercatorAngle(I)-r));var x=n.subarray(0,a),N=n.subarray(a,2*a),M=n.subarray(2*a,3*a),C=fe.defined(o),v=new Array(a),w=new Array(a),A=new Array(a),E=c?new Array(a):[],P=Ee;P.x=Number.POSITIVE_INFINITY,P.y=Number.POSITIVE_INFINITY,P.z=Number.POSITIVE_INFINITY;var S=Pe;S.x=Number.NEGATIVE_INFINITY,S.y=Number.NEGATIVE_INFINITY,S.z=Number.NEGATIVE_INFINITY;for(var B=Number.POSITIVE_INFINITY,F=Number.NEGATIVE_INFINITY,V=Number.POSITIVE_INFINITY,W=Number.NEGATIVE_INFINITY,_=0;_<a;++_){var k=x[_],H=N[_],O=k/we,Y=H/we,z=Te.CesiumMath.lerp(f,T,M[_]/we);Se.longitude=Te.CesiumMath.lerp(d,m,O),Se.latitude=Te.CesiumMath.lerp(h,I,Y),Se.height=z,B=Math.min(Se.longitude,B),F=Math.max(Se.longitude,F),V=Math.min(Se.latitude,V),W=Math.max(Se.latitude,W);var j=l.cartographicToCartesian(Se);v[_]=new be.Cartesian2(O,Y),w[_]=z,A[_]=j,c&&(E[_]=(Ne.WebMercatorProjection.geodeticLatitudeToMercatorAngle(Se.latitude)-r)*i),pe.Matrix4.multiplyByPoint(y,j,Ae),be.Cartesian3.minimumByComponent(Ae,P,P),be.Cartesian3.maximumByComponent(Ae,S,S)}var G,D,L=He(e.westIndices,function(e,t){return v[e].y-v[t].y}),U=He(e.eastIndices,function(e,t){return v[t].y-v[e].y}),R=He(e.southIndices,function(e,t){return v[t].x-v[e].x}),q=He(e.northIndices,function(e,t){return v[e].x-v[t].x});1!==g&&(D=pe.BoundingSphere.fromPoints(A),G=Ce.OrientedBoundingBox.fromRectangle(u,f,T,l));var J=f;J=Math.min(J,_e(e.westIndices,e.westSkirtHeight,w,v,u,l,y,P,S)),J=Math.min(J,_e(e.southIndices,e.southSkirtHeight,w,v,u,l,y,P,S)),J=Math.min(J,_e(e.eastIndices,e.eastSkirtHeight,w,v,u,l,y,P,S)),J=Math.min(J,_e(e.northIndices,e.northSkirtHeight,w,v,u,l,y,P,S));for(var K=new Me.AxisAlignedBoundingBox(P,S,b),Q=new ve.TerrainEncoding(K,J,T,p,C,c),X=Q.getStride(),Z=new Float32Array(a*X+s*X),$=0,ee=0;ee<a;++ee){if(C){var te=2*ee;if(Be.x=o[te],Be.y=o[1+te],1!==g){var re=ye.AttributeCompression.octDecode(Be.x,Be.y,Fe),ie=pe.Transforms.eastNorthUpToFixedFrame(A[ee],l,We),ne=pe.Matrix4.inverseTransformation(ie,Ve);pe.Matrix4.multiplyByPointAsVector(ne,re,re),re.z*=g,be.Cartesian3.normalize(re,re),pe.Matrix4.multiplyByPointAsVector(ie,re,re),be.Cartesian3.normalize(re,re),ye.AttributeCompression.octEncode(re,Be)}}$=Q.encode(Z,$,A[ee],v[ee],w[ee],Be,E[ee])}var ae=Math.max(0,2*(s-4)),oe=e.indices.length+3*ae,se=xe.IndexDatatype.createTypedArray(a+s,oe);se.set(e.indices,0);var ce=1e-4*(F-B),ue=1e-4*(W-V),de=-ce,he=ce,me=ue,Ie=-ue,le=a*X,ge=e.indices.length;return ge=ke(Z,le,se,ge,e.westIndices,Q,w,v,o,l,u,e.westSkirtHeight,!0,g,r,i,de,0),ge=ke(Z,le+=e.westIndices.length*X,se,ge,e.southIndices,Q,w,v,o,l,u,e.southSkirtHeight,!1,g,r,i,0,Ie),ge=ke(Z,le+=e.southIndices.length*X,se,ge,e.eastIndices,Q,w,v,o,l,u,e.eastSkirtHeight,!1,g,r,i,he,0),ke(Z,le+=e.eastIndices.length*X,se,ge,e.northIndices,Q,w,v,o,l,u,e.northSkirtHeight,!0,g,r,i,0,me),t.push(Z.buffer,se.buffer),{vertices:Z.buffer,indices:se.buffer,westIndicesSouthToNorth:L,southIndicesEastToWest:R,eastIndicesNorthToSouth:U,northIndicesWestToEast:q,vertexStride:X,center:b,minimumHeight:f,maximumHeight:T,boundingSphere:D,orientedBoundingBox:G,encoding:Q,skirtIndex:e.indices.length}})});
