/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query.rql.model;

import org.openrdf.model.Resource;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.query.rql.model.DataPathSelector;
import org.openrdf.sesame.query.rql.model.DataVar;
import org.openrdf.sesame.query.rql.model.InstanceSelector;
import org.openrdf.sesame.query.rql.model.PropertyVar;
import org.openrdf.sesame.query.rql.model.Selector;
import org.openrdf.sesame.query.rql.model.URI;
import org.openrdf.sesame.sail.RdfSchemaSource;

public class UnknownSelector
implements Selector {
    protected DataVar _var;
    protected URI _uri;
    protected Selector _selector = null;

    public UnknownSelector(URI uri, DataVar var) {
        this._uri = uri;
        this._var = var;
    }

    public boolean isInstanceSelector(RdfSchemaSource rss) {
        Resource resource = (Resource)this._uri.getValue();
        return rss.isClass(resource);
    }

    public void initialize(RdfSchemaSource rss) throws QueryEvaluationException {
        if (this._selector == null) {
            if (rss.isClass((Resource)this._uri.getValue())) {
                this._selector = new InstanceSelector(this._var, this._uri);
            } else {
                DataVar sourceVar = new DataVar("_");
                PropertyVar propVar = new PropertyVar("_");
                propVar.setValue(this._uri.getValue());
                this._selector = new DataPathSelector(sourceVar, propVar, this._var, true);
            }
        }
        this._selector.initialize(rss);
    }

    public boolean selectNext(RdfSchemaSource rss) throws QueryEvaluationException {
        return this._selector.selectNext(rss);
    }

    public void clear() {
        if (this._selector != null) {
            this._selector.clear();
            this._selector = null;
        }
    }

    public String toString() {
        String result = this._uri.toString() + "{" + this._var.toString() + "}";
        return result;
    }
}

