/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.map;

import bak.pcj.AbstractBooleanCollection;
import bak.pcj.BooleanCollection;
import bak.pcj.BooleanIterator;
import bak.pcj.DoubleIterator;
import bak.pcj.hash.DefaultDoubleHashFunction;
import bak.pcj.hash.DoubleHashFunction;
import bak.pcj.hash.Primes;
import bak.pcj.map.AbstractDoubleKeyBooleanMap;
import bak.pcj.map.DoubleKeyBooleanMap;
import bak.pcj.map.DoubleKeyBooleanMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.AbstractDoubleSet;
import bak.pcj.set.DoubleSet;
import bak.pcj.util.Exceptions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class DoubleKeyBooleanChainedHashMap
extends AbstractDoubleKeyBooleanMap
implements DoubleKeyBooleanMap,
Cloneable,
Serializable {
    private static final int GROWTH_POLICY_RELATIVE = 0;
    private static final int GROWTH_POLICY_ABSOLUTE = 1;
    private static final int DEFAULT_GROWTH_POLICY = 0;
    public static final double DEFAULT_GROWTH_FACTOR = 1.0;
    public static final int DEFAULT_GROWTH_CHUNK = 10;
    public static final int DEFAULT_CAPACITY = 11;
    public static final double DEFAULT_LOAD_FACTOR = 0.75;
    private DoubleHashFunction keyhash;
    private int size;
    private transient Entry[] data;
    private int growthPolicy;
    private double growthFactor;
    private int growthChunk;
    private double loadFactor;
    private int expandAt;
    private transient DoubleSet keys;
    private transient BooleanCollection values;
    private transient boolean hasLastValue;
    private transient boolean lastValue;

    private DoubleKeyBooleanChainedHashMap(DoubleHashFunction keyhash, int capacity, int growthPolicy, double growthFactor, int growthChunk, double loadFactor) {
        if (keyhash == null) {
            Exceptions.nullArgument("hash function");
        }
        if (capacity < 0) {
            Exceptions.negativeArgument("capacity", String.valueOf(capacity));
        }
        if (growthFactor < 0.0) {
            Exceptions.negativeArgument("growthFactor", String.valueOf(growthFactor));
        }
        if (growthChunk < 0) {
            Exceptions.negativeArgument("growthChunk", String.valueOf(growthChunk));
        }
        if (loadFactor <= 0.0) {
            Exceptions.negativeOrZeroArgument("loadFactor", String.valueOf(loadFactor));
        }
        this.keyhash = keyhash;
        this.data = new Entry[capacity];
        this.size = 0;
        this.expandAt = (int)Math.round(loadFactor * (double)capacity);
        this.growthPolicy = growthPolicy;
        this.growthFactor = growthFactor;
        this.growthChunk = growthChunk;
        this.loadFactor = loadFactor;
        this.hasLastValue = false;
    }

    private DoubleKeyBooleanChainedHashMap(int capacity, int growthPolicy, double growthFactor, int growthChunk, double loadFactor) {
        this(DefaultDoubleHashFunction.INSTANCE, capacity, growthPolicy, growthFactor, growthChunk, loadFactor);
    }

    public DoubleKeyBooleanChainedHashMap() {
        this(11);
    }

    public DoubleKeyBooleanChainedHashMap(DoubleKeyBooleanMap map) {
        this();
        this.putAll(map);
    }

    public DoubleKeyBooleanChainedHashMap(int capacity) {
        this(capacity, 0, 1.0, 10, 0.75);
    }

    public DoubleKeyBooleanChainedHashMap(double loadFactor) {
        this(11, 0, 1.0, 10, loadFactor);
    }

    public DoubleKeyBooleanChainedHashMap(int capacity, double loadFactor) {
        this(capacity, 0, 1.0, 10, loadFactor);
    }

    public DoubleKeyBooleanChainedHashMap(int capacity, double loadFactor, double growthFactor) {
        this(capacity, 0, growthFactor, 10, loadFactor);
    }

    public DoubleKeyBooleanChainedHashMap(int capacity, double loadFactor, int growthChunk) {
        this(capacity, 1, 1.0, growthChunk, loadFactor);
    }

    public DoubleKeyBooleanChainedHashMap(DoubleHashFunction keyhash) {
        this(keyhash, 11, 0, 1.0, 10, 0.75);
    }

    public DoubleKeyBooleanChainedHashMap(DoubleHashFunction keyhash, int capacity) {
        this(keyhash, capacity, 0, 1.0, 10, 0.75);
    }

    public DoubleKeyBooleanChainedHashMap(DoubleHashFunction keyhash, double loadFactor) {
        this(keyhash, 11, 0, 1.0, 10, loadFactor);
    }

    public DoubleKeyBooleanChainedHashMap(DoubleHashFunction keyhash, int capacity, double loadFactor) {
        this(keyhash, capacity, 0, 1.0, 10, loadFactor);
    }

    public DoubleKeyBooleanChainedHashMap(DoubleHashFunction keyhash, int capacity, double loadFactor, double growthFactor) {
        this(keyhash, capacity, 0, growthFactor, 10, loadFactor);
    }

    public DoubleKeyBooleanChainedHashMap(DoubleHashFunction keyhash, int capacity, double loadFactor, int growthChunk) {
        this(keyhash, capacity, 1, 1.0, growthChunk, loadFactor);
    }

    private void ensureCapacity(int elements) {
        if (elements >= this.expandAt) {
            int newcapacity = this.growthPolicy == 0 ? (int)((double)this.data.length * (1.0 + this.growthFactor)) : this.data.length + this.growthChunk;
            if ((double)newcapacity * this.loadFactor < (double)elements) {
                newcapacity = (int)Math.round((double)elements / this.loadFactor);
            }
            newcapacity = Primes.nextPrime(newcapacity);
            this.expandAt = (int)Math.round(this.loadFactor * (double)newcapacity);
            Entry[] newdata = new Entry[newcapacity];
            int i = 0;
            while (i < this.data.length) {
                Entry e = this.data[i];
                while (e != null) {
                    int index = Math.abs(this.keyhash.hash(e.key)) % newdata.length;
                    Entry next = e.next;
                    e.next = newdata[index];
                    newdata[index] = e;
                    e = next;
                }
                ++i;
            }
            this.data = newdata;
        }
    }

    private Entry addList(Entry list, Entry v) {
        v.next = list;
        return v;
    }

    private Entry removeList(Entry list, Entry e) {
        if (list == e) {
            list = e.next;
            e.next = null;
            return list;
        }
        Entry listStart = list;
        while (list.next != e) {
            list = list.next;
        }
        list.next = e.next;
        e.next = null;
        return listStart;
    }

    private Entry searchList(Entry list, double key) {
        while (list != null) {
            if (list.key == key) {
                return list;
            }
            list = list.next;
        }
        return null;
    }

    private Entry getEntry(double key) {
        int index = Math.abs(this.keyhash.hash(key)) % this.data.length;
        return this.searchList(this.data[index], key);
    }

    public DoubleSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    public boolean lget() {
        if (!this.hasLastValue) {
            Exceptions.noLastElement();
        }
        return this.lastValue;
    }

    public boolean put(double key, boolean value) {
        boolean result;
        int index = Math.abs(this.keyhash.hash(key)) % this.data.length;
        Entry e = this.searchList(this.data[index], key);
        if (e == null) {
            result = MapDefaults.defaultBoolean();
            e = new Entry(key, value);
            e.next = this.data[index];
            this.data[index] = e;
            this.ensureCapacity(this.size + 1);
            ++this.size;
        } else {
            result = e.value;
            e.value = value;
        }
        return result;
    }

    public BooleanCollection values() {
        if (this.values == null) {
            this.values = new ValueCollection();
        }
        return this.values;
    }

    public Object clone() {
        try {
            DoubleKeyBooleanChainedHashMap c = (DoubleKeyBooleanChainedHashMap)super.clone();
            c.data = new Entry[this.data.length];
            int i = 0;
            while (i < this.data.length) {
                c.data[i] = this.cloneList(this.data[i]);
                ++i;
            }
            c.values = null;
            c.keys = null;
            return c;
        }
        catch (CloneNotSupportedException e) {
            Exceptions.cloning();
            return null;
        }
    }

    private Entry cloneList(Entry e) {
        if (e == null) {
            return null;
        }
        Entry ne = new Entry(e.getKey(), e.getValue());
        ne.next = this.cloneList(e.next);
        return ne;
    }

    public DoubleKeyBooleanMapIterator entries() {
        return new DoubleKeyBooleanMapIterator(){
            Entry currEntry = null;
            int nextList = this.nextList(0);
            Entry nextEntry = this.nextList == -1 ? null : DoubleKeyBooleanChainedHashMap.access$200(DoubleKeyBooleanChainedHashMap.this)[this.nextList];

            int nextList(int index) {
                while (index < DoubleKeyBooleanChainedHashMap.this.data.length && DoubleKeyBooleanChainedHashMap.this.data[index] == null) {
                    ++index;
                }
                return index < DoubleKeyBooleanChainedHashMap.this.data.length ? index : -1;
            }

            public boolean hasNext() {
                return this.nextEntry != null;
            }

            public void next() {
                if (this.nextEntry == null) {
                    Exceptions.endOfIterator();
                }
                this.currEntry = this.nextEntry;
                this.nextEntry = this.nextEntry.next;
                if (this.nextEntry == null) {
                    this.nextList = this.nextList(this.nextList + 1);
                    if (this.nextList != -1) {
                        this.nextEntry = DoubleKeyBooleanChainedHashMap.this.data[this.nextList];
                    }
                }
            }

            public double getKey() {
                if (this.currEntry == null) {
                    Exceptions.noElementToGet();
                }
                return this.currEntry.getKey();
            }

            public boolean getValue() {
                if (this.currEntry == null) {
                    Exceptions.noElementToGet();
                }
                return this.currEntry.getValue();
            }

            public void remove() {
                if (this.currEntry == null) {
                    Exceptions.noElementToRemove();
                }
                DoubleKeyBooleanChainedHashMap.this.remove(this.currEntry.getKey());
                this.currEntry = null;
            }
        };
    }

    public void clear() {
        Arrays.fill(this.data, null);
        this.size = 0;
    }

    public boolean containsKey(double key) {
        Entry e = this.getEntry(key);
        if (e == null) {
            this.hasLastValue = false;
        } else {
            this.hasLastValue = true;
            this.lastValue = e.value;
        }
        return this.hasLastValue;
    }

    public boolean containsValue(boolean value) {
        int i = 0;
        while (i < this.data.length) {
            Entry e = this.data[i];
            while (e != null) {
                if (e.value == value) {
                    return true;
                }
                e = e.next;
            }
            ++i;
        }
        return false;
    }

    public boolean get(double key) {
        int index = Math.abs(this.keyhash.hash(key)) % this.data.length;
        Entry e = this.searchList(this.data[index], key);
        return e != null ? e.value : MapDefaults.defaultBoolean();
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean remove(double key) {
        boolean value;
        int index = Math.abs(this.keyhash.hash(key)) % this.data.length;
        Entry e = this.searchList(this.data[index], key);
        if (e != null) {
            this.data[index] = this.removeList(this.data[index], e);
            value = e.value;
            --this.size;
        } else {
            value = MapDefaults.defaultBoolean();
        }
        return value;
    }

    public int size() {
        return this.size;
    }

    public boolean tget(double key) {
        int index = Math.abs(this.keyhash.hash(key)) % this.data.length;
        Entry e = this.searchList(this.data[index], key);
        if (e == null) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return e.value;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.data.length);
        DoubleKeyBooleanMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            s.writeDouble(i.getKey());
            s.writeBoolean(i.getValue());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.data = new Entry[s.readInt()];
        int i = 0;
        while (i < this.size) {
            double key = s.readDouble();
            boolean value = s.readBoolean();
            int index = Math.abs(this.keyhash.hash(key)) % this.data.length;
            Entry e = new Entry(key, value);
            e.next = this.data[index];
            this.data[index] = e;
            ++i;
        }
    }

    private class ValueCollection
    extends AbstractBooleanCollection {
        private ValueCollection() {
        }

        public void clear() {
            DoubleKeyBooleanChainedHashMap.this.clear();
        }

        public boolean contains(boolean v) {
            return DoubleKeyBooleanChainedHashMap.this.containsValue(v);
        }

        public BooleanIterator iterator() {
            return new BooleanIterator(this){
                Entry currEntry;
                int nextList;
                Entry nextEntry;
                private final /* synthetic */ ValueCollection this$1;
                {
                    this.this$1 = this$1;
                    this.currEntry = null;
                    this.nextList = this.nextList(0);
                    this.nextEntry = this.nextList == -1 ? null : DoubleKeyBooleanChainedHashMap.access$200(ValueCollection.access$600(this.this$1))[this.nextList];
                }

                int nextList(int index) {
                    while (index < DoubleKeyBooleanChainedHashMap.access$200(ValueCollection.access$600(this.this$1)).length && DoubleKeyBooleanChainedHashMap.access$200(ValueCollection.access$600(this.this$1))[index] == null) {
                        ++index;
                    }
                    return index < DoubleKeyBooleanChainedHashMap.access$200(ValueCollection.access$600(this.this$1)).length ? index : -1;
                }

                public boolean hasNext() {
                    return this.nextEntry != null;
                }

                public boolean next() {
                    if (this.nextEntry == null) {
                        Exceptions.endOfIterator();
                    }
                    this.currEntry = this.nextEntry;
                    this.nextEntry = this.nextEntry.next;
                    if (this.nextEntry == null) {
                        this.nextList = this.nextList(this.nextList + 1);
                        if (this.nextList != -1) {
                            this.nextEntry = DoubleKeyBooleanChainedHashMap.access$200(ValueCollection.access$600(this.this$1))[this.nextList];
                        }
                    }
                    return this.currEntry.value;
                }

                public void remove() {
                    if (this.currEntry == null) {
                        Exceptions.noElementToRemove();
                    }
                    ValueCollection.access$600(this.this$1).remove(this.currEntry.getKey());
                    this.currEntry = null;
                }
            };
        }

        public int size() {
            return DoubleKeyBooleanChainedHashMap.this.size;
        }

        static /* synthetic */ DoubleKeyBooleanChainedHashMap access$600(ValueCollection x0) {
            return x0.DoubleKeyBooleanChainedHashMap.this;
        }
    }

    private class KeySet
    extends AbstractDoubleSet {
        private KeySet() {
        }

        public void clear() {
            DoubleKeyBooleanChainedHashMap.this.clear();
        }

        public boolean contains(double v) {
            return DoubleKeyBooleanChainedHashMap.this.getEntry(v) != null;
        }

        public DoubleIterator iterator() {
            return new DoubleIterator(this){
                Entry currEntry;
                int nextList;
                Entry nextEntry;
                private final /* synthetic */ KeySet this$1;
                {
                    this.this$1 = this$1;
                    this.currEntry = null;
                    this.nextList = this.nextList(0);
                    this.nextEntry = this.nextList == -1 ? null : DoubleKeyBooleanChainedHashMap.access$200(KeySet.access$400(this.this$1))[this.nextList];
                }

                int nextList(int index) {
                    while (index < DoubleKeyBooleanChainedHashMap.access$200(KeySet.access$400(this.this$1)).length && DoubleKeyBooleanChainedHashMap.access$200(KeySet.access$400(this.this$1))[index] == null) {
                        ++index;
                    }
                    return index < DoubleKeyBooleanChainedHashMap.access$200(KeySet.access$400(this.this$1)).length ? index : -1;
                }

                public boolean hasNext() {
                    return this.nextEntry != null;
                }

                public double next() {
                    if (this.nextEntry == null) {
                        Exceptions.endOfIterator();
                    }
                    this.currEntry = this.nextEntry;
                    this.nextEntry = this.nextEntry.next;
                    if (this.nextEntry == null) {
                        this.nextList = this.nextList(this.nextList + 1);
                        if (this.nextList != -1) {
                            this.nextEntry = DoubleKeyBooleanChainedHashMap.access$200(KeySet.access$400(this.this$1))[this.nextList];
                        }
                    }
                    return this.currEntry.key;
                }

                public void remove() {
                    if (this.currEntry == null) {
                        Exceptions.noElementToRemove();
                    }
                    KeySet.access$400(this.this$1).remove(this.currEntry.getKey());
                    this.currEntry = null;
                }
            };
        }

        public boolean remove(double v) {
            boolean result = DoubleKeyBooleanChainedHashMap.this.containsKey(v);
            if (result) {
                DoubleKeyBooleanChainedHashMap.this.remove(v);
            }
            return result;
        }

        public int size() {
            return DoubleKeyBooleanChainedHashMap.this.size;
        }

        static /* synthetic */ DoubleKeyBooleanChainedHashMap access$400(KeySet x0) {
            return x0.DoubleKeyBooleanChainedHashMap.this;
        }
    }

    private static class Entry {
        double key;
        boolean value;
        Entry next;

        Entry(double key, boolean value) {
            this.key = key;
            this.value = value;
        }

        public double getKey() {
            return this.key;
        }

        public boolean getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)obj;
            return e.getKey() == this.key && e.getValue() == this.value;
        }
    }
}

