/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.core.parameters;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationParameterNameDiscoverer
implements ParameterNameDiscoverer {
    private final Set<String> annotationClassesToUse;
    private static final ParameterNameFactory<Constructor<?>> CONSTRUCTOR_METHODPARAM_FACTORY = new ParameterNameFactory<Constructor<?>>(){

        @Override
        public int getParamCount(Constructor<?> constructor) {
            return constructor.getParameterTypes().length;
        }

        @Override
        public Annotation[] findAnnotationsAt(Constructor<?> constructor, int index) {
            return constructor.getParameterAnnotations()[index];
        }
    };
    private static final ParameterNameFactory<Method> METHOD_METHODPARAM_FACTORY = new ParameterNameFactory<Method>(){

        @Override
        public int getParamCount(Method method) {
            return method.getParameterTypes().length;
        }

        @Override
        public Annotation[] findAnnotationsAt(Method method, int index) {
            return method.getParameterAnnotations()[index];
        }
    };

    public AnnotationParameterNameDiscoverer(String ... annotationClassToUse) {
        this(new HashSet<String>(Arrays.asList(annotationClassToUse)));
    }

    public AnnotationParameterNameDiscoverer(Set<String> annotationClassesToUse) {
        Assert.notEmpty(annotationClassesToUse, (String)"annotationClassesToUse cannot be null or empty");
        this.annotationClassesToUse = annotationClassesToUse;
    }

    public String[] getParameterNames(Method method) {
        Class<?>[] interfaces;
        Method originalMethod = BridgeMethodResolver.findBridgedMethod((Method)method);
        String[] paramNames = this.lookupParameterNames(METHOD_METHODPARAM_FACTORY, originalMethod);
        if (paramNames != null) {
            return paramNames;
        }
        Class<?> declaringClass = method.getDeclaringClass();
        for (Class<?> intrfc : interfaces = declaringClass.getInterfaces()) {
            Method intrfcMethod = ReflectionUtils.findMethod(intrfc, (String)method.getName(), (Class[])method.getParameterTypes());
            if (intrfcMethod == null) continue;
            return this.lookupParameterNames(METHOD_METHODPARAM_FACTORY, intrfcMethod);
        }
        return paramNames;
    }

    public String[] getParameterNames(Constructor<?> constructor) {
        return this.lookupParameterNames(CONSTRUCTOR_METHODPARAM_FACTORY, constructor);
    }

    private <T extends AccessibleObject> String[] lookupParameterNames(ParameterNameFactory<T> parameterNameFactory, T t) {
        int parameterCount = parameterNameFactory.getParamCount(t);
        String[] paramNames = new String[parameterCount];
        boolean found = false;
        for (int i = 0; i < parameterCount; ++i) {
            Annotation[] annotations = parameterNameFactory.findAnnotationsAt(t, i);
            String parameterName = this.findParameterName(annotations);
            if (parameterName == null) continue;
            found = true;
            paramNames[i] = parameterName;
        }
        return found ? paramNames : null;
    }

    private String findParameterName(Annotation[] parameterAnnotations) {
        for (Annotation paramAnnotation : parameterAnnotations) {
            if (!this.annotationClassesToUse.contains(paramAnnotation.annotationType().getName())) continue;
            return (String)AnnotationUtils.getValue((Annotation)paramAnnotation, (String)"value");
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ParameterNameFactory<T extends AccessibleObject> {
        public int getParamCount(T var1);

        public Annotation[] findAnnotationsAt(T var1, int var2);
    }
}

