/*
 * Decompiled with CFR 0.152.
 */
package org.dlib.xml.reader;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Stack;
import org.dlib.xml.XmlAttribute;
import org.dlib.xml.XmlDocument;
import org.dlib.xml.XmlElement;
import org.dlib.xml.XmlException;
import org.dlib.xml.reader.XmlSimpleReader;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlReader
implements ContentHandler,
ErrorHandler {
    private XmlSimpleReader oldReader;
    private XMLReader saxReader;
    private Stack stack;
    private Locator locator;

    public XmlReader() {
        try {
            this.saxReader = XMLReaderFactory.createXMLReader("org.apache.crimson.parser.XMLReaderImpl");
            this.saxReader.setContentHandler(this);
            this.saxReader.setErrorHandler(this);
        }
        catch (SAXException sAXException) {
            this.oldReader = new XmlSimpleReader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlDocument read(String string) throws FileNotFoundException, IOException, XmlException {
        if (this.oldReader != null) {
            return this.oldReader.read(string);
        }
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8");
        try {
            XmlDocument xmlDocument = this.read(inputStreamReader);
            return xmlDocument;
        }
        finally {
            ((Reader)inputStreamReader).close();
        }
    }

    public XmlDocument read(Reader reader) throws IOException, XmlException {
        if (this.oldReader != null) {
            return this.oldReader.read(reader);
        }
        try {
            this.saxReader.parse(new InputSource(reader));
            XmlElement xmlElement = (XmlElement)this.stack.pop();
            XmlElement xmlElement2 = null;
            List list = xmlElement.getChildren();
            if (list.size() != 0) {
                xmlElement2 = (XmlElement)list.get(0);
            }
            return new XmlDocument(xmlElement2);
        }
        catch (SAXException sAXException) {
            throw new XmlException(sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw iOException;
        }
    }

    public void startDocument() {
        this.stack = new Stack();
        this.stack.push(new XmlElement());
    }

    public void endDocument() {
    }

    public void processingInstruction(String string, String string2) {
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        XmlElement xmlElement = (XmlElement)this.stack.peek();
        XmlElement xmlElement2 = new XmlElement(string2);
        for (int i = 0; i < attributes.getLength(); ++i) {
            xmlElement2.setAttribute(new XmlAttribute(attributes.getLocalName(i), attributes.getValue(i)));
        }
        xmlElement.addChild(xmlElement2);
        this.stack.push(xmlElement2);
    }

    public void endElement(String string, String string2, String string3) {
        this.stack.pop();
    }

    public void skippedEntity(String string) {
        System.out.println("skippedEntity : " + string);
    }

    public void characters(char[] cArray, int n, int n2) {
        XmlElement xmlElement = (XmlElement)this.stack.peek();
        xmlElement.setValue(xmlElement.getValue() + new String(cArray, n, n2));
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
    }

    public void startPrefixMapping(String string, String string2) {
        System.out.println("startPrefixMapping : " + string + ", " + string2);
    }

    public void endPrefixMapping(String string) {
        System.out.println("endPrefixMapping : " + string);
    }

    public void warning(SAXParseException sAXParseException) {
    }

    public void error(SAXParseException sAXParseException) {
        System.out.println("error : " + sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        System.out.println("fatal-error : " + sAXParseException);
        throw new SAXException("Fatal error", sAXParseException);
    }
}

